<?php

namespace App\Http\Controllers;

use App\DataTables\ProvinsisDataTable;
use App\Models\Provinsi;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class ProvinsiController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    // public function index()
    // {   
    //     $q = request()->query('q');
    //     $datas = Provinsi::where('nama','like','%'.$q.'%')->paginate(10)->appends(['q'=>$q]);
    //     return view('provinsi.index',compact('datas','q'));
    // }

    public function index(ProvinsisDataTable $dataTable)
    {
        return $dataTable->render('provinsi.index');
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('provinsi.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'nama' => 'required|unique:provinsis'
        ]);

        DB::beginTransaction();
        try {
            Provinsi::create($request->all());
            DB::commit();
            return redirect()->route('master-data.provinsi.index')->with('success','Data berhasil disimpan');
        } catch (\Throwable $th) {
            Log::error($th->getMessage());
            DB::rollback();
            return redirect()->route('master-data.provinsi.index')->with('error','Data gagal disimpan');
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(Provinsi $provinsi)
    {
        return view('provinsi.show',compact('provinsi'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Provinsi $provinsi)
    {
        return view('provinsi.edit',['data'=>$provinsi]);   
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Provinsi $provinsi)
    {
        $request->validate([
            'nama' => 'required|unique:provinsis,nama,'.$provinsi->id
        ]);

        DB::beginTransaction();
        try {
            $provinsi->update($request->all());
            DB::commit();
            return redirect()->route('master-data.provinsi.index')->with('success','Data berhasil diubah');
        } catch (\Throwable $th) {
            Log::error($th->getMessage());
            DB::rollback();
            return redirect()->route('master-data.provinsi.index')->with('error','Data gagal diubah');
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Provinsi $provinsi)
    {   
        if($provinsi->kabupaten_kotas()->count() > 0){
            return redirect()->back()->with('warning','Data tidak bisa dihapus, data ini masih dipakai di data lain'); 
        }
        DB::beginTransaction();
        try {
            $provinsi->delete();
            DB::commit();
            return redirect()->route('master-data.provinsi.index')->with('success','Data berhasil dihapus');
        } catch (\Throwable $th) {
            Log::error($th->getMessage());
            DB::rollback();
            return redirect()->back()->with('error','Data gagal dihapus');
        }
    }
}
