<?php

namespace App\Http\Controllers;

use App\Helpers\Helper;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Log;

class ProfileSettingController extends Controller
{
    public function index()
    {
        $data = Auth::user();
        return view('profile.setting', compact('data'));
    }

    public function updateProfile(Request $request)
    {
        $user = User::findOrFail(Auth::user()->id);
        $request->validate([
            'nama' => 'required',
            'no_wa' => 'required|unique:users,no_wa,' . $user->id . ',id,deleted_at,NULL',

        ]);

        DB::beginTransaction();
        try {
            $user->update([
                'nama' => $request->nama,
                'email' => $request->email,
                'no_telp' => $request->no_wa,
                'no_wa' => $request->no_wa,
            ]);

            DB::commit();
            Helper::addUserLog("Mengubah profile " . $user->nama);
            return redirect()->back()->with('success', 'Profile berhasil diubah');
        } catch (\Throwable $th) {
            Log::error($th->getMessage());
            DB::rollback();
            return redirect()->back()->with('error', 'Profile gagal diubah')->withInput($request->all());
        }
    }

    public function newPassword()
    {
        return view('profile.new-password');
    }

    public function updatePassword(Request $request)
    {
        $request->validate([
            'password_baru' => 'required|min:5',
            'password_lama' => 'required|min:5',

        ]);

        $user = User::findOrFail(Auth::user()->id);

        $cek = Hash::check($request->password_lama, $user->password);
        if (!$cek) {
            return redirect()->back()->with('error', 'Password lama salah');
        }
        DB::beginTransaction();
        try {
            $user->update([
                'password' => bcrypt($request->password_baru)
            ]);
            DB::commit();
            Helper::addUserLog("Mengubah profile " . $user->nama);
            return redirect()->back()->with('success', 'Password berhasil diubah');
        } catch (\Throwable $th) {
            Log::error($th->getMessage());
            DB::rollback();
            return redirect()->back()->with('error', 'Password gagal diubah')->withInput($request->all());
        }
    }
}
