<?php

namespace App\Http\Controllers;

use App\DataTables\PartaisDataTable;
use App\Models\Partai;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class PartaiController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    // public function index()
    // {   
    //     $q = request()->query('q');
    //     $datas = Partai::where('nama','like','%'.$q.'%')->paginate(10)->appends(['q'=>$q]);
    //     return view('partai.index',compact('datas','q'));
    // }

    public function index(PartaisDataTable $dataTable)
    {   
        return $dataTable->render('partai.index');
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('partai.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'nama' => 'required|unique:partais'
        ]);

        DB::beginTransaction();
        try {
            Partai::create($request->all());
            DB::commit();
            return redirect()->route('master-data.partai.index')->with('success','Data berhasil disimpan');
        } catch (\Throwable $th) {
            Log::error($th->getMessage());
            DB::rollback();
            return redirect()->route('master-data.partai.index')->with('error','Data gagal disimpan');
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(Partai $partai)
    {
        return view('partai.show',compact('partai'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Partai $partai)
    {
        return view('partai.edit',['data'=>$partai]);   
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Partai $partai)
    {
        $request->validate([
            'nama' => 'required|unique:partais,nama,'.$partai->id
        ]);

        DB::beginTransaction();
        try {
            $partai->update($request->all());
            DB::commit();
            return redirect()->route('master-data.partai.index')->with('success','Data berhasil diubah');
        } catch (\Throwable $th) {
            Log::error($th->getMessage());
            DB::rollback();
            return redirect()->route('master-data.partai.index')->with('error','Data gagal diubah');
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Partai $partai)
    {   
        DB::beginTransaction();
        try {
            $partai->delete();
            DB::commit();
            return redirect()->route('master-data.partai.index')->with('success','Data berhasil dihapus');
        } catch (\Throwable $th) {
            Log::error($th->getMessage());
            DB::rollback();
            return redirect()->back()->with('error','Data gagal dihapus');
        }
    }
}
