<?php

namespace App\Http\Controllers;

use App\DataTables\KecamatansDataTable;
use App\Helpers\Helper;
use App\Models\Kecamatan;
use App\Models\KabupatenKota;
use App\Models\Provinsi;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class KecamatanController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    // public function index()
    // {   
    //     $q = request()->query('q');
    //     $datas = Kecamatan::with('kabupaten_kota')->where('nama','like','%'.$q.'%');

    //     if(request()->kabupaten_kota_id){
    //         $datas = $datas->where('kabupaten_kota_id',request()->kabupaten_kota_id);
    //     } else if(request()->provinsi_id){
    //         $datas = $datas->whereHas('kabupaten_kota',function($w){
    //             $w->where('provinsi_id',request()->provinsi_id);
    //         });
    //     }
    //     $datas = $datas->paginate(10)->appends(['q'=>$q]);
    //     $provinsis = Provinsi::all();
    //     return view('kecamatan.index',compact('datas','q','provinsis'));
    // }

    public function index(KecamatansDataTable $dataTable)
    {
        $provinsis = Provinsi::all();
        return $dataTable->render('kecamatan.index', compact('provinsis'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $kabupatenKotas = KabupatenKota::all();
        return view('kecamatan.create', compact('kabupatenKotas'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'nama' => 'required|unique:kecamatans,nama,NULL,NULL,deleted_at,NULL',
            'kabupaten_kota_id' => 'required|exists:kabupaten_kotas,id'
        ]);

        DB::beginTransaction();
        try {
            $kecamatan = Kecamatan::create($request->all());
            DB::commit();
            Helper::addUserLog("Menambah data kecamatan " . $kecamatan->nama);
            return redirect()->route('master-data.kecamatan.index')->with('success', 'Data berhasil disimpan');
        } catch (\Throwable $th) {
            Log::error($th->getMessage());
            DB::rollback();
            return redirect()->route('master-data.kecamatan.index')->with('error', 'Data gagal disimpan');
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(Kecamatan $kecamatan)
    {
        return view('kecamatan.show', compact('kecamatan'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Kecamatan $kecamatan)
    {
        $kabupatenKotas = KabupatenKota::all();
        return view('kecamatan.edit', ['data' => $kecamatan, 'kabupatenKotas' => $kabupatenKotas]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Kecamatan $kecamatan)
    {
        $request->validate([
            'nama' => 'required|unique:kecamatans,nama,' . $kecamatan->id,
            'kabupaten_kota_id' => 'required|exists:kabupaten_kotas,id'
        ]);

        DB::beginTransaction();
        try {
            $kecamatan->update($request->all());
            DB::commit();
            Helper::addUserLog("Mengubah data kecamatan " . $kecamatan->nama);
            return redirect()->route('master-data.kecamatan.index')->with('success', 'Data berhasil diubah');
        } catch (\Throwable $th) {
            Log::error($th->getMessage());
            DB::rollback();
            return redirect()->route('master-data.kecamatan.index')->with('error', 'Data gagal diubah');
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Kecamatan $kecamatan)
    {
        if ($kecamatan->kelurahan_desas()->count() > 0) {
            return redirect()->back()->with('warning', 'Data tidak bisa dihapus, data ini masih dipakai di data lain');
        }
        DB::beginTransaction();
        try {
            $kecamatan->delete();
            DB::commit();
            Helper::addUserLog("Menghapus data kecamatan " . $kecamatan->nama);
            return redirect()->route('master-data.kecamatan.index')->with('success', 'Data berhasil dihapus');
        } catch (\Throwable $th) {
            Log::error($th->getMessage());
            DB::rollback();
            return redirect()->route('master-data.kecamatan.index')->with('error', 'Data gagal dihapus');
        }
    }
}
