<?php

namespace App\Http\Controllers;

use App\DataTables\KabupatenKotasDataTable;
use App\Helpers\Helper;
use App\Models\KabupatenKota;
use App\Models\Provinsi;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class KabupatenKotaController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    // public function index()
    // {   
    //     $q = request()->query('q');
    //     $datas = KabupatenKota::with('provinsi')->where('nama','like','%'.$q.'%')->paginate(10)->appends(['q'=>$q]);
    //     return view('kabupaten-kota.index',compact('datas','q'));
    // }

    public function index(KabupatenKotasDataTable $dataTable)
    {
        return $dataTable->render('kabupaten-kota.index');
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {   
        $provinsis = Provinsi::all();
        return view('kabupaten-kota.create',compact('provinsis'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'nama' => 'required|unique:kabupaten_kotas,nama,NULL,NULL,deleted_at,NULL',
            'provinsi_id' => 'required|exists:provinsis,id'
        ]);

        DB::beginTransaction();
        try {
            $kabupatenKota = KabupatenKota::create($request->all());
            DB::commit();
            Helper::addUserLog("Menambah data kabupaten/kota ".$kabupatenKota->nama);
            return redirect()->route('master-data.kabupaten-kota.index')->with('success','Data berhasil disimpan');
        } catch (\Throwable $th) {
            Log::error($th->getMessage());
            DB::rollback();
            return redirect()->route('master-data.kabupaten-kota.index')->with('error','Data gagal disimpan');
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(KabupatenKota $kabupatenKota)
    {
        return view('kabupaten-kota.show',compact('kabupatenKota'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
    {   
        $kabupatenKota = KabupatenKota::findOrFail($id);
        $provinsis = Provinsi::all();
        return view('kabupaten-kota.edit',['data'=>$kabupatenKota,'provinsis'=>$provinsis]);   
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id)
    {   
        $kabupatenKota = KabupatenKota::findOrFail($id);
        $request->validate([
            'nama' => 'required|unique:kabupaten_kotas,nama,'.$kabupatenKota->id,
            'provinsi_id' => 'required|exists:provinsis,id'
        ]);
        
        DB::beginTransaction();
        try {
            $kabupatenKota->update($request->all());
            DB::commit();
            Helper::addUserLog("Mengubah data kabupaten/kota ".$kabupatenKota->nama);
            return redirect()->route('master-data.kabupaten-kota.index')->with('success','Data berhasil diubah');
        } catch (\Throwable $th) {
            Log::error($th->getMessage());
            DB::rollback();
            return redirect()->route('master-data.kabupaten-kota.index')->with('error','Data gagal diubah');
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {   
        $kabupatenKota = KabupatenKota::findOrFail($id);
        if($kabupatenKota->kecamatans()->count() > 0){
            return redirect()->back()->with('warning','Data tidak bisa dihapus, data ini masih dipakai di data lain'); 
        }
        DB::beginTransaction();
        try {
            $kabupatenKota->delete();
            DB::commit();
            Helper::addUserLog("Menghapus data kabupaten/kota ".$kabupatenKota->nama);
            return redirect()->route('master-data.kabupaten-kota.index')->with('success','Data berhasil dihapus');
        } catch (\Throwable $th) {
            Log::error($th->getMessage());
            DB::rollback();
            return redirect()->route('master-data.kabupaten-kota.index')->with('error','Data gagal dihapus');
        }
    }
}
