<?php

namespace App\Http\Controllers\Api\Mobile;

use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use App\Models\Calon;
use App\Models\FileLampiran;
use App\Models\Suara;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Storage;
use Intervention\Image\Laravel\Facades\Image;

use Pion\Laravel\ChunkUpload\Exceptions\UploadMissingFileException;
use Pion\Laravel\ChunkUpload\Handler\AbstractHandler;
use Pion\Laravel\ChunkUpload\Handler\HandlerFactory;
use Pion\Laravel\ChunkUpload\Receiver\FileReceiver;
use Illuminate\Http\UploadedFile;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Validator;
use Intervention\Image\ImageManager;
use Intervention\Image\Drivers\Imagick\Driver;

class ApiUploadLampiranController extends Controller
{
    public function index()
    {
        $user = Auth::user();
        $suara = Suara::with('tps.kelurahan_desa.kecamatan.kabupaten_kota.provinsi')->where('tps_id', $user->tps_id)->first();
        $file1 = FileLampiran::where('suara_id', @$suara->id)->where('nama', 'lembar-1')->first();
        $file2 = FileLampiran::where('suara_id', @$suara->id)->where('nama', 'lembar-2')->first();
        $file3 = FileLampiran::where('suara_id', @$suara->id)->where('nama', 'lembar-3')->first();
        $calons = Calon::orderBy('nomor', 'ASC')->withSum([
            'suara_details' => function ($w) {
                $w->whereHas('suara', function ($ww) {
                    $ww->where('tps_id', auth()->user()->tps_id);
                });
            }
        ], 'jumlah_suara')->get()->append(['suara']);
        return response()->json([
            'data' => [
                'calons' => $calons,
                'suara' => $suara,
                'file_1' => $file1,
                'file_2' => $file2,
                'file_3' => $file3
            ]
        ]);
    }

    private function cleanString($str)
    {
        return str_replace(" ", "-", trim(str_replace("'", " ", str_replace(".", "", $str))));
    }

    private function formatFileName($prefix, $suara)
    {
        return $prefix . "_"
            . $this->cleanString($suara->tps->nomor) . "_"
            . $this->cleanString($suara->tps->kelurahan_desa->nama) . "_"
            . $this->cleanString($suara->tps->kelurahan_desa->kecamatan->nama) . "_"
            . $this->cleanString($suara->tps->kelurahan_desa->kecamatan->kabupaten_kota->nama) . "_"
            . $this->cleanString($suara->tps->kelurahan_desa->kecamatan->kabupaten_kota->provinsi->nama);
    }

    public function save(Request $request)
    {   
        return response()->json([
            'message'=>"Belum waktunya penginputan suara"
        ],500);
        if(strtotime(date("Y-m-d H:i:s"))<strtotime("2024-11-27 13:45:00")){
            return response()->json([
                'message'=>"Belum waktunya penginputan suara"
            ],500);
        }
        $request->validate([
            'file_1' => 'nullable|file',
            'file_2' => 'nullable|file',
            'file_3' => 'nullable|file',
        ]);

        try {
            $user = Auth::user();
            $suara = Suara::with('tps.kelurahan_desa.kecamatan.kabupaten_kota.provinsi')->where('tps_id', $user->tps_id)->first();
            if (!$suara) {
                $suara = Suara::create([
                    'user_id' => $user->id,
                    'tps_id' => $user->tps_id,
                    'tanggal' => date("Y-m-d"),
                    'total_suara' => 0,
                    'suara_tidak_sah' => 0,
                    'suara_sah' => 0,
                    'jumlah_dpt' => 0,
                    'jumlah_hak_pilih' => 0,
                    'jumlah_surat_suara_digunakan' => 0,
                    'status' => 'approve',

                ]);
                $suara->multi_user()->attach([$user->id]);
            }
            if ($request->hasFile('file_1')) {
                $file = $request->file_1;
                $exte = strtolower($file->getClientOriginalExtension());
                if (strpos($exte, 'php') !== false) {
                    return response()->json([
                        'message' => 'Format file 1 tidak sesuai'
                    ], 403);
                }
                $exte = strtolower(pathinfo($file->getClientOriginalName(), PATHINFO_EXTENSION));
                if (strpos($exte, 'php') !== false) {
                    return response()->json([
                        'message' => 'Format file 1 tidak sesuai'
                    ], 403);
                }
                $lembar1 = FileLampiran::updateOrCreate([
                    'suara_id' => $suara->id,
                    'nama' => 'lembar-1'
                ], [
                    'file' => $request->file('file_1')->storeAs($suara->tps->kelurahan_desa->kecamatan->kabupaten_kota->provinsi->nama . "/" .
                        $suara->tps->kelurahan_desa->kecamatan->kabupaten_kota->nama . "/" .
                        $suara->tps->kelurahan_desa->kecamatan->nama . "/" .
                        $suara->tps->kelurahan_desa->nama . "/" .
                        $suara->tps->nomor, $this->formatFileName('lembar_1', $suara) . "." . $request->file('file_1')->extension())
                ]);
            }

            if ($request->hasFile('file_2')) {
                $file = $request->file_2;
                $exte = strtolower($file->getClientOriginalExtension());
                if (strpos($exte, 'php') !== false) {
                    return response()->json([
                        'message' => 'Format file 2 tidak sesuai'
                    ], 403);
                }
                $exte = strtolower(pathinfo($file->getClientOriginalName(), PATHINFO_EXTENSION));
                if (strpos($exte, 'php') !== false) {
                    return response()->json([
                        'message' => 'Format file 2 tidak sesuai'
                    ], 403);
                }
                $lembar2 = FileLampiran::updateOrCreate([
                    'suara_id' => $suara->id,
                    'nama' => 'lembar-2'
                ], [
                    'file' => $request->file('file_2')->storeAs($suara->tps->kelurahan_desa->kecamatan->kabupaten_kota->provinsi->nama . "/" .
                        $suara->tps->kelurahan_desa->kecamatan->kabupaten_kota->nama . "/" .
                        $suara->tps->kelurahan_desa->kecamatan->nama . "/" .
                        $suara->tps->kelurahan_desa->nama . "/" .
                        $suara->tps->nomor, $this->formatFileName('lembar_2', $suara) . "." . $request->file('file_2')->extension())
                ]);
            }

            if ($request->hasFile('file_3')) {
                $file = $request->file_3;
                $exte = strtolower($file->getClientOriginalExtension());
                if (strpos($exte, 'php') !== false) {
                    return response()->json([
                        'message' => 'Format file 3 tidak sesuai'
                    ], 403);
                }
                $exte = strtolower(pathinfo($file->getClientOriginalName(), PATHINFO_EXTENSION));
                if (strpos($exte, 'php') !== false) {
                    return response()->json([
                        'message' => 'Format file 3 tidak sesuai'
                    ], 403);
                }
                $lembar3 = FileLampiran::updateOrCreate([
                    'suara_id' => $suara->id,
                    'nama' => 'lembar-3'
                ], [
                    'file' => $request->file('file_3')->storeAs($suara->tps->kelurahan_desa->kecamatan->kabupaten_kota->provinsi->nama . "/" .
                        $suara->tps->kelurahan_desa->kecamatan->kabupaten_kota->nama . "/" .
                        $suara->tps->kelurahan_desa->kecamatan->nama . "/" .
                        $suara->tps->kelurahan_desa->nama . "/" .
                        $suara->tps->nomor, $this->formatFileName('lembar_3', $suara) . "." . $request->file('file_3')->extension())
                ]);
            }

            Helper::addUserLog("Mengupload file lampiran", json_encode([
                @$lembar1,
                @$lembar2,
                @$lembar3
            ]));

            return response()->json([
                'data' => [
                    'file_1' => @$lembar1,
                    'file_2' => @$lembar2,
                    'file_3' => @$lembar3
                ]
            ]);
        } catch (\Throwable $th) {
            //throw $th;
            Log::error($th);
            return response()->json([
                'message' => 'Gagal mengupload file : ' . $th->getMessage()
            ], 500);
        }
    }

    public function getFileLampiran($id)
    {

        $fileLampiran = FileLampiran::findOrFail($id);
        $path = $fileLampiran->file;

        if (Storage::exists($path)) {
            try {
                $mimeType = Storage::mimeType($path);
                if (strpos($mimeType, 'php') !== false) {
                    return response()->json([
                        'error'=>'Format file tidak sesuai'
                    ]);
                }
                $exte = strtolower(pathinfo(storage_path("app/" . $path), PATHINFO_EXTENSION));
                if (strpos($exte, 'php') !== false) {
                    return response()->json([
                        'error'=>'Format file tidak sesuai'
                    ]);
                }
                if (strpos(file_get_contents(storage_path("app/" . $path)), '<?php') !== false) {
                    return response()->json([
                        'error'=>'Yakin ini file gambar?'
                    ]);
                }
                $filename = basename($path);
                if (request()->size == "small") {
                    try {
                        try {
                            $manager = new ImageManager(
                                driver: Driver::class,
                                autoOrientation: config('image.options.autoOrientation', true),
                                decodeAnimation: config('image.options.decodeAnimation', true),
                                blendingColor: config('image.options.blendingColor', 'ffffff')
                            );
                            $img = $manager->read(storage_path("app/" . $path));
                            
                        } catch (\Throwable $th) {
                            $img = Image::read(storage_path("app/" . $path));
                        }
                        // $img->resize(100, 100);
                        $img->scaleDown(width: 150);
                        
                        return response($img->toJpeg(50), 200)
                        ->header('Content-Type', $mimeType)
                        ->header('Content-Disposition', 'inline; filename=' . '"' . $filename . '"')
                        ->header( "Connection", "Keep-Alive");
                    } catch (\Throwable $th) {
                        //throw $th;
                    }
                    
                }
                return response()->file(storage_path("app/" . $path), [
                    'Content-Type' => $mimeType,
                    'Content-Disposition' => 'inline; filename=' . '"' . $filename . '"',
                    "Connection" => "Keep-Alive",
                ]);
            } catch (\Throwable $th) {
                Log::error($th);
                Log::error($fileLampiran);
                return abort(404);
            }
            
        } else {
            return abort(404);
        }

    }

    /**
     * Saves the file
     *
     * @param UploadedFile $file
     *
     * @return \Illuminate\Http\JsonResponse
     */
    protected function saveFile(UploadedFile $file, $name)
    {   
        if(strtotime(date("Y-m-d H:i:s"))<strtotime("2024-11-27 13:45:00")){
            return response()->json([
                'message'=>"Belum waktunya penginputan suara"
            ],500);
        }
        $user = auth()->user();
        $suara = Suara::with('tps.kelurahan_desa.kecamatan.kabupaten_kota.provinsi')->where('tps_id', $user->tps_id)->first();


        if (!$suara) {
            $suara = Suara::create([
                'user_id' => $user->id,
                'tps_id' => $user->tps_id,
                'tanggal' => date("Y-m-d"),
                'total_suara' => 0,
                'suara_tidak_sah' => 0,
                'suara_sah' => 0,
                'jumlah_dpt' => 0,
                'jumlah_hak_pilih' => 0,
                'jumlah_surat_suara_digunakan' => 0,
                'status' => 'approve',

            ]);
            $suara->multi_user()->attach([$user->id]);
        }

       

        $mime = str_replace('/', '-', $file->getMimeType());
        
        // $filePath = "public/uploads/chunk_uploads/";
        // $fileName = $this->createFilename($file,$name,$suara);

        $filePath = $suara->tps->kelurahan_desa->kecamatan->kabupaten_kota->provinsi->nama . "/" .
            $suara->tps->kelurahan_desa->kecamatan->kabupaten_kota->nama . "/" .
            $suara->tps->kelurahan_desa->kecamatan->nama . "/" .
            $suara->tps->kelurahan_desa->nama . "/" .
            $suara->tps->nomor;
        $fileName = $this->formatFileName($name, $suara) . "." . $file->extension();

        if($mime == "bin" || $file->extension() == "bin"){
            Log::errror("Upload Chunk Error : ".$filePath . "/" . $fileName);
            throw new \Exception("File ".$name." tidak dapat diunggah silahkan coba lagi");
        }

        if(str_contains($mime,"php") || str_contains($file->extension(),"php")){
            Log::errror("FORMAT FILE PHP : ".$filePath . "/" . $fileName);
            throw new \Exception("Format file tidak sesuai");
        }

        $resultPath = $file->move(storage_path("app/" . $filePath), $fileName);

        $lembar = FileLampiran::updateOrCreate([
            'suara_id' => $suara->id,
            'nama' => $name
        ], [
            'file' => $filePath . "/" . $fileName,
        ]);

        Helper::addUserLog("Mengupload gambar C Hasil " . $name, json_encode($lembar));

        return [
            'link' => url("api/file-lampiran/" . $lembar->id) . "?t=" . date("YmdHis"),
            'mime_type' => $mime
        ];
    }
    /**
     * Create unique filename for uploaded file
     * @param UploadedFile $file
     * @return string
     */
    protected function createFilename(UploadedFile $file)
    {
        $extension = $file->getClientOriginalExtension();
        $filename = rand() . time() . "." . $extension;
        return $filename;
    }

    public function chunkUpload(Request $request)
    {   
        if(strtotime(date("Y-m-d H:i:s"))<strtotime("2024-11-27 13:45:00")){
            return response()->json([
                'message'=>"Belum waktunya penginputan suara"
            ],500);
        }
        $validator = Validator::make($request->all(), [

            'file' => 'required|file',
            'name' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json(['status' => false, 'message' => $validator->errors()->first()]);
        }

        $receiver = new FileReceiver('file', $request, HandlerFactory::classFromRequest($request));
        if ($receiver->isUploaded() === false) {
            throw new UploadMissingFileException();
        }
        $save = $receiver->receive();
        if ($save->isFinished()) {

            try {
                $response = $this->saveFile($save->getFile(), $request->name);

                File::deleteDirectory(storage_path('app/chunks/'));

                //your data insert code

                return response()->json([
                    'status' => true,
                    'link' => url($response['link']),
                    'message' => 'File successfully uploaded.'
                ]);
            } catch (\Throwable $th) {
                //throw $th;
                return response()->json(['message' => $th->getMessage()],500);
            }
        }
        $handler = $save->handler();
        return response()->json([
            "done" => $handler->getPercentageDone()
        ]);
    }
}
