<?php

namespace App\Http\Controllers\Api\Mobile;

use App\Http\Controllers\Controller;
use App\Models\Calon;
use App\Models\Dpt;
use App\Models\Suara;
use App\Models\Tps;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ApiLihatSuaraController extends Controller
{
    public function getData()
    {
        $user = Auth::user()->load(['tps', 'kelurahan_desa']);
        $calons = Calon::orderBy('nomor', 'ASC')->withSum([
            'suara_details' => function ($w) {
                $w->whereHas('suara', function ($ww) {
                    $ww->where('tps_id', auth()->user()->tps_id);
                });
            }
        ], 'jumlah_suara')->get()->append(['suara']);
        $suara = Suara::with(relations: 'suara_details')->where('tps_id', $user->tps_id)->first();
        $totalDpt = Dpt::where('tps_id', $user->tps_id)->count();
        $tps = Tps::with([
            'kelurahan_desa' => function ($w) {
                $w->with([
                    'users' => function ($wu) {
                        $wu->where('role', 'koordinator-kelurahan-desa');
                    }
                ]);
            }
        ])->find($user->tps_id);

        return response()->json([
            'data' => [
                'calons'=>$calons,
                'suara'=>$suara,
                'total_dpt'=>(int)$totalDpt,
                'tps'=>(int)$tps->nomor,
                'kelurahan_desa'=>$tps->kelurahan_desa->nama,
                'user_koordinator'=>@$tps->kelurahan_desa->users[0]->nama
            ]
        ]);
    }
}
