<?php

namespace App\Http\Controllers\Api\Mobile;

use App\Http\Controllers\Controller;
use App\Models\Calon;
use App\Models\Dpt;
use App\Models\FileLampiran;
use App\Models\Pengumuman;
use App\Models\Suara;
use App\Models\Tps;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ApiDashboardController extends Controller
{
    public function dataDashboard()
    {

        $user = Auth::user()->load(['tps', 'kelurahan_desa', 'kelurahan_desa.kecamatan', 'kelurahan_desa.kecamatan.kabupaten_kota']);
        $jumlahCalon = Calon::count();
        $totalSuara = Suara::where('tps_id', $user->tps_id)->sum('total_suara');
        $totalDpt = Dpt::where('tps_id', $user->tps_id)->count();
        $totalFoto = FileLampiran::whereHas('suara', function ($w) use ($user) {
            $w->where('user_id', $user->id)->where('tps_id', $user->tps_id);
        })->count();
        $tps = Tps::with([
            'kelurahan_desa' => function ($w) {
                $w->with([
                    'users' => function ($wu) {
                        $wu->where('role', 'koordinator-kelurahan-desa');
                    }
                ]);
            }
        ])->find($user->tps_id);

        

        $user_koordes = implode(",", User::where('role', 'koordinator-kelurahan-desa')->where('kelurahan_desa_id', $tps->kelurahan_desa_id)->whereHas('multi_tps', function ($w) use ($user) {
            $w->where('tps_id', $user->tps_id);
        })->get()->pluck('nama')->toArray());

        $user_koorcam = implode(",", User::where('role', 'koordinator-kecamatan')->where('kecamatan_id', $tps->kelurahan_desa->kecamatan_id)->get()->pluck('nama')->toArray());

        $data = [
            'no_wa' => $user->no_wa,
            'nama' => $user->nama,
            'jumlah_calon' => (int) $jumlahCalon,
            'total_suara' => (int) $totalSuara,
            'total_dpt' => (int) $totalDpt,
            'total_foto' => (int) $totalFoto,
            'kelurahan_desa_id' => (int) $tps->kelurahan_desa_id,
            'kelurahan_desa' => $tps->kelurahan_desa->nama,
            'kecamatan_id' => (int) $tps->kelurahan_desa->kecamatan_id,
            'kecamatan' => $tps->kelurahan_desa->kecamatan->nama,
            'kabupaten_kota_id' => (int) $tps->kelurahan_desa->kecamatan->kabupaten_kota_id,
            'kabupaten_kota' => $tps->kelurahan_desa->kecamatan->kabupaten_kota->nama,
            'tps_id' => (int) $tps->id,
            'partai_id' => $user->partai_id,
            'tps' => (int) $tps->nomor,
            'user_koordinator' => @$tps->kelurahan_desa->users[0]->nama,
            'user_koordes' => $user_koordes,
            'user_koorcam' => $user_koorcam,
            'pengumuman' => null,
            'koordinator_kelurahan_desa' => User::where('role', 'koordinator-kelurahan-desa')->where('kelurahan_desa_id', $tps->kelurahan_desa_id)->whereHas('multi_tps', function ($w) use ($user) {
                $w->where('tps_id', $user->tps_id);
            })->get(),
            'koordinator_kecamatan' => User::where('role', 'koordinator-kecamatan')->where('kecamatan_id', $tps->kelurahan_desa->kecamatan_id)->get()
        ];
        $pengumuman = Pengumuman::where(function($w)use($tps,$user){
            $w->whereNull('provinsi_id')
            ->orWhereNull('kabupaten_kota_id')
            ->orWhere('kabupaten_kota_id',$tps->kelurahan_desa->kecamatan->kabupaten_kota_id)
            ->orWhere('kecamatan_id',$tps->kelurahan_desa->kecamatan_id)
            ->orWhere('kelurahan_desa_id',$tps->kelurahan_desa_id)
            ->orWhere('user_saksi_id',$user->id)
            ->orWhere('partai_id',$user->partai_id);
        })
        ->where('aktif',1)
        ->latest()->first();

        $pengumumans = Pengumuman::where(function($w)use($tps,$user){
            $w->whereNull('provinsi_id')
            ->orWhereNull('kabupaten_kota_id')
            ->orWhere('kabupaten_kota_id',$tps->kelurahan_desa->kecamatan->kabupaten_kota_id)
            ->orWhere('kecamatan_id',$tps->kelurahan_desa->kecamatan_id)
            ->orWhere('kelurahan_desa_id',$tps->kelurahan_desa_id)
            ->orWhere('user_saksi_id',$user->id)
            ->orWhere('partai_id',$user->partai_id);
        })
        ->where('aktif',1)
        ->latest()->limit(3)->get();
        $data['pengumumans'] = $pengumumans->map(function($p){
            $p->diff_human = $p->created_at->diffForHumans();
            return $p;
        });
        if ($pengumuman) {
            $data['pengumuman'] = [
                'id' => (string) $pengumuman->id,
                'judul' => $pengumuman->judul,
                'isi' => $pengumuman->isi,
                'pertanyaan' => (string) $pengumuman->pertanyaan,
                'diff_human' => $pengumuman->created_at->diffForHumans()
            ];
        }
        return response()->json([
            'data' => $data
        ]);
    }

    public function jawabPengumuman($id, Request $request)
    {
        $auth = Auth::user();
        $pengumuman = Pengumuman::find($id);
        $iya = $request->iya;
        $pengumuman->pengumuman_jawabs()->updateOrCreate(['user_id' => $auth->id], [

            'iya' => $iya,
        ]);
        return response()->json(['message' => 'Jawaban berhasil dikirim']);
    }
}
