<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Imports\DpsImport;
use App\Imports\DptImport;
use App\Imports\FirstSheeDptImport;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Facades\Excel;

class ApiUploadController extends Controller
{
    public function upload(Request $request){
        ini_set('post_max_size','100M');
        ini_set('upload_max_filesize','100M');
        ini_set('memory_limit','2048M');
        //timeout
        ini_set('max_execution_time', 2400);
        $request->validate([
            'file' => 'required|mimes:xlsx,xls'
        ]);

        $file = $request->file('file');
        $newImport = new FirstSheeDptImport();
        if($request->has('kabupaten_kota_id')){
            $newImport->metode = "2";
            $newImport->kabupaten_kota_id = $request->kabupaten_kota_id;
        }
        $import = Excel::import($newImport,$file);
        // DB::beginTransaction();
        // $import = Excel::import($newImport,$file);
        // DB::commit();
        return response()->json([
            'message'=>'ok'
        ]);
    }
}
