<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Dpt;
use App\Models\KabupatenKota;
use App\Models\Kecamatan;
use App\Models\KelurahanDesa;
use App\Models\Tps;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class ApiUpdateController extends Controller
{
    private function normalizeKota($kota)
    {
        $kota = strtolower(trim($kota));
        $newKota = strtoupper($kota);
        switch ($kota) {
            case 'balikpapan':
                $newKota = "KOTA BALIKPAPAN";
                break;
            case 'samarinda':
                $newKota = "KOTA SAMARINDA";
                break;
            case 'bontang':
                $newKota = "KOTA BONTANG";
                break;
            case 'kota balikpapan':
                $newKota = "KOTA BALIKPAPAN";
                break;
            case 'kota samarinda':
                $newKota = "KOTA SAMARINDA";
                break;
            case 'kota bontang':
                $newKota = "KOTA BONTANG";
                break;
            case 'penajam paser utara':
                $newKota = "KAB. PENAJAM PASER UTARA";
                break;
            case 'paser':
                $newKota = "KAB. PASER";
                break;
            case 'kutai kartanegara':
                $newKota = "KAB. KUTAI KARTANEGARA";
                break;
            case 'kutai barat':
                $newKota = "KAB. KUTAI BARAT";
                break;
            case 'kutai timur':
                $newKota = "KAB. KUTAI TIMUR";
                break;
            case 'berau':
                $newKota = "KAB. BERAU";
                break;
            case 'mahakam ulu':
                $newKota = "KAB. MAHAKAM ULU";
                break;
            default:
                # code...
                break;
        }
        return $newKota;
    }
    public function update(Request $request)
    {

        $jsonDatas = json_decode($request->getContent(), false);
        if (count($jsonDatas) <= 0) {
            throw new Exception("No Data");
        }

        $kabupatenKota = KabupatenKota::where('nama', $this->normalizeKota($jsonDatas[0]->kabupaten_kota))->first();
        if (!$kabupatenKota) {
            Log::info("Kabupaten Kota Not Found : " . $jsonDatas[0]->kabupaten_kota);
            throw new Exception("Kabupaten Kota Not Found : " . $jsonDatas[0]->kabupaten_kota);
        }
        $kecamatan = Kecamatan::where('nama', $jsonDatas[0]->kecamatan)->where('kabupaten_kota_id', $kabupatenKota->id)->first();
        if (!$kecamatan) {
            $kecamatan = Kecamatan::create([
                'nama' => $jsonDatas[0]->kecamatan,
                'kabupaten_kota_id' => $kabupatenKota->id,
            ]);
        }
        $kelurahanDesa = $kecamatan->kelurahan_desas()->where('nama', $jsonDatas[0]->kelurahan_desa)->first();
        if (!$kelurahanDesa) {
            $kelurahanDesa = KelurahanDesa::create([
                'nama' => $jsonDatas[0]->kelurahan_desa,
                'kecamatan_id' => $kecamatan->id,
            ]);
        }
        $tps = Tps::where('nomor', (int) $jsonDatas[0]->tps)->where('kelurahan_desa_id', $kelurahanDesa->id)->first();
        if (!$tps) {
            $tps = Tps::create([
                'nomor' => (int) $jsonDatas[0]->tps,
                'kelurahan_desa_id' => $kelurahanDesa->id,
                'rt_rw' => ''
            ]);
        }
        DB::beginTransaction();
        try {
            foreach ($jsonDatas as $data) {
                $dpt = Dpt::firstOrCreate([
                    'nama' => $data->nama,
                    'jenis_kelamin' => $data->jenis_kelamin,
                    'usia' => $data->usia,
                    'rt' => (int) $data->rt,
                    'rw' => (int) $data->rw,
                    // 'ket' => $data->keterangan,
                    // 'alamat' => $data->alamat,
                    'tps_id' => $tps->id,
                ]);
            }
            DB::commit();
            return response()->json([
                "message" => "okoc"
            ]);
        } catch (\Throwable $th) {
            DB::rollBack();
            return response()->json([
                "message" => "error"
            ], 500);
        }


    }

    public function updateNik(Request $request)
    {
        $jsonDatas = json_decode($request->getContent(), false);
        if (count($jsonDatas) <= 0) {
            throw new Exception("No Data");
        }

        $kabupatenKota = KabupatenKota::where('nama', $this->normalizeKota($jsonDatas[0]->kabupaten_kota))->first();
        if (!$kabupatenKota) {
            throw new Exception("Kabupaten Kota Not Found : " . $jsonDatas[0]->kabupaten_kota);
        }

        foreach ($jsonDatas as $data) {
            $kecamatan = Kecamatan::where('nama', $data->kecamatan)->where('kabupaten_kota_id', $kabupatenKota->id)->first();
            if (!$kecamatan) {
                throw new Exception("No Kecamatan : ".$data->kecamatan);
            }
            $kelurahanDesa = $kecamatan->kelurahan_desas()->where('nama', $data->kelurahan_desa)->first();
            if (!$kelurahanDesa) {
                throw new Exception("No Keluranan/Desa : ".$data->kelurahan_desa);
            }
            $tps = Tps::where('nomor', (int) $data->tps)->where('kelurahan_desa_id', $kelurahanDesa->id)->first();
            if (!$tps) {
                continue;
            }

            $cekDpt = Dpt::where('nama','=',$data->nama)
            ->where('jenis_kelamin','=',$data->jenis_kelamin)
            ->where('usia','=',$data->usia)
            ->where('rt','=',(int) $data->rt)
            ->where('rw','=',(int) $data->rw)
            ->where('tps_id','=',$tps->id)
            ->whereNull('nik')
            ->first();

            if($cekDpt){
                $cekDpt->update([
                    'alamat' => $data->alamat,
                    'nik' => $data->nik,
                    'no_kk'=> $data->no_kk
                ]);
            } else {
                // $dpt = Dpt::firstOrCreate([
                //     'nik' => $data->nik,
                //     'no_kk'=> $data->no_kk,
                //     'nama' => $data->nama,
                //     'jenis_kelamin' => $data->jenis_kelamin,
                //     'usia' => $data->usia,
                //     'rt' => (int) $data->rt,
                //     'rw' => (int) $data->rw,
                //     'alamat' => $data->alamat,
                //     'tps_id' => $tps->id,
                // ]);
            }

            return response()->json([
                "message" => "okoc"
            ]);
        }
    }

    public function updateTps(Request $request)
    {

        $jsonDatas = json_decode($request->getContent(), false);
        if (count($jsonDatas) <= 0) {
            throw new Exception("No Data");
        }

        foreach ($jsonDatas as $data) {
            $kabupatenKota = KabupatenKota::where('nama', $this->normalizeKota($data->kabupaten_kota))->first();
            if (!$kabupatenKota) {
                Log::info("Kabupaten Kota Not Found : " . $data->kabupaten_kota);
                throw new Exception("Kabupaten Kota Not Found : " . $data->kabupaten_kota);
            }
            $kecamatan = Kecamatan::where('nama', $data->kecamatan)->where('kabupaten_kota_id', $kabupatenKota->id)->first();
            if (!$kecamatan) {
                $kecamatan = Kecamatan::create([
                    'nama' => $data->kecamatan,
                    'kabupaten_kota_id' => $kabupatenKota->id,
                ]);
            }
            $kelurahanDesa = $kecamatan->kelurahan_desas()->where('nama', $data->kelurahan_desa)->first();
            if (!$kelurahanDesa) {
                $kelurahanDesa = KelurahanDesa::create([
                    'nama' => $data->kelurahan_desa,
                    'kecamatan_id' => $kecamatan->id,
                ]);
            }
            $tps = Tps::firstOrCreate([
                'nomor' => (int) $data->tps,
                'kelurahan_desa_id' => $kelurahanDesa->id,
                'rt_rw' => ''
            ]);
        }

        return response()->json([
            "message" => "okoc"
        ]);
    }
}
