<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\DB;

class ApiStatusServerController extends Controller
{
    public function index()
    {
        $total_space = disk_total_space("/");
        $free_space = disk_free_space("/");
        $used_space = $total_space - $free_space;



        $totalDB = DB::select('SELECT 
        ROUND(sum(data_length + index_length)/1024/1024) AS "db_size"
    FROM information_schema.TABLES 
    WHERE TABLE_SCHEMA = "' . env("DB_DATABASE") . '"
    GROUP BY TABLE_SCHEMA;')[0]->db_size;

        $data = [
            'total' => round($total_space / (1024 * 1024 * 1024), 2),
            'used' => round($used_space / (1024 * 1024 * 1024), 2),
            'free' => round($free_space / (1024 * 1024 * 1024), 2),
            'totalDB' => $totalDB
        ];
        return response()->json([
            'data' => $data
        ]);
    }
}
