<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Calon;
use App\Models\Dpt;
use App\Models\KabupatenKota;
use App\Models\Provinsi;
use App\Models\Suara;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ApiJumlahSuaraController extends Controller
{
    public function jumlahSuaraCalon(Request $request)
    {
        $calons = Calon::withSum([
            'suara_details'=>function($w)use($request){
                $w->whereHas('suara',function($w)use($request){
                    $w->where('status','approve');

                    if($request->kabupaten_kota_id != ""){
                        $w->whereHas('tps.kelurahan_desa.kecamatan',function($w)use($request){
                            $w->where('kabupaten_kota_id',$request->kabupaten_kota_id);
                        });
                    }

                    if($request->kecamatan_id != ""){
                        $w->whereHas('tps.kelurahan_desa',function($w)use($request){
                            $w->where('kecamatan_id',$request->kecamatan_id);
                        });
                    }

                    if($request->kelurahan_desa_id != ""){
                        $w->whereHas('tps',function($w)use($request){
                            $w->where('kelurahan_desa_id',$request->kelurahan_desa_id);
                        });
                    }
                });

                
            }
        ], 'jumlah_suara')->get()->map(function($data){
            return [
                "id"=>$data->id,
                "nomor"=>$data->nomor,
                "nama_calon"=>$data->nama_calon,
                "nama_wakil_calon"=>$data->nama_wakil_calon,
                "foto_pasangan"=>url($data->foto_pasangan),
                "jumlah_suara"=>(int)$data->suara_details_sum_jumlah_suara
            ];
        })->toArray();

        $suaraTidakSah = Suara::where('status','approve');
        if($request->kabupaten_kota_id != ""){
            $suaraTidakSah = $suaraTidakSah->whereHas('tps.kelurahan_desa.kecamatan',function($w)use($request){
                $w->where('kabupaten_kota_id',$request->kabupaten_kota_id);
            });
        }

        if($request->kecamatan_id != ""){
            $suaraTidakSah = $suaraTidakSah->whereHas('tps.kelurahan_desa',function($w)use($request){
                $w->where('kecamatan_id',$request->kecamatan_id);
            });
        }

        if($request->kelurahan_desa_id != ""){
            $suaraTidakSah = $suaraTidakSah->whereHas('tps',function($w)use($request){
                $w->where('kelurahan_desa_id',$request->kelurahan_desa_id);
            });
        }
        $calons[] = [
            "jumlah_suara_tidak_sah" => (int)$suaraTidakSah->sum('suara_tidak_sah')
        ];
        return $calons;
    }

    public function jumlahSuaraProvinsi()
    {
        $hasilSuara = Provinsi::join('kabupaten_kotas', 'provinsis.id', '=', 'kabupaten_kotas.provinsi_id')
            ->join('kecamatans', 'kabupaten_kotas.id', '=', 'kecamatans.kabupaten_kota_id')
            ->join('kelurahan_desas', 'kecamatans.id', '=', 'kelurahan_desas.kecamatan_id')
            ->join('tps', 'kelurahan_desas.id', '=', 'tps.kelurahan_desa_id')
            ->leftJoin('suaras', function ($join) {
                $join->on('suaras.tps_id', '=', 'tps.id')
                    ->on('suaras.status', '=', DB::raw('"approve"'));
            })
            ->join('suara_details', 'suaras.id', '=', 'suara_details.suara_id')
            ->join('calons', 'suara_details.calon_id', '=', 'calons.id')
            ->selectRaw('provinsis.nama as provinsi, calons.nama_calon as calon, calons.nama_wakil_calon as wakil, SUM(suara_details.jumlah_suara) as total_suara')
            ->where('suaras.status', 'approve')
            ->groupBy('provinsis.id', 'calons.id')
            ->get();

        return $hasilSuara;
    }

    public function jumlahSuaraKabupatenKota($provinsi_id)
    {
        $kotas = KabupatenKota::all();
        $calonSuaraPerKota = Calon::select('calons.id as calon_id', 'calons.nama_calon as calon', 'calons.nama_wakil_calon as wakil_calon', 'kabupaten_kotas.id as kabupaten_kota_id', 'kabupaten_kotas.nama as kota', DB::raw('SUM(suara_details.jumlah_suara) as total_suara'), DB::raw('SUM(suaras.suara_tidak_sah) as total_suara_tidak_sah'))
            ->leftJoin('suara_details', 'suara_details.calon_id', '=', 'calons.id')
            ->leftJoin('suaras', function ($join) {
                $join->on('suaras.id', '=', 'suara_details.suara_id')
                    ->on('suaras.status', '=', DB::raw('"approve"'));
            })
            ->leftJoin('tps', 'tps.id', '=', 'suaras.tps_id')
            ->leftJoin('kelurahan_desas', 'kelurahan_desas.id', '=', 'tps.kelurahan_desa_id')
            ->leftJoin('kecamatans', 'kecamatans.id', '=', 'kelurahan_desas.kecamatan_id')
            ->leftJoin('kabupaten_kotas', 'kabupaten_kotas.id', '=', 'kecamatans.kabupaten_kota_id')
            ->where('kabupaten_kotas.provinsi_id', $provinsi_id)
            ->groupBy('calons.id', 'kabupaten_kotas.id')
            ->get();
        $calons = Calon::all();
        $hasil = [];

        foreach ($kotas as $index => $kota) {
            $hasil[$index] = [
                "id"=>$kota->id,
                "nama" => $kota->nama,
                "total_suara" => 0,
                "total_suara_tidak_sah" => 0,
                "calon"=>[]
            ];

            foreach ($calons as $calon) {
                $hasil[$index]['calon'][] = [
                    "id"=>$calon->id,
                    "nama_calon" => $calon->nama_calon,
                    "nama_wakil_calon" => $calon->nama_wakil_calon,
                    'total_suara' => 0,
                ];
            }
            
            // foreach ($calonSuaraPerKota as $suara) {
            //     $hasil[$index]['calon'][] = [
            //         "id"=>$suara->calon_id,
            //         "nama_calon" => $suara->calon,
            //         "nama_wakil_calon" => $suara->wakil_calon,
            //         'total_suara' => 0,
            //     ];
            // }
            
            
        }

      
        foreach ($calonSuaraPerKota as $suara) {
            $index = -1;
            foreach ($hasil as $key => $value) {
                if($value['id'] == $suara->kabupaten_kota_id){
                    $index = $key;
                    break;
                }
            }
            if($index >= 0){
                foreach ($hasil[$index]['calon'] as $key => $calon) {
                    if($calon['id'] == $suara->calon_id){
                        $hasil[$index]['calon'][$key] = [
                            "id" => $suara->calon_id,
                            "nama_calon" => $suara->calon,
                            "nama_wakil_calon" => $suara->wakil_calon,
                            'total_suara' => (int) $suara->total_suara,
                        ];
                    }
                }
                
                $hasil[$index]['total_suara'] += (int) $suara->total_suara;
                $hasil[$index]['total_suara_tidak_sah'] = (int) $suara->total_suara_tidak_sah;
            }
        }

        foreach ($hasil as $key => $value) {
            $hasil[$key]['total_suara'] += $hasil[$key]['total_suara_tidak_sah'];
        }

        

        
        return $hasil;
        // $hasilSuara = KabupatenKota::select('kabupaten_kotas.id', 'kabupaten_kotas.nama as kota', 'calons.nama_calon as calon','calons.id as calon_id', DB::raw('SUM(suara_details.jumlah_suara) as total_suara'), DB::raw('SUM(suaras.suara_tidak_sah) as total_suara_tidak_sah'))
        //     ->leftJoin('kecamatans', 'kecamatans.kabupaten_kota_id', '=', 'kabupaten_kotas.id')
        //     ->leftJoin('kelurahan_desas', 'kelurahan_desas.kecamatan_id', '=', 'kecamatans.id')
        //     ->leftJoin('tps', 'tps.kelurahan_desa_id', '=', 'kelurahan_desas.id')
        //     ->leftJoin('suaras', function($join){
        //         $join->on('suaras.tps_id', '=', 'tps.id')
        //         ->on('suaras.status', '=', DB::raw('"approve"'));
        //     })
        //     ->leftJoin('suara_details', 'suara_details.suara_id', '=', 'suaras.id')
        //     ->leftJoin('calons', 'calons.id', '=', 'suara_details.calon_id')
        //     ->where('kabupaten_kotas.provinsi_id', $provinsi_id)
        //     ->groupBy('kabupaten_kotas.id', 'calons.id')
        //     ->get();
        // $results = [];
        // foreach ($hasilSuara as $hasil) {
        //     $results[$hasil->calon_id][] = [
        //         "kota"=>$hasil->kota
        //     ];
        // }
        // return $hasilSuara;
    }

    public function totalSuara(){
        $totalSuara = Suara::sum('total_suara');
        $jumlahDpt = Dpt::count();
        $jumlahDptTps = Suara::sum('jumlah_dpt');
        $jumlahSuaraSah = Suara::sum('suara_sah');
        $jumlahSuaraTidakSah = Suara::sum('suara_tidak_sah');
        return [
            "total_suara"=>(int)$totalSuara,
            "jumlah_dpt"=>(int)$jumlahDpt,
            "jumlah_dpt_tps"=>(int)$jumlahDptTps,
            "suara_sah"=>(int)$jumlahSuaraSah,
            "suara_tidak_sah"=>(int)$jumlahSuaraTidakSah
        ];
    }
}
