<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Calon;
use App\Models\Dpt;
use App\Models\FileLampiran;
use App\Models\Pengumuman;
use App\Models\Suara;
use App\Models\Tps;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ApiAuthController extends Controller
{
    public function login(Request $request)
    {
        //email and password
        //validate
        $request->validate([
            'no_telp' => 'required|min:10|max:20',
            'password' => 'required'
        ]);
        $credentials = $request->only('no_telp', 'password');
        $credentials['status'] = 'sesuai';
        $cek = auth()->attempt($credentials);

        if ($cek) {
            if (auth()->user()->role == "saksi") {
                $user = Auth::user()->load(['tps', 'kelurahan_desa', 'kelurahan_desa.kecamatan', 'kelurahan_desa.kecamatan.kabupaten_kota']);
                $user->tokens()->delete();
                $tps = Tps::with([
                    'kelurahan_desa' => function ($w) {
                        $w->with([
                            'users' => function ($wu) {
                                $wu->where('role', 'koordinator-kelurahan-desa');
                            }
                        ]);
                    }
                ])->find($user->tps_id);
                $user_koordes = implode(",", User::where('role', 'koordinator-kelurahan-desa')->where('kelurahan_desa_id', $tps->kelurahan_desa_id)->whereHas('multi_tps', function ($w) use ($user) {
                    $w->where('tps_id', $user->tps_id);
                })->get()->pluck('nama')->toArray());

                $user_koorcam = implode(",", User::where('role', 'koordinator-kecamatan')->where('kecamatan_id', $tps->kelurahan_desa->kecamatan_id)->get()->pluck('nama')->toArray());

                $jumlahCalon = Calon::count();
                $totalSuara = Suara::whereHas('multi_user',function($w)use($user){
                    $w->where('user_id',$user->id);
                })->where('tps_id', $user->tps_id)->sum('total_suara');
                $totalDpt = Dpt::where('tps_id', $user->tps_id)->count();
                $totalFoto = FileLampiran::whereHas('suara', function ($w) use ($user) {
                    $w->where('user_id', $user->id)->where('tps_id', $user->tps_id);
                })->count();
                $data = [
                    'nama' => $user->nama,
                    'jumlah_calon' => (int) $jumlahCalon,
                    'total_suara' => (int) $totalSuara,
                    'total_dpt' => (int) $totalDpt,
                    'total_foto' => (int) $totalFoto,
                    'tps' => (int) $tps->nomor,
                    'kelurahan_desa_id' => $tps->kelurahan_desa_id,
                    'kelurahan_desa' => $tps->kelurahan_desa->nama,
                    'kecamatan_id' => $tps->kelurahan_desa->kecamatan_id,
                    'kecamatan' => $tps->kelurahan_desa->kecamatan->nama,
                    'kabupaten_kota_id' => $tps->kelurahan_desa->kecamatan->kabupaten_kota_id,
                    'kabupaten_kota' => $tps->kelurahan_desa->kecamatan->kabupaten_kota->nama,
                    'user_koordinator' => @$tps->kelurahan_desa->users[0]->nama,
                    'user_koordes' => $user_koordes,
                    'user_koorcam' => $user_koorcam,
                    'pengumuman' => null
                ];
                $pengumuman = Pengumuman::where(function($w)use($tps,$user){
                    $w->whereNull('provinsi_id')
                    ->orWhereNull('kabupaten_kota_id')
                    ->orWhere('kabupaten_kota_id',$tps->kelurahan_desa->kecamatan->kabupaten_kota_id)
                    ->orWhere('kecamatan_id',$tps->kelurahan_desa->kecamatan_id)
                    ->orWhere('kelurahan_desa_id',$tps->kelurahan_desa_id)
                    ->orWhere('user_saksi_id',$user->id);
                })
                ->latest()->first();
                if ($pengumuman) {
                    $data['pengumuman'] = [
                        'id' => (string) $pengumuman->id,
                        'judul' => $pengumuman->judul,
                        'isi' => $pengumuman->isi,
                        'pertanyaan' => (string) $pengumuman->pertanyaan,
                        'diff_human' => $pengumuman->created_at->diffForHumans()
                    ];
                }
                return response()->json([
                    'message' => 'success',
                    'data' => $data
                ]);
            } else {
                return response()->json([
                    'message' => 'dont have access',
                ], 402);
            }
        }

        return response()->json([
            'message' => 'no telp or password not match',
        ], 402);
    }

    public function profile()
    {
        return auth()->user();
    }
}
