<?php
namespace App\Helpers;

use App\Models\User;
use App\Models\UserLog;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Storage;
use Google\Client as GoogleClient;

class Helper
{
    public static function kontakAdmin($partai_id = null, $kabupaten_kota_id = null)
    {
        $kontaks = [
            [
                "nama" => "Heni Resky Ramadhani",
                "no_wa" => "085247423336",
                "kabupaten_kota_id" => 6472,
                "partai_id" => 2
            ],
            [
                "nama" => "Nurfadila Mashar",
                "no_wa" => "081258443797",
                "kabupaten_kota_id" => 6471,
                "partai_id" => 2
            ],
            [
                "nama" => "Nur Miptahul Khair",
                "no_wa" => "082126146682",
                "kabupaten_kota_id" => 6409,
                "partai_id" => 2
            ],
            [
                "nama" => "Yohana Odilia Nanda",
                "no_wa" => "081341340854",
                "kabupaten_kota_id" => 6401,
                "partai_id" => 2
            ],
            [
                "nama" => "Dewi Risnawati",
                "no_wa" => "089604169403",
                "kabupaten_kota_id" => null,
                "partai_id" => 1
            ],
            [
                "nama" => "Kusnadi",
                "no_wa" => "085247088167",
                "kabupaten_kota_id" => null,
                "partai_id" => 3
            ],
            [
                "nama" => "Mirul",
                "no_wa" => "089635512281",
                "kabupaten_kota_id" => 6403,
                "partai_id" => null
            ],
            [
                "nama" => "Abi",
                "no_wa" => "089635512317",
                "kabupaten_kota_id" => 6402,
                "partai_id" => null
            ],
            [
                "nama" => "Nandi",
                "no_wa" => "089635512275",
                "kabupaten_kota_id" => 6409,
                "partai_id" => null
            ],
            [
                "nama" => "Given",
                "no_wa" => "089635510523",
                "kabupaten_kota_id" => 6474,
                "partai_id" => null
            ],
            [
                "nama" => "Dimas",
                "no_wa" => "089635512291",
                "kabupaten_kota_id" => 6401,
                "partai_id" => null
            ],
            [
                "nama" => "Age",
                "no_wa" => "089604137963",
                "kabupaten_kota_id" => 6408,
                "partai_id" => null
            ],
            [
                "nama" => "Sari",
                "no_wa" => "089604137960",
                "kabupaten_kota_id" => 6411,
                "partai_id" => null
            ],
            [
                "nama" => "Nadila",
                "no_wa" => "089604135111",
                "kabupaten_kota_id" => 6407,
                "partai_id" => null
            ],
            [
                "nama" => "Irawan",
                "no_wa" => "088801263832",
                "kabupaten_kota_id" => 6471,
                "partai_id" => null
            ],
            [
                "nama" => "Diptha",
                "no_wa" => "08978331206",
                "kabupaten_kota_id" => 6472,
                "partai_id" => null
            ],
        ];

        $kontakResults = $kontaks;
        if ($partai_id != null) {
            $kontakResults = array_filter($kontakResults, function ($kontak) use ($partai_id) {
                return $kontak['partai_id'] == $partai_id || $kontak['partai_id'] == null;
            });
        }

        if ($kabupaten_kota_id != null) {
            $kontakResults = array_filter($kontakResults, function ($kontak) use ($kabupaten_kota_id) {
                return $kontak['kabupaten_kota_id'] == $kabupaten_kota_id || $kontak['kabupaten_kota_id'] == null;
            });
        }

        if ($partai_id == null && $kabupaten_kota_id == null) {
            $kontakResults = [];
        }

        return $kontakResults;

    }
    public static function koordinatorLabel($slug)
    {
        $roles = [
            'kabupaten-kota' => 'Kabupaten/Kota',
            'kecamatan' => 'Kecamatan',
            'kelurahan-desa' => 'Kelurahan/Desa',
        ];
        return @$roles[$slug] ?? $slug;
    }
    public static function sendWa($number, $message, $file = null, $customKey = null)
    {

        // $second = date("i");
        // $second = 2;

        // if ($second % 2 == 0 && $customKey == null) {
        //     $random_int = random_int(0,1);
        //     //return self::sendWaFonnte($number, $message);
        //     // return self::sendWa($number, $message, null, "adp4c4a9578-35e6-4baf-9412-bce54f62a44d");
        //     if($random_int == 0){
        //         return self::sendWaFonnte($number, $message);
        //     } else {
        //         return self::sendWa($number, $message, null, "adp4c4a9578-35e6-4baf-9412-bce54f62a44d");
                
        //     }
        // }

        //jika nomor kosong
        if ($number === "" || $number === null || strlen($number) < 4) {
            return "nomor hp kosong";
        }
        $ptn = "/^0/";  // Regex
        $rpltxt = "+62";  // Replacement string
        $number = preg_replace($ptn, $rpltxt, "$number");
        if (strpos($number, '+62') === false) {
            $number = '+62' . $number;
        }
        //$key = $customKey ?? '7e10303d8e75d503ef83ab381ac95f692a476a9766c51090';
        $key = "adp4c4a9578-35e6-4baf-9412-bce54f62a44d";
        $url = 'http://116.203.191.58/api/async_send_message';
        $data = array(
            "phone_no" => $number,
            "key" => $key,
            "message" => $message,
            "flag_retry" => "on",
            "pendingTime" => rand(2, 6)
        );
        $data_string = json_encode($data);
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_VERBOSE, 0);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 0);
        curl_setopt($ch, CURLOPT_TIMEOUT, 360);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt(
            $ch,
            CURLOPT_HTTPHEADER,
            array(
                'Content-Type: application/json',
                'Content-Length: ' . strlen($data_string)
            )
        );
        $res = curl_exec($ch);
        $err = curl_error($ch);
        curl_close($ch);

        if ($err != "") {
            return $err;
        }



        //Log::info("WA : ".$res);

        if ($file) {

            $url = 'http://116.203.191.58/api/async_send_file_url';
            $data = array(
                "phone_no" => $number,
                "key" => $key,
                "url" => $file,
                // "url"        =>$img_url,
            );
            $data_string = json_encode($data);
            $ch = curl_init($url);
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
            curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_VERBOSE, 0);
            curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 0);
            curl_setopt($ch, CURLOPT_TIMEOUT, 360);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
            curl_setopt(
                $ch,
                CURLOPT_HTTPHEADER,
                array(
                    'Content-Type: application/json',
                    'Content-Length: ' . strlen($data_string)
                )
            );
            $res = curl_exec($ch);
            curl_close($ch);
        }

        return $res;

    }

    public static function sendWaFonnte($number, $message)
    {   
        $tokens = [
            "EhGQiRGMG8nZZvSEEmX8",
            "5nxjEruyKeNjeDYhMu1D",
            // "F8NREbsMt9xErFohrPzd",
            // "CroaaxUvSrcuWSxwsgXT"
        ];
        $k = array_rand($tokens);
        $token = $tokens[$k];
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://api.fonnte.com/send',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => array(
                'target' =>$number,
                'message' => $message,
                'typing' => true,
                'delay' => rand(2, 6),
                'countryCode' => '62',
            ),
            CURLOPT_HTTPHEADER => array(
                'Authorization: '.$token
            ),
        ));

        $response = curl_exec($curl);
        if (curl_errno($curl)) {
            $error_msg = curl_error($curl);
        }
        curl_close($curl);

        if (isset($error_msg)) {
            return $error_msg;
        }
        return $response;

    }

    //get ip
    public static function getIp()
    {
        $ip = "";
        if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
            $ip = $_SERVER['HTTP_CLIENT_IP'];
        } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
            $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
        } else {
            $ip = $_SERVER['REMOTE_ADDR'];
        }
        $ip = explode(",", $ip);
        return $ip[0];
    }

    public static function addUserLog($message, $data = null)
    {
        $userLog = UserLog::create([
            'user_id' => auth()->user()->id,
            'message' => $message,
            'ip_address' => self::getIp(),
            'data' => $data
        ]);
    }

    public static function userBermasalah()
    {
        $users = User::with('tps.kelurahan_desa')->where('status', 'sudah ada');
        $role = auth()->user()->role;
        switch ($role) {
            case 'koordinator-kelurahan-desa':
                $users = $users->where('role', 'saksi')->whereHas('tps', function ($w) {
                    $w->whereIn('kelurahan_desa_id', @auth()->user()->multi_tps->pluck('id')->toArray() ?? []);
                });
                break;
            case 'koordinator-kecamatan':
                $users = $users->whereIn('role', ['saksi', 'koordinator-kelurahan-desa'])->whereHas('tps.kelurahan_desa', function ($w) {
                    $w->where('kecamatan_id', auth()->user()->kecamatan_id);
                });
                break;
            case 'koordinator-kabupaten-kota':
                $users = $users->whereIn('role', ['saksi', 'koordinator-kelurahan-desa', 'koordinator-kecamatan'])->whereHas('tps.kelurahan_desa.kecamatan', function ($w) {
                    $w->where('kabupaten_kota_id', auth()->user()->kabupaten_kota_id);
                });
                break;
            default:
                # code...
                break;
        }
        return $users->get();
    }

    public static function sendFcm($title, $body, $data = null, $topic = null)
    {
        $projectId = "saksi-pilkada-b0583"; # INSERT COPIED PROJECT ID

        $credentialsFilePath = Storage::path('saksi-pilkada-b0583-firebase-adminsdk-n5n8v-61bec3af82.json');
        $client = new GoogleClient();
        $client->setAuthConfig($credentialsFilePath);
        $client->addScope('https://www.googleapis.com/auth/firebase.messaging');
        $client->fetchAccessTokenWithAssertion();
        $token = $client->getAccessToken();

        $access_token = $token['access_token'];

        $headers = [
            "Authorization: Bearer $access_token",
            'Content-Type: application/json'
        ];

        $data = [
            "message" => [
                "topic" => $topic,
                // "token" => $deviceToken,
                "notification" => [
                    "title" => $title,
                    "body" => $body,
                ],
                "data" => $data,
                "android" => [
                    "notification" => [
                        "sound" => "default"
                    ]
                ],
                "apns" => [
                    "payload" => [
                        "aps" => [
                            "sound" => "default"
                        ]
                    ]
                ]
            ]
        ];
        $payload = json_encode($data);

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, "https://fcm.googleapis.com/v1/projects/{$projectId}/messages:send");
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
        curl_setopt($ch, CURLOPT_VERBOSE, true); // Enable verbose output for debugging
        $response = curl_exec($ch);
        $err = curl_error($ch);
        curl_close($ch);



        if ($err) {
            return [
                'success' => false,
                'message' => 'Curl Error: ' . $err
            ];
        } else {
            return [
                'success' => true,
                'message' => 'Notification has been sent',
                'response' => json_decode($response, true)
            ];
        }
    }
}