<?php

namespace App\Exports;

use App\Models\UserLog;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;

class UserLogsExport implements FromCollection,WithHeadings,WithMapping,ShouldAutoSize
{   
    private $no = 0;
    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {   
        $datas = UserLog::with('user');
        if(request()->tanggal_awal){
            $datas = $datas->whereDate('created_at', '>=', request()->tanggal_awal);
        }

        if(request()->tanggal_akhir){
            $datas = $datas->whereDate('created_at', '<=', request()->tanggal_akhir);
        }
        return $datas->get();
    }

    public function headings(): array
    {
        return [
            '#',
            'NAMA',
            'KETERANGAN',
            'IP ADDRESS',
            'CREATED AT'
        ];
    }

    public function map($user): array
    {   
        $this->no ++;
        return [
            $this->no,
            $user->user->nama,
            $user->message,
            $user->ip_address,
            $user->created_at
        ];
    }
}
