<?php
namespace App\Exports\Sheets;

use App\Models\KabupatenKota;
use Illuminate\Contracts\View\View;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Concerns\FromView;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\WithTitle;
use Maatwebsite\Excel\Events\AfterSheet;
use PhpOffice\PhpSpreadsheet\Cell\DataValidation;

class ImportPelatihSheet implements FromView, WithTitle, WithEvents,ShouldAutoSize
{   

    public $user;

    public function __construct($user)
    {   
       $this->user = $user;
    }

    public function view(): View
    {   
        return view('pelatih.template-excel');
    }

    /**
     * @return string
     */
    public function title(): string
    {
        return 'INPUT_PELATIH';
    }

    public function registerEvents(): array
    {   
        
        $kabupatenKotas = KabupatenKota::query();
        if ($this->user->role != "admin") {
            $kabupatenKotas = $kabupatenKotas->where('id',$this->user->kabupaten_kota_id);
        }

        $kabupatenKotas = $kabupatenKotas->get();
        return [
            
            AfterSheet::class => function(AfterSheet $event)use($kabupatenKotas) {
                
                //default value
                $event->sheet->setCellValue('E2', @$kabupatenKotas[0]->nama);

                $validation = $event->sheet->getCell("E2")->getDataValidation();
                $validation->setType(DataValidation::TYPE_LIST);
                $validation->setErrorStyle(DataValidation::STYLE_INFORMATION);
                $validation->setAllowBlank(false);
                $validation->setShowInputMessage(false);
                $validation->setShowErrorMessage(true);
                $validation->setShowDropDown(true);
                $validation->setErrorTitle('Input error');
                $validation->setError('Kabupaten/Kota Tidak Ada dalam list.');
                // $validation->setPromptTitle('Silahkan pilih kecamatan');
                // $validation->setPrompt('Silahkan pilih kecamatan.');
                $validation->setFormula1('=ListKabupatenKota');


                $validation1 = $event->sheet->getCell("F2")->getDataValidation();
                $validation1->setType(DataValidation::TYPE_LIST);
                $validation1->setErrorStyle(DataValidation::STYLE_INFORMATION);
                $validation1->setAllowBlank(false);
                $validation1->setShowInputMessage(false);
                $validation1->setShowErrorMessage(true);
                $validation1->setShowDropDown(true);
                $validation1->setErrorTitle('Input error');
                $validation1->setError('Kecamatan Tidak Ada dalam list.');
                $validation1->setFormula1('=INDIRECT("KEC_"&SUBSTITUTE(SUBSTITUTE(SUBSTITUTE($E2,"-","_")," ","_"),"'."'".'",""))');
              
                

                $validation2 = $event->sheet->getCell("G2")->getDataValidation();
                $validation2->setType(DataValidation::TYPE_LIST);
                $validation2->setErrorStyle(DataValidation::STYLE_INFORMATION);
                $validation2->setAllowBlank(false);
                $validation2->setShowInputMessage(false);
                $validation2->setShowErrorMessage(true);
                $validation2->setShowDropDown(true);
                $validation2->setErrorTitle('Input error');
                $validation2->setError('Kelurahan/desa Tidak Ada dalam list.');
                $validation2->setFormula1('=INDIRECT("KEL_DES_"&SUBSTITUTE(SUBSTITUTE(SUBSTITUTE($F2,"-","_")," ","_"),"'."'".'",""))');
               

              

                

                $event->sheet->getStyle('A1:G2')->applyFromArray([
                    'borders' => [
                        'allBorders' => [
                            'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                        ],
                    ],
                ]);
                $event->sheet->getStyle('A1:G1')->applyFromArray([
                    'font' => [
                        'bold' => true,
                    ],
                ]);

            },
        ];
    }
}