<?php
namespace App\Exports\Sheets;

use App\Models\Caleg;
use App\Models\Dapil;
use App\Models\KabKota;
use App\Models\KabupatenKota;
use App\Models\Kecamatan;
use App\Models\Partai;
use Illuminate\Contracts\View\View;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Concerns\FromView;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\WithTitle;
use Maatwebsite\Excel\Events\AfterSheet;
use PhpOffice\PhpSpreadsheet\Cell\DataValidation;

class ImportKoordinatorSheet implements FromView, WithTitle, WithEvents,ShouldAutoSize
{   

    public $user;
    public $koordinator;

    public function __construct($user,$koordinator)
    {   
       $this->user = $user;
       $this->koordinator = $koordinator;
    }

    public function view(): View
    {   
        return view('user-koordinator.template-excel',[
            'koordinator'=>$this->koordinator
        ]);
    }

    /**
     * @return string
     */
    public function title(): string
    {
        return 'INPUT_KOORDINATOR';
    }

    public function registerEvents(): array
    {   
        
        $kabupatenKotas = KabupatenKota::query();
        if ($this->user->role != "admin") {
            $kabupatenKotas = $kabupatenKotas->where('id',$this->user->kabupaten_kota_id);
        }

        $kabupatenKotas = $kabupatenKotas->get();
        $koordinator = $this->koordinator;
        return [
            
            AfterSheet::class => function(AfterSheet $event)use($kabupatenKotas,$koordinator) {
                
                //default value
                $event->sheet->setCellValue('F2', @$kabupatenKotas[0]->nama);

                $validation = $event->sheet->getCell("F2")->getDataValidation();
                $validation->setType(DataValidation::TYPE_LIST);
                $validation->setErrorStyle(DataValidation::STYLE_INFORMATION);
                $validation->setAllowBlank(false);
                $validation->setShowInputMessage(false);
                $validation->setShowErrorMessage(true);
                $validation->setShowDropDown(true);
                $validation->setErrorTitle('Input error');
                $validation->setError('Kabupaten/Kota Tidak Ada dalam list.');
                // $validation->setPromptTitle('Silahkan pilih kecamatan');
                // $validation->setPrompt('Silahkan pilih kecamatan.');
                $validation->setFormula1('=ListKabupatenKota');


                $validation1 = $event->sheet->getCell("G2")->getDataValidation();
                $validation1->setType(DataValidation::TYPE_LIST);
                $validation1->setErrorStyle(DataValidation::STYLE_INFORMATION);
                $validation1->setAllowBlank(false);
                $validation1->setShowInputMessage(false);
                $validation1->setShowErrorMessage(true);
                $validation1->setShowDropDown(true);
                $validation1->setErrorTitle('Input error');
                $validation1->setError('Kecamatan Tidak Ada dalam list.');
                $validation1->setFormula1('=INDIRECT("KEC_"&SUBSTITUTE(SUBSTITUTE(SUBSTITUTE($F2,"-","_")," ","_"),"'."'".'",""))');
              
                

                $validation2 = $event->sheet->getCell("H2")->getDataValidation();
                $validation2->setType(DataValidation::TYPE_LIST);
                $validation2->setErrorStyle(DataValidation::STYLE_INFORMATION);
                $validation2->setAllowBlank(false);
                $validation2->setShowInputMessage(false);
                $validation2->setShowErrorMessage(true);
                $validation2->setShowDropDown(true);
                $validation2->setErrorTitle('Input error');
                $validation2->setError('Kelurahan/desa Tidak Ada dalam list.');
                $validation2->setFormula1('=INDIRECT("KEL_DES_"&SUBSTITUTE(SUBSTITUTE(SUBSTITUTE($G2,"-","_")," ","_"),"'."'".'",""))');
               

              
                $validation3 = $event->sheet->getCell("I2")->getDataValidation();
                $validation3->setType(DataValidation::TYPE_LIST);
                $validation3->setErrorStyle(DataValidation::STYLE_INFORMATION);
                $validation3->setAllowBlank(true);
                $validation3->setShowInputMessage(false);
                $validation3->setShowErrorMessage(true);
                $validation3->setShowDropDown(true);
                $validation3->setErrorTitle('Input error');
                $validation3->setError('TPS Tidak Ada dalam list.');
                $validation3->setFormula1('=INDIRECT("TPS_"&SUBSTITUTE(SUBSTITUTE(SUBSTITUTE($H2,"-","_")," ","_"),"'."'".'",""))');

                $validation4 = $event->sheet->getCell("J2")->getDataValidation();
                $validation4->setType(DataValidation::TYPE_LIST);
                $validation4->setErrorStyle(DataValidation::STYLE_INFORMATION);
                $validation4->setAllowBlank(false);
                $validation4->setShowInputMessage(false);
                $validation4->setShowErrorMessage(true);
                $validation4->setShowDropDown(true);
                $validation4->setErrorTitle('Input error');
                $validation4->setError('Partai Tidak Ada dalam list.');
                $validation4->setFormula1('=ListPartais');
                

                if ($koordinator == "kelurahan-desa") {
                    $event->sheet->getStyle('A1:K2')->applyFromArray([
                        'borders' => [
                            'allBorders' => [
                                'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                            ],
                        ],
                    ]);
                    $event->sheet->getStyle('A1:K1')->applyFromArray([
                        'font' => [
                            'bold' => true,
                        ],
                    ]);
                } else {
                    $event->sheet->getStyle('A1:J2')->applyFromArray([
                        'borders' => [
                            'allBorders' => [
                                'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                            ],
                        ],
                    ]);
                    $event->sheet->getStyle('A1:J1')->applyFromArray([
                        'font' => [
                            'bold' => true,
                        ],
                    ]);
                }
                

            },
        ];
    }
}