<?php

namespace App\Exports;

use App\Models\User;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\FromView;
use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithColumnFormatting;
use Maatwebsite\Excel\Concerns\WithCustomValueBinder;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithHeadings;
use PhpOffice\PhpSpreadsheet\Cell\Cell;
use PhpOffice\PhpSpreadsheet\Cell\DataType;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;

class SaksisExport implements FromView, ShouldAutoSize
{
    public $q = "";
    private $no = 0;
    /**
     * @return \Illuminate\Support\Collection
     */
    // public function collection()
    public function view(): View
    {
        $q = $this->q;
        $datas = User::with('tps.kelurahan_desa.kecamatan.kabupaten_kota.provinsi', 'kelurahan_desa', 'partai', 'dpt')
            ->withCount('suaras')
            ->where('role', 'saksi');
        if ($q != "") {
            $datas = $datas->where(function ($w) use ($q) {
                $w->where('nama', 'like', '%' . $q . '%')
                    ->orWhere('no_telp', 'like', '%' . $q . '%')
                    ->orWhereHas('tps', function ($wtps) use ($q) {
                        $wtps->where('nomor', $q);
                    });
            });
        }

        if (auth()->user()->role == "koordinator-kelurahan-desa") {
            $datas = $datas->whereHas('tps', function ($w) {
                $w->whereIn('kelurahan_desa_id', @auth()->user()->multi_tps->pluck('id')->toArray() ?? []);
            });
        }

        if (auth()->user()->role == "koordinator-kecamatan") {
            $datas = $datas->whereHas('tps.kelurahan_desa', function ($w) {
                $w->where('kecamatan_id', auth()->user()->kecamatan_id);
            });
        }

        if (auth()->user()->role == "koordinator-kabupaten-kota") {
            $datas = $datas->whereHas('tps.kelurahan_desa.kecamatan', function ($w) {
                $w->where('kabupaten_kota_id', auth()->user()->kabupaten_kota_id);
            });
        }

        if (request()->kelurahan_desa_id) {
            $datas = $datas->where('users.kelurahan_desa_id', request()->kelurahan_desa_id);
        } else if (request()->kecamatan_id) {
            $datas = $datas->whereHas('kelurahan_desa', function ($w) {
                $w->where('kelurahan_desas.kecamatan_id', request()->kecamatan_id);
            });
        } else if (request()->kabupaten_kota_id) {
            $datas = $datas->whereHas('kelurahan_desa', function ($w) {
                $w->whereHas('kecamatan', function ($w) {
                    $w->where('kecamatans.kabupaten_kota_id', request()->kabupaten_kota_id);
                });
            });
        } else if (request()->provinsi_id) {
            $datas = $datas->whereHas('kelurahan_desa', function ($w) {
                $w->whereHas('kecamatan', function ($w) {
                    $w->whereHas('kabupaten_kota', function ($w) {
                        $w->where('kabupaten_kotas.provinsi_id', request()->provinsi_id);
                    });
                });
            });
        }

        if (request()->partai_id) {
            $datas = $datas->where('partai_id', request()->partai_id);
        }


        if (request()->input_suara) {
            $keyword = request()->input_suara;
            if(strtolower($keyword) == "belum"){
                $datas = $datas->having("suaras_count",'=',0);
            }
            if(strtolower($keyword) == "sudah"){
                $datas = $datas->having("suaras_count",'>',0);
            }
        }
        $datas = $datas->orderBy('created_at', 'DESC')->get();
        return view('saksi.export', compact('datas'));
    }

    public function headings(): array
    {
        return [
            '#',
            'NIK',
            'NAMA',
            'NO TELP',
            'NO WA',
            'EMAIL',
            'PARTAI',
            'TPS TUGAS',
            'INPUT SUARA',
            'KEL/DES TUGAS',
            'KEC TUGAS',
            'KAB/KOT TUGAS',
            'PROV TUGAS'
        ];
    }

    public function map($user): array
    {
        $this->no++;
        return [
            (string) $this->no,
            (string) $user->nik,
            $user->nama,
            (string) $user->no_wa,
            $user->email,
            $user->partai->nama,
            (string) $user->tps->nomor,
            $user->suaras_count == 0 ? "Belum" : "Sudah",
            $user->kelurahan_desa->nama,
            $user->kecamatan->nama,
            $user->kabupaten_kota->nama,
            $user->provinsi->nama,
        ];
    }





}
