<?php

namespace App\Console\Commands;

use App\Models\Dpt;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;

class DeleteDpt extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'dpt:delete-dpt';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        try {
            Dpt::whereDoesntHave('users')->delete();
            $this->info('Sukses menghapus data dpt');
        } catch (\Throwable $th) {
            Log::error($th);
            $this->error('Gagal menghapus data dpt');
        }
    }
}
