<?php

namespace App\Console\Commands;

use App\Models\Dpt;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Schema;

class ClearDpt extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'dpt:clear-dpt';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Hapus semua dpt';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        try {
            Schema::disableForeignKeyConstraints();
            Dpt::truncate();
            Schema::enableForeignKeyConstraints();
            $this->info('Sukses menghapus data dpt');
        } catch (\Throwable $th) {
            Log::error($th);
            $this->error('Gagal menghapus data dpt');
        }
    }
}
