import { defineConfig } from 'vite';
import laravel from 'laravel-vite-plugin';

export default defineConfig({
    plugins: [
        laravel({
            input: ['resources/css/app.css', 'resources/js/app.js', 'resources/js/admin.js','resources/css/print.css',],
            refresh: true,
        }),
    ],
    server: {
        host: '0.0.0.0', // Listen on all IPv4 addresses
        port: 5173,
        strictPort: true,
        hmr: {
            host: 'localhost', // Tell the browser to look at localhost, not [::1]
        },
    },
});
