<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <?php echo app('Illuminate\Foundation\Vite')('resources/css/app.css'); ?>
    <title>
        <?php echo e(env('APP_NAME')); ?>

    </title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/choices.js/public/assets/styles/choices.min.css" />
    <style>
        .choices__list--dropdown {
            z-index: 99 !important;
            background-color: white !important;
        }

        .choices__inner {
            padding: 6px 6px 3.5px !important;
        }

        .choices[data-type*="select-one"] select.choices__input {
            display: block !important;
            opacity: 0;
            pointer-events: none;
            position: absolute;
            left: 0;
            bottom: 0;
        }

        table.dataTable th {
            white-space: nowrap;
        }
    </style>
    <?php echo $__env->yieldPushContent('styles'); ?>
</head>

<body x-data="{ page: '<?php echo e(request()->path()); ?>', 'loaded': true, 'darkMode': true, 'stickyMenu': false, 'sidebarToggle': false, 'scrollTop': false }" x-init="darkMode = JSON.parse(localStorage.getItem('darkMode'));
$watch('darkMode', value => localStorage.setItem('darkMode', JSON.stringify(value)))" :class="{ 'dark text-bodydark bg-boxdark-2': darkMode === true }">
    <!-- ===== Preloader Start ===== -->
    <?php echo $__env->make('layouts.partials.preloader', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- ===== Preloader End ===== -->

    <!-- ===== Page Wrapper Start ===== -->
    <div class="flex h-screen overflow-hidden">
        <!-- ===== Sidebar Start ===== -->
        <?php echo $__env->make('layouts.partials.sidebar.sidebar-' . auth()->user()->role, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <!-- ===== Sidebar End ===== -->

        <!-- ===== Content Area Start ===== -->
        <div class="relative flex flex-1 flex-col overflow-y-auto overflow-x-hidden">
            <!-- ===== Header Start ===== -->
            <?php echo $__env->make('layouts.partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <!-- ===== Header End ===== -->

            <!-- ===== Main Content Start ===== -->
            <main>
                <?php $__sessionArgs = ['warning'];
if (session()->has($__sessionArgs[0])) :
if (isset($value)) { $__sessionPrevious[] = $value; }
$value = session()->get($__sessionArgs[0]); ?>
                    <div
                        class="flex w-full border-l-6 border-warning bg-warning bg-opacity-[15%] px-7 py-8 shadow-md dark:bg-[#1B1B24] dark:bg-opacity-30 md:p-9">
                        <div class="mr-5 flex h-9 w-9 items-center justify-center rounded-lg bg-warning bg-opacity-30">
                            <svg width="19" height="16" viewBox="0 0 19 16" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <path
                                    d="M1.50493 16H17.5023C18.6204 16 19.3413 14.9018 18.8354 13.9735L10.8367 0.770573C10.2852 -0.256858 8.70677 -0.256858 8.15528 0.770573L0.156617 13.9735C-0.334072 14.8998 0.386764 16 1.50493 16ZM10.7585 12.9298C10.7585 13.6155 10.2223 14.1433 9.45583 14.1433C8.6894 14.1433 8.15311 13.6155 8.15311 12.9298V12.9015C8.15311 12.2159 8.6894 11.688 9.45583 11.688C10.2223 11.688 10.7585 12.2159 10.7585 12.9015V12.9298ZM8.75236 4.01062H10.2548C10.6674 4.01062 10.9127 4.33826 10.8671 4.75288L10.2071 10.1186C10.1615 10.5049 9.88572 10.7455 9.50142 10.7455C9.11929 10.7455 8.84138 10.5028 8.79579 10.1186L8.13574 4.75288C8.09449 4.33826 8.33984 4.01062 8.75236 4.01062Z"
                                    fill="#FBBF24"></path>
                            </svg>
                        </div>
                        <div class="w-full">
                            <h5 class="mb-3 text-lg font-bold text-[#9D5425]">
                                Warning
                            </h5>
                            <p class="leading-relaxed text-[#D0915C]">
                                <?php echo e(session('warning')); ?>

                            </p>
                        </div>
                    </div>
                <?php unset($value);
if (isset($__sessionPrevious) && !empty($__sessionPrevious)) { $value = array_pop($__sessionPrevious); }
if (isset($__sessionPrevious) && empty($__sessionPrevious)) { unset($__sessionPrevious); }
endif;
unset($__sessionArgs); ?>
                <?php $__sessionArgs = ['success'];
if (session()->has($__sessionArgs[0])) :
if (isset($value)) { $__sessionPrevious[] = $value; }
$value = session()->get($__sessionArgs[0]); ?>
                    <div
                        class="flex w-full border-l-6 border-[#34D399] bg-[#34D399] bg-opacity-[15%] px-7 py-8 shadow-md dark:bg-[#1B1B24] dark:bg-opacity-30 md:p-9">
                        <div class="mr-5 flex h-9 w-full max-w-[36px] items-center justify-center rounded-lg bg-[#34D399]">
                            <svg width="16" height="12" viewBox="0 0 16 12" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <path
                                    d="M15.2984 0.826822L15.2868 0.811827L15.2741 0.797751C14.9173 0.401867 14.3238 0.400754 13.9657 0.794406L5.91888 9.45376L2.05667 5.2868C1.69856 4.89287 1.10487 4.89389 0.747996 5.28987C0.417335 5.65675 0.417335 6.22337 0.747996 6.59026L0.747959 6.59029L0.752701 6.59541L4.86742 11.0348C5.14445 11.3405 5.52858 11.5 5.89581 11.5C6.29242 11.5 6.65178 11.3355 6.92401 11.035L15.2162 2.11161C15.5833 1.74452 15.576 1.18615 15.2984 0.826822Z"
                                    fill="white" stroke="white"></path>
                            </svg>
                        </div>
                        <div class="w-full">
                            <h5 class="mb-3 text-lg font-bold text-black dark:text-[#34D399]">
                                Success
                            </h5>
                            <p class="text-base leading-relaxed text-body">
                                <?php echo e(session('success')); ?>

                            </p>
                        </div>
                    </div>
                <?php unset($value);
if (isset($__sessionPrevious) && !empty($__sessionPrevious)) { $value = array_pop($__sessionPrevious); }
if (isset($__sessionPrevious) && empty($__sessionPrevious)) { unset($__sessionPrevious); }
endif;
unset($__sessionArgs); ?>
                <?php $__sessionArgs = ['error'];
if (session()->has($__sessionArgs[0])) :
if (isset($value)) { $__sessionPrevious[] = $value; }
$value = session()->get($__sessionArgs[0]); ?>
                    <div
                        class="flex w-full border-l-6 border-[#F87171] bg-[#F87171] bg-opacity-[15%] px-7 py-8 shadow-md dark:bg-[#1B1B24] dark:bg-opacity-30 md:p-9">
                        <div class="mr-5 flex h-9 w-full max-w-[36px] items-center justify-center rounded-lg bg-[#F87171]">
                            <svg width="13" height="13" viewBox="0 0 13 13" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <path
                                    d="M6.4917 7.65579L11.106 12.2645C11.2545 12.4128 11.4715 12.5 11.6738 12.5C11.8762 12.5 12.0931 12.4128 12.2416 12.2645C12.5621 11.9445 12.5623 11.4317 12.2423 11.1114C12.2422 11.1113 12.2422 11.1113 12.2422 11.1113C12.242 11.1111 12.2418 11.1109 12.2416 11.1107L7.64539 6.50351L12.2589 1.91221L12.2595 1.91158C12.5802 1.59132 12.5802 1.07805 12.2595 0.757793C11.9393 0.437994 11.4268 0.437869 11.1064 0.757418C11.1063 0.757543 11.1062 0.757668 11.106 0.757793L6.49234 5.34931L1.89459 0.740581L1.89396 0.739942C1.57364 0.420019 1.0608 0.420019 0.740487 0.739944C0.42005 1.05999 0.419837 1.57279 0.73985 1.89309L6.4917 7.65579ZM6.4917 7.65579L1.89459 12.2639L1.89395 12.2645C1.74546 12.4128 1.52854 12.5 1.32616 12.5C1.12377 12.5 0.906853 12.4128 0.758361 12.2645L1.1117 11.9108L0.758358 12.2645C0.437984 11.9445 0.437708 11.4319 0.757539 11.1116C0.757812 11.1113 0.758086 11.111 0.75836 11.1107L5.33864 6.50287L0.740487 1.89373L6.4917 7.65579Z"
                                    fill="#ffffff" stroke="#ffffff"></path>
                            </svg>
                        </div>
                        <div class="w-full">
                            <h5 class="mb-3 font-bold text-[#B45454]">
                                Ops
                            </h5>
                            <ul>
                                <li class="leading-relaxed text-[#CD5D5D]">
                                    <?php echo e(session('error')); ?>

                                </li>
                            </ul>
                        </div>
                    </div>
                <?php unset($value);
if (isset($__sessionPrevious) && !empty($__sessionPrevious)) { $value = array_pop($__sessionPrevious); }
if (isset($__sessionPrevious) && empty($__sessionPrevious)) { unset($__sessionPrevious); }
endif;
unset($__sessionArgs); ?>
                <?php echo $__env->yieldContent('content'); ?>
            </main>
            <!-- ===== Main Content End ===== -->
        </div>
        <!-- ===== Content Area End ===== -->
    </div>
    <!-- ===== Page Wrapper End ===== -->
    <script src="https://code.jquery.com/jquery-3.7.1.js"></script>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/app.js', 'resources/js/admin.js']); ?>
    <script src="https://cdn.jsdelivr.net/npm/choices.js/public/assets/scripts/choices.min.js"></script>
    <script>
        const forms = document.querySelectorAll('form');

        forms.forEach((form) => {
            form.addEventListener('submit', (e) => {
                var button = form.querySelector('button[type="submit"]');
                if (button) {
                    button.disabled = true;
                    button.innerHTML = "Loading...";
                }
            });
        });


        let provinsiIdChoice = null;
        let kabupatenKotaIdChoice = null;
        let kecamatanIdChoice = null;
        let kelurahanDesaIdChoice = null;
        let tpsIdChoice = null;
        let dptIdChoice = null;

        let valueProvinsiId = '<?php echo e(old('provinsi_id', @$data->provinsi_id ?? 64)); ?>';
        let valueKabupatenKotaId =
            '<?php echo e(old('kabupaten_kota_id', @$data->kabupaten_kota_id ?? (@$data->tps->kelurahan_desa->kecamatan->kabupaten_kota_id ?? request()->kabupaten_kota_id))); ?>';
        let valueKecamatanId =
            '<?php echo e(old('kecamatan_id', @$data->kecamatan_id ?? (@$data->tps->kelurahan_desa->kecamatan_id ?? request()->kecamatan_id))); ?>';
        let valueKelurahanDesaId =
            '<?php echo e(old('kelurahan_desa_id', @$data->kelurahan_desa_id ?? (@$data->tps->kelurahan_desa_id ?? request()->kelurahan_desa_id))); ?>';
        let valueTpsId = '<?php echo e(old('tps_id', @$data->tps_id ?? (request()->tps_id ?? request()->tps_id))); ?>';
        let valueDptId = '<?php echo e(old('dpt_id', @$data->dpt_id ?? request()->dpt_id)); ?>';

        var valueMultiTpsId = [];
        <?php if(isset($data) && isset($data->multi_tps)): ?>
            valueMultiTpsId = <?php echo json_encode(old('multi_tps_id', @$data->multi_tps->pluck('id')->toArray() ?? []), 512) ?>;
        <?php endif; ?>

        function ajaxKabupatenKota() {
            document.getElementById('loading-kabupaten-kota').innerHTML = 'Loading...';
            const provinsiId = document.getElementById('provinsi_id').value;
            kabupatenKotaIdChoice.clearStore();

            if (kecamatanIdChoice != null) {
                kecamatanIdChoice.clearStore();
            }
            if (kelurahanDesaIdChoice != null) {
                kelurahanDesaIdChoice.clearStore();
            }
            if (tpsIdChoice != null) {
                tpsIdChoice.clearStore();
            }
            fetch(`/ajax/kabupaten-kota?provinsi_id=${provinsiId}`)
                .then(response => response.json())
                .then(data => {
                    document.getElementById('loading-kabupaten-kota').innerHTML = '.';
                    if (document.getElementById('kabupaten_kota_id').getAttribute('data-pilih-semua')) {
                        data.unshift({
                            id: "",
                            nama: "Semua Kabupaten/Kota"

                        });
                    } else if (!document.getElementById('kabupaten_kota_id').getAttribute('required')) {
                        data.unshift({
                            id: "",
                            nama: "Tidak Ada"

                        });
                    }
                    kabupatenKotaIdChoice.setChoices(data, 'id', 'nama', false);
                    if (valueKabupatenKotaId == "") {
                        valueKabupatenKotaId = data[0].id ?? "";
                    }
                    if (valueKabupatenKotaId && valueKabupatenKotaId != '') {
                        kabupatenKotaIdChoice.setChoiceByValue(parseInt(valueKabupatenKotaId));
                        ajaxKecamatan();
                    }
                })
                .catch(error => {
                    console.log(error);
                    document.getElementById('loading-kabupaten-kota').innerHTML = 'Error';
                });
        }

        function ajaxKecamatan() {
            if (!document.getElementById('kecamatan_id')) {
                return;
            }
            document.getElementById('kecamatan_id').value = '';
            document.getElementById('loading-kecamatan').innerHTML = 'Loading...';
            const kabupatenKotaId = document.getElementById('kabupaten_kota_id').value != "" ? document.getElementById(
                'kabupaten_kota_id').value : valueKabupatenKotaId;
            kecamatanIdChoice.clearStore();
            if (kelurahanDesaIdChoice != null) {
                kelurahanDesaIdChoice.clearStore();
            }
            if (tpsIdChoice != null) {
                tpsIdChoice.clearStore();
            }
            fetch(`/ajax/kecamatan?kabupaten_kota_id=${kabupatenKotaId}`)
                .then(response => response.json())
                .then(data => {
                    document.getElementById('loading-kecamatan').innerHTML = '.';
                    if (document.getElementById('kecamatan_id').getAttribute('data-pilih-semua')) {
                        data.unshift({
                            id: "",
                            nama: "Semua Kecamatan"

                        });
                    } else if (!document.getElementById('kecamatan_id').getAttribute('required')) {
                        data.unshift({
                            id: "",
                            nama: "Tidak Ada"

                        });
                    }
                    kecamatanIdChoice.setChoices(data, 'id', 'nama', false);
                    if (valueKecamatanId == "") {
                        valueKecamatanId = data[0].id ?? "";
                    }

                    if (valueKecamatanId && valueKecamatanId != '') {
                        kecamatanIdChoice.setChoiceByValue(parseInt(valueKecamatanId));
                        ajaxKelurahanDesa();
                    }
                })
                .catch(error => {
                    document.getElementById('loading-kecamatan').innerHTML = 'Error';
                });
        }

        function ajaxKelurahanDesa() {
            if (!document.getElementById('kelurahan_desa_id')) {
                return;
            }
            document.getElementById('kelurahan_desa_id').value = '';
            document.getElementById('loading-kelurahan-desa').innerHTML = 'Loading...';
            const kecamatanId = document.getElementById('kecamatan_id').value != "" ? document.getElementById(
                'kecamatan_id').value : valueKecamatanId;
            kelurahanDesaIdChoice.clearStore();
            if (tpsIdChoice != null) {
                tpsIdChoice.clearStore();
            }
            fetch(`/ajax/kelurahan-desa?kecamatan_id=${kecamatanId}`)
                .then(response => response.json())
                .then(data => {
                    document.getElementById('loading-kelurahan-desa').innerHTML = '.';
                    if (document.getElementById('kelurahan_desa_id').getAttribute('data-pilih-semua')) {
                        data.unshift({
                            id: "",
                            nama: "Semua Kelurahan/Desa"

                        });
                    } else if (!document.getElementById('kelurahan_desa_id').getAttribute('required')) {
                        data.unshift({
                            id: "",
                            nama: "Tidak Ada"

                        });
                    }
                    kelurahanDesaIdChoice.setChoices(data, 'id', 'nama', false);
                    if (valueKelurahanDesaId == "" && document.getElementById('kelurahan_desa_id').getAttribute(
                            'required')) {
                        valueKelurahanDesaId = data[0].id ?? ""
                    }
                    if (valueKelurahanDesaId && valueKelurahanDesaId != '') {
                        kelurahanDesaIdChoice.setChoiceByValue(parseInt(valueKelurahanDesaId));
                        if (document.getElementById('tps_id')) {
                            ajaxTps();
                        }
                        if (document.getElementById('multi_tps_id')) {
                            ajaxMultiTps();
                        }
                    }
                })
                .catch(error => {
                    document.getElementById('loading-kelurahan-desa').innerHTML = 'Error';
                });
        }

        function ajaxTps() {
            if (!document.getElementById('tps_id')) {
                return;
            }
            document.getElementById('tps_id').value = '';
            document.getElementById('loading-tps').innerHTML = 'Loading...';
            const kelurahanDesaId = document.getElementById('kelurahan_desa_id').value != "" ? document.getElementById(
                'kelurahan_desa_id').value : valueKelurahanDesaId;
            tpsIdChoice.clearStore();
            fetch(`/ajax/tps?kelurahan_desa_id=${kelurahanDesaId}`)
                .then(response => response.json())
                .then(data => {
                    document.getElementById('loading-tps').innerHTML = '.';
                    if (document.getElementById('tps_id').getAttribute('data-pilih-semua')) {
                        data.unshift({
                            id: "",
                            nama: "Semua TPS"

                        });
                    } else if (!document.getElementById('tps_id').getAttribute('required')) {
                        data.unshift({
                            id: "",
                            nama: "Tidak Ada"

                        });
                    }
                    var otpionsData = data.map((d) => {
                        return {
                            id: d.id,
                            nama: "TPS "+d.nomor

                        }
                    });
                    tpsIdChoice.setChoices(otpionsData, 'id', 'nama', false);
                    if (valueTpsId == "" && document.getElementById('tps_id').getAttribute('required')) {
                        valueTpsId = otpionsData[0].id ?? "";
                    }
                    if (valueTpsId && valueTpsId != '') {
                        tpsIdChoice.setChoiceByValue(parseInt(valueTpsId));
                        ajaxDpt();
                    }
                    var event = new Event('change');
                    tps_id.dispatchEvent(event);
                })
                .catch(error => {
                    console.log(error);
                    document.getElementById('loading-tps').innerHTML = 'Error';
                });
        }

        function ajaxMultiTps() {
            document.getElementById('loading-multi-tps').innerHTML = 'Loading...';
            const kelurahanDesaId = document.getElementById('kelurahan_desa_id').value != "" ? document.getElementById(
                'kelurahan_desa_id').value : valueKelurahanDesaId;
            multiTpsIdChoice.clearStore();
            fetch(`/ajax/tps?kelurahan_desa_id=${kelurahanDesaId}`)
                .then(response => response.json())
                .then(data => {
                    document.getElementById('loading-multi-tps').innerHTML = '.';
                    if (document.getElementById('multi_tps_id').getAttribute('data-pilih-semua')) {
                        data.unshift({
                            id: "",
                            nama: "Semua TPS"

                        });
                    }
                    multiTpsIdChoice.setChoices(data, 'id', 'nomor', false);

                    if (valueMultiTpsId.length > 0) {
                        multiTpsIdChoice.setChoiceByValue(valueMultiTpsId);
                    }
                })
                .catch(error => {
                    console.log(error);
                    document.getElementById('loading-multi-tps').innerHTML = 'Error';
                });
        }

        function ajaxDpt() {
            if (!document.getElementById('dpt_id')) {
                return;
            }
            document.getElementById('dpt_id').value = '';
            document.getElementById('loading-dpt').innerHTML = 'Loading...';
            const kelurahanDesaId = document.getElementById('kelurahan_desa_id').value != "" ? document.getElementById(
                'kelurahan_desa_id').value : valueKelurahanDesaId;
            let tpsId = valueTpsId;

            if (document.getElementById('tps_id') && document.getElementById('tps_id').value) {
                valueTpsId = document.getElementById('tps_id').value;
            } else if (document.getElementById('multi_tps_id')) {
                tpsId = valueMultiTpsId;
            }

            const dptId = document.getElementById('dpt_id');
            dptIdChoice.clearStore();
            fetch(`/ajax/dpt?kelurahan_desa_id=${kelurahanDesaId}&tps_id=${tpsId}`)
                .then(response => response.json())
                .then(data => {
                    document.getElementById('loading-dpt').innerHTML = '.';
                    let options = [];
                    if (!document.getElementById('dpt_id').getAttribute('required')) {
                        options.push({
                            id: "",
                            nama: "Tidak Ada"

                        });
                    }
                    for (let x = 0; x < data.length; x++) {
                        const d = data[x];
                        options.push({
                            'id': d.id,
                            'nama': d.nik + " | " + d.nama + " | " + d.usia + " | " + d.jenis_kelamin +
                                " | RT : " + d.rt + " / RW : " + d.rw

                        });

                    }

                    dptIdChoice.setChoices(options, 'id', 'nama', false);

                    if (valueDptId) {
                        dptIdChoice.setChoiceByValue(parseInt(valueDptId));
                    }
                })
                .catch(error => {
                    document.getElementById('loading-dpt').innerHTML = 'Error';
                });
        }

        if (document.getElementById("provinsi_id")) {
            provinsiIdChoice = new Choices('#provinsi_id');

        }


        if (document.getElementById('kabupaten_kota_id')) {
            kabupatenKotaIdChoice = new Choices('#kabupaten_kota_id', {
                placeholderValue: 'Pilih...',
                removeItems: !document.getElementById('kabupaten_kota_id').getAttribute('required'),
                removeItemButton: !document.getElementById('kabupaten_kota_id').getAttribute('required'),
                shouldSort: false,
                shouldSortItems: false,
                itemSelectText: "",
            });
            document.getElementById('provinsi_id').addEventListener('change', function() {
                valueProvinsiId = this.value;
                const provinsiId = this.value;
                kabupatenKotaIdChoice.clearStore();
                if (kecamatanIdChoice != null) {
                    kecamatanIdChoice.clearStore();
                }
                if (kelurahanDesaIdChoice != null) {
                    kelurahanDesaIdChoice.clearStore();
                }
                if (tpsIdChoice != null) {
                    tpsIdChoice.clearStore();
                }
                ajaxKabupatenKota();
            });

        }

        if (document.getElementById('kecamatan_id')) {
            kecamatanIdChoice = new Choices('#kecamatan_id', {
                placeholderValue: 'Pilih...',
                removeItems: !document.getElementById('kecamatan_id').getAttribute('required'),
                removeItemButton: !document.getElementById('kecamatan_id').getAttribute('required'),
                shouldSort: false,
                shouldSortItems: false,
                itemSelectText: "",
            });
            document.getElementById('kabupaten_kota_id').addEventListener('change', function() {

                valueKabupatenKotaId = this.value;
                console.log(valueKabupatenKotaId);
                ajaxKecamatan();
            });

        }

        if (document.getElementById('kelurahan_desa_id')) {
            kelurahanDesaIdChoice = new Choices('#kelurahan_desa_id', {
                placeholderValue: 'Pilih...',
                removeItems: !document.getElementById('kelurahan_desa_id').getAttribute('required'),
                removeItemButton: !document.getElementById('kelurahan_desa_id').getAttribute('required'),
                shouldSort: false,
                shouldSortItems: false,
                itemSelectText: "",
            });
            document.getElementById('kecamatan_id').addEventListener('change', function() {
                valueKecamatanId = this.value;
                console.log(valueKecamatanId);
                ajaxKelurahanDesa();
            });

        }

        if (document.getElementById('tps_id')) {
            document.getElementById('kelurahan_desa_id').addEventListener('change', function() {
                valueKelurahanDesaId = this.value;
                ajaxTps();
            });
            tpsIdChoice = new Choices('#tps_id', {
                placeholderValue: 'Pilih...',
                removeItems: !document.getElementById('tps_id').getAttribute('required'),
                removeItemButton: !document.getElementById('tps_id').getAttribute('required'),
                shouldSort: false,
                shouldSortItems: false,
                itemSelectText: "",
            });

        }

        if (document.getElementById("multi_tps_id")) {
            var multiTpsIdChoice = new Choices('#multi_tps_id', {
                placeholderValue: 'Pilih...',
                removeItems: true,
                removeItemButton: true,
                shouldSort: false,
                shouldSortItems: false,
                itemSelectText: "",
            });



            document.getElementById('kelurahan_desa_id').addEventListener('change', function() {
                valueKelurahanDesaId = this.value;
                ajaxMultiTps();
            });

            // if (kelurahanDesaIdChoice != '' && kelurahanDesaIdChoice != null && valueKelurahanDesaId) {
            //     ajaxMultiTps();
            // }
        }

        if (document.getElementById('dpt_id')) {
            if (document.getElementById('tps_id')) {
                document.getElementById('tps_id').addEventListener('change', function() {
                    valueTpsId = this.value;
                    ajaxDpt();
                });
            } else if (document.getElementById('multi_tps_id')) {
                document.getElementById('multi_tps_id').addEventListener('change', function() {
                    valueMultiTpsId = Array.from(document.querySelectorAll('#multi_tps_id option:checked')).map(
                        el => el.value);
                    ajaxDpt();
                });
            }

            dptIdChoice = new Choices('#dpt_id', {
                placeholderValue: 'Pilih...',
                removeItems: !document.getElementById('dpt_id').getAttribute('required'),
                removeItemButton: !document.getElementById('dpt_id').getAttribute('required'),
                shouldSort: false,
                shouldSortItems: false,
                itemSelectText: "",
            });
        }

        window.addEventListener('load', function() {
            if (provinsiIdChoice != null && valueProvinsiId) {
                provinsiIdChoice.setChoiceByValue(valueProvinsiId);
                if (kabupatenKotaIdChoice != null) {
                    ajaxKabupatenKota();
                }
            }

            if (kabupatenKotaIdChoice != null && valueKabupatenKotaId) {
                kabupatenKotaIdChoice.setChoiceByValue(valueKabupatenKotaId);
                if (kecamatanIdChoice != null) {
                    ajaxKecamatan();
                }
            }

            if (kelurahanDesaIdChoice != null && valueKecamatanId) {
                kelurahanDesaIdChoice.setChoiceByValue(valueKecamatanId);
                if (kelurahanDesaIdChoice != null) {
                    ajaxKelurahanDesa();
                }
            }

            if (kelurahanDesaIdChoice != null && valueKelurahanDesaId) {
                kelurahanDesaIdChoice.setChoiceByValue(valueKelurahanDesaId);
                if (tpsIdChoice != null) {
                    ajaxTps();
                }
            }

            if (tpsIdChoice != null && valueTpsId) {
                tpsIdChoice.setChoiceByValue(valueTpsId);
                if (dptIdChoice != null) {
                    ajaxDpt();
                }
            }
        });
    </script>
    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>

</html>
<?php /**PATH /var/www/html/hitungpemilih/resources/views/layouts/app.blade.php ENDPATH**/ ?>