<?php $__env->startSection('content'); ?>

    <span class="text-green-500"></span>
    <span class="text-red-500"></span>
    <span class="text-yellow-500"></span>
    <span class="text-green-800"></span>
    <span class="text-red-800"></span>
    <span class="text-yellow-800"></span>
    <span class="bg-red-500"></span>
    <span class="bg-yellow-500"></span>


    <div class="mx-auto max-w-screen-2xl p-4 md:p-6 2xl:p-10">
        <div class="flex flex-col md:flex-row justify-stretch items-stretch gap-4 mb-8">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4 w-full">
                <!-- DPT Card -->
                <div class="bg-white dark:bg-boxdark rounded-xl p-2 shadow-sm flex flex-col justify-between">
                    <div class="flex flex-col items-center gap-2 text-center">
                        <div class="w-36 h-36 bg-red-100 rounded-full flex items-center justify-center">
                            <svg xmlns="http://www.w3.org/2000/svg" class="w-24 h-24 text-red-500" viewBox="0 0 20 20"
                                fill="currentColor">
                                <path
                                    d="M9 6a3 3 0 11-6 0 3 3 0 016 0zM17 6a3 3 0 11-6 0 3 3 0 016 0zM12.93 17c.046-.327.07-.66.07-1a6.97 6.97 0 00-1.5-4.33A5 5 0 0119 16v1h-6.07zM6 11a5 5 0 015 5v1H1v-1a5 5 0 015-5z" />
                            </svg>
                        </div>
                        <div>
                            <div class="text-gray-600 dark:text-gray-300 font-medium text-2xl">DPT</div>
                            <div class="text-4xl font-bold"><?php echo e(number_format($jumlahDpt)); ?></div>
                        </div>
                    </div>
                    <a href="<?php echo e(route('dpt.index')); ?>"
                        class="block text-center mt-4 w-full bg-blue-900 text-white py-2 px-4 rounded-lg text-sm">
                        Detail
                    </a>
                </div>

                <div class="flex flex-col gap-2">
                    <!-- Stats Cards -->

                    <div class="bg-white dark:bg-boxdark rounded-xl p-2 shadow-sm">
                        <div class="flex items-center gap-4">
                            <div class="w-10 h-10 bg-yellow-100 rounded-full flex items-center justify-center">
                                <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 text-yellow-600" viewBox="0 0 20 20"
                                    fill="currentColor">
                                    <path
                                        d="M9 6a3 3 0 11-6 0 3 3 0 016 0zM17 6a3 3 0 11-6 0 3 3 0 016 0zM12.93 17c.046-.327.07-.66.07-1a6.97 6.97 0 00-1.5-4.33A5 5 0 0119 16v1h-6.07zM6 11a5 5 0 015 5v1H1v-1a5 5 0 015-5z" />
                                </svg>
                            </div>
                            <div>
                                <div class="text-2xl font-bold"><?php echo e(number_format($jumlahKoordinatorKelurahanDesa)); ?></div>
                                <div class="text-gray-500 text-sm">Koordinator Kel / Desa</div>
                            </div>
                        </div>
                    </div>

                    <div class="bg-white dark:bg-boxdark rounded-xl p-2 shadow-sm">
                        <div class="flex items-center gap-4">
                            <div class="w-10 h-10 bg-cyan-100 rounded-full flex items-center justify-center">
                                <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 text-cyan-600" viewBox="0 0 20 20"
                                    fill="currentColor">
                                    <path
                                        d="M9 6a3 3 0 11-6 0 3 3 0 016 0zM17 6a3 3 0 11-6 0 3 3 0 016 0zM12.93 17c.046-.327.07-.66.07-1a6.97 6.97 0 00-1.5-4.33A5 5 0 0119 16v1h-6.07zM6 11a5 5 0 015 5v1H1v-1a5 5 0 015-5z" />
                                </svg>
                            </div>
                            <div>
                                <div class="text-2xl font-bold"><?php echo e(number_format($jumlahKoordinatorKecamatan)); ?></div>
                                <div class="text-gray-500 text-sm">Koordinator Kecamatan</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="w-full flex items-stretch justify-stretch">
            </div>
        </div>

    </div>
<?php $__env->stopSection(); ?>


<?php $__env->startPush('scripts'); ?>
    <script src="https://code.highcharts.com/highcharts.js"></script>
    <script src="https://code.highcharts.com/modules/data.js"></script>
    <script src="https://code.highcharts.com/modules/heatmap.js"></script>
    <script src="https://code.highcharts.com/modules/treemap.js"></script>
    <script src="https://code.highcharts.com/modules/exporting.js"></script>
    <script src="https://code.highcharts.com/modules/accessibility.js"></script>
    <script src="https://code.highcharts.com/modules/export-data.js"></script>
    <script>
        const formatter = new Intl.NumberFormat('id-ID', {

            currency: 'IDR',
            trailingZeroDisplay: 'stripIfInteger'
        });
        if (document.getElementById("chart-tps-treemap")) {
            chartTps(<?php echo json_encode($chartTpsData, 15, 512) ?>);
        }


        function chartTps(data) {
            var points = [],
                speciesP,
                speciesVal,
                speciesI = 0,
                sampleP,
                sampleI,
                causeP,
                causeI,
                replP,
                replI,
                species,
                sample,
                cause,
                repl

            for (species in data) {
                if (data.hasOwnProperty(species)) {
                    speciesVal = 0;
                    speciesP = {
                        id: 'id_' + speciesI,
                        name: species,
                        color: Highcharts.getOptions().colors[speciesI]
                    };
                    sampleI = 0;
                    for (sample in data[species]) {
                        if (data[species].hasOwnProperty(sample)) {
                            sampleP = {
                                id: speciesP.id + '_' + sampleI,
                                name: sample,
                                parent: speciesP.id
                            };
                            points.push(sampleP);
                            causeI = 0;
                            for (cause in data[species][sample]) {
                                if (data[species][sample].hasOwnProperty(cause)) {
                                    causeP = {
                                        id: sampleP.id + '_' + causeI,
                                        name: cause,
                                        parent: sampleP.id,
                                        value: Math.round(+data[species][sample][cause])
                                    };
                                    speciesVal += causeP.value;
                                    points.push(causeP);
                                    // replI = 0;
                                    // for (repl in data[species][sample][cause]) {
                                    //     if (data[species][sample][cause].hasOwnProperty(repl)) {
                                    //         replP = {
                                    //             id: causeP.id + '_' + replI,
                                    //             name: repl,
                                    //             parent: causeP.id,
                                    //             value: Math.round(+data[species][sample][cause][repl])
                                    //         };
                                    //         speciesVal += replP.value;
                                    //         points.push(replP);
                                    //         replI = replI + 1;
                                    //     }
                                    // }
                                    causeI = causeI + 1;
                                }
                            }
                            sampleI = sampleI + 1;
                        }
                    }
                    speciesP.value = Math.round(speciesVal);
                    points.push(speciesP);
                    speciesI = speciesI + 1;
                }
            }


            Highcharts.chart('chart-tps-treemap', {
                exporting: {
                    sourceWidth: 600,
                    sourceHeight: 480,
                    // scale: 2 (default)
                    chartOptions: {
                        subtitle: null
                    },
                    fallbackToExportServer: false,
                    buttons: { // specific options for the export button
                        contextButton: {
                            menuItems: ['downloadPNG', 'downloadJPEG', 'downloadSVG', {
                                textKey: 'downloadXLS',
                                onclick: function() {
                                    this.downloadXLS();
                                }
                            }],
                        },
                    },
                },
                tooltip: {
                    formatter: function() {
                        //console.log(this)
                        var value = this.point.value;
                        if (value > 1) {
                            return value + (' TPS');
                        } else {
                            return false;
                        }
                    },
                    style: {
                        fontWeight: 'bold'
                    },
                    shared: false,
                    animation: false,
                    hideDelay: 200,
                    delayForDisplay: 200,
                    useHTML: true
                },
                series: [{
                    type: 'treemap',
                    layoutAlgorithm: 'stripes',
                    layoutStartingDirection: 'vertical',
                    allowDrillToNode: true,
                    animationLimit: 1000,
                    dataLabels: {
                        enabled: false
                    },
                    levelIsConstant: false,
                    levels: [{
                            layoutAlgorithm: 'squarified',
                            layoutStartingDirection: 'vertical',
                            level: 1,
                            dataLabels: {
                                enabled: true,
                                format: '{point.name}',
                                style: {
                                    fontSize: '14px',
                                }
                            },
                            borderWidth: 3
                        },
                        {
                            level: 2,
                            layoutAlgorithm: 'squarified',
                            layoutStartingDirection: 'horizontal',
                        },
                        {
                            level: 3,
                            layoutAlgorithm: 'squarified',
                            layoutStartingDirection: 'horizontal',
                        },
                        {
                            level: 4,
                            layoutAlgorithm: 'squarified',
                            layoutStartingDirection: 'horizontal',
                        }
                    ],
                    data: points,
                }],
                subtitle: {
                    text: 'Klik daerah untuk melihat detail'
                },
                title: {
                    text: 'Sebaran TPS'
                },
                chart: {
                    animation: {
                        duration: 350
                    }
                },
                credits: {
                    enabled: false
                },
            });
        }

        if (document.getElementById("chart-dpt-treemap")) {
            chartDpt(<?php echo json_encode($chartDptData, 15, 512) ?>);
        }

        function chartDpt(data) {
            var points = [],
                speciesP,
                speciesVal,
                speciesI = 0,
                sampleP,
                sampleI,
                causeP,
                causeI,
                replP,
                replI,
                species,
                sample,
                cause,
                repl

            for (species in data) {
                if (data.hasOwnProperty(species)) {
                    speciesVal = 0;
                    speciesP = {
                        id: 'id_' + speciesI,
                        name: species,
                        color: Highcharts.getOptions().colors[speciesI]
                    };
                    sampleI = 0;
                    for (sample in data[species]) {
                        if (data[species].hasOwnProperty(sample)) {
                            sampleP = {
                                id: speciesP.id + '_' + sampleI,
                                name: sample,
                                parent: speciesP.id
                            };
                            points.push(sampleP);
                            causeI = 0;
                            for (cause in data[species][sample]) {
                                if (data[species][sample].hasOwnProperty(cause)) {
                                    causeP = {
                                        id: sampleP.id + '_' + causeI,
                                        name: cause,
                                        parent: sampleP.id,
                                        value: Math.round(+data[species][sample][cause])
                                    };
                                    speciesVal += causeP.value;
                                    points.push(causeP);
                                    // replI = 0;
                                    // for (repl in data[species][sample][cause]) {
                                    //     if (data[species][sample][cause].hasOwnProperty(repl)) {
                                    //         replP = {
                                    //             id: causeP.id + '_' + replI,
                                    //             name: repl,
                                    //             parent: causeP.id,
                                    //             value: Math.round(+data[species][sample][cause][repl])
                                    //         };
                                    //         speciesVal += replP.value;
                                    //         points.push(replP);
                                    //         replI = replI + 1;
                                    //     }
                                    // }
                                    causeI = causeI + 1;
                                }
                            }
                            sampleI = sampleI + 1;
                        }
                    }
                    speciesP.value = Math.round(speciesVal);
                    points.push(speciesP);
                    speciesI = speciesI + 1;
                }
            }


            Highcharts.chart('chart-dpt-treemap', {
                exporting: {
                    sourceWidth: 600,
                    sourceHeight: 480,
                    // scale: 2 (default)
                    chartOptions: {
                        subtitle: null
                    },
                    fallbackToExportServer: false,
                    buttons: { // specific options for the export button
                        contextButton: {
                            menuItems: ['downloadPNG', 'downloadJPEG', 'downloadSVG', {
                                textKey: 'downloadXLS',
                                onclick: function() {
                                    this.downloadXLS();
                                }
                            }],
                        },
                    },
                },
                tooltip: {
                    formatter: function() {
                        //console.log(this)
                        var value = this.point.value;
                        if (value > 1) {
                            return value + (' DPT');
                        } else {
                            return false;
                        }
                    },
                    style: {
                        fontWeight: 'bold'
                    },
                    shared: false,
                    animation: false,
                    hideDelay: 200,
                    delayForDisplay: 200,
                    useHTML: true
                },
                series: [{
                    type: 'treemap',
                    layoutAlgorithm: 'stripes',
                    layoutStartingDirection: 'vertical',
                    allowDrillToNode: true,
                    animationLimit: 1000,
                    dataLabels: {
                        enabled: false
                    },
                    levelIsConstant: false,
                    levels: [{
                            layoutAlgorithm: 'squarified',
                            layoutStartingDirection: 'vertical',
                            level: 1,
                            dataLabels: {
                                enabled: true,
                                format: '{point.name}',
                                style: {
                                    fontSize: '14px',
                                }
                            },
                            borderWidth: 3
                        },
                        {
                            level: 2,
                            layoutAlgorithm: 'squarified',
                            layoutStartingDirection: 'horizontal',
                        },
                        {
                            level: 3,
                            layoutAlgorithm: 'squarified',
                            layoutStartingDirection: 'horizontal',
                        },
                        {
                            level: 4,
                            layoutAlgorithm: 'squarified',
                            layoutStartingDirection: 'horizontal',
                        }
                    ],
                    data: points,
                }],
                subtitle: {
                    text: 'Klik daerah untuk melihat detail'
                },
                title: {
                    text: 'Sebaran DPT'
                },
                chart: {
                    animation: {
                        duration: 350
                    }
                },
                credits: {
                    enabled: false
                },
            });
        }

        if (document.getElementById("chart-suara-treemap")) {
            chartSuara(<?php echo json_encode($chartSuaraData, 15, 512) ?>);
        }

        function chartSuara(data) {
            var points = [],
                speciesP,
                speciesVal,
                speciesI = 0,
                sampleP,
                sampleI,
                causeP,
                causeI,
                replP,
                replI,
                species,
                sample,
                cause,
                repl

            for (species in data) {
                if (data.hasOwnProperty(species)) {
                    speciesVal = 0;
                    speciesP = {
                        id: 'id_' + speciesI,
                        name: species,
                        color: Highcharts.getOptions().colors[speciesI]
                    };
                    sampleI = 0;
                    for (sample in data[species]) {
                        if (data[species].hasOwnProperty(sample)) {
                            sampleP = {
                                id: speciesP.id + '_' + sampleI,
                                name: sample,
                                parent: speciesP.id
                            };
                            points.push(sampleP);
                            causeI = 0;
                            for (cause in data[species][sample]) {
                                if (data[species][sample].hasOwnProperty(cause)) {
                                    causeP = {
                                        id: sampleP.id + '_' + causeI,
                                        name: cause,
                                        parent: sampleP.id,
                                        value: Math.round(+data[species][sample][cause])
                                    };
                                    speciesVal += causeP.value;
                                    points.push(causeP);
                                    // replI = 0;
                                    // for (repl in data[species][sample][cause]) {
                                    //     if (data[species][sample][cause].hasOwnProperty(repl)) {
                                    //         replP = {
                                    //             id: causeP.id + '_' + replI,
                                    //             name: repl,
                                    //             parent: causeP.id,
                                    //             value: Math.round(+data[species][sample][cause][repl])
                                    //         };
                                    //         speciesVal += replP.value;
                                    //         points.push(replP);
                                    //         replI = replI + 1;
                                    //     }
                                    // }
                                    causeI = causeI + 1;
                                }
                            }
                            sampleI = sampleI + 1;
                        }
                    }
                    speciesP.value = Math.round(speciesVal);
                    points.push(speciesP);
                    speciesI = speciesI + 1;
                }
            }


            Highcharts.chart('chart-suara-treemap', {
                exporting: {
                    sourceWidth: 600,
                    sourceHeight: 480,
                    // scale: 2 (default)
                    chartOptions: {
                        subtitle: null
                    },
                    fallbackToExportServer: false,
                    buttons: { // specific options for the export button
                        contextButton: {
                            menuItems: ['downloadPNG', 'downloadJPEG', 'downloadSVG', {
                                textKey: 'downloadXLS',
                                onclick: function() {
                                    this.downloadXLS();
                                }
                            }],
                        },
                    },
                },
                tooltip: {
                    formatter: function() {
                        //console.log(this)
                        var value = this.point.value;
                        if (value > 1) {
                            return value + (' Suara');
                        } else {
                            return false;
                        }
                    },
                    style: {
                        fontWeight: 'bold'
                    },
                    shared: false,
                    animation: false,
                    hideDelay: 200,
                    delayForDisplay: 200,
                    useHTML: true
                },
                series: [{
                    type: 'treemap',
                    layoutAlgorithm: 'stripes',
                    layoutStartingDirection: 'vertical',
                    allowDrillToNode: true,
                    animationLimit: 1000,
                    dataLabels: {
                        enabled: false
                    },
                    levelIsConstant: false,
                    levels: [{
                            layoutAlgorithm: 'squarified',
                            layoutStartingDirection: 'vertical',
                            level: 1,
                            dataLabels: {
                                enabled: true,
                                format: '{point.name}',
                                style: {
                                    fontSize: '14px',
                                }
                            },
                            borderWidth: 3
                        },
                        {
                            level: 2,
                            layoutAlgorithm: 'squarified',
                            layoutStartingDirection: 'horizontal',
                        },
                        {
                            level: 3,
                            layoutAlgorithm: 'squarified',
                            layoutStartingDirection: 'horizontal',
                        },
                        {
                            level: 4,
                            layoutAlgorithm: 'squarified',
                            layoutStartingDirection: 'horizontal',
                        }
                    ],
                    data: points,
                }],
                subtitle: {
                    text: 'Klik daerah untuk melihat detail'
                },
                title: {
                    text: 'Sebaran Suara'
                },
                chart: {
                    animation: {
                        duration: 350
                    }
                },
                credits: {
                    enabled: false
                },
            });
        }

        var opts = {
            chart: {
                type: 'pie',

            },

            title: {
                text: null
            },

            credits: {
                enabled: false
            },

            plotOptions: {
                series: {
                    allowPointSelect: true,
                    cursor: 'pointer',
                    dataLabels: [{
                        enabled: false,
                        distance: 20
                    }, {
                        enabled: true,
                        distance: -40,
                        format: '{point.percentage:.1f}%',
                        style: {
                            fontSize: '1em',
                            opacity: 0.7
                        },

                    }]
                },
                pie: {
                    allowPointSelect: true,
                    cursor: 'pointer',
                    dataLabels: {
                        enabled: false
                    },
                    showInLegend: true
                }
            },
            series: [],
            colors: ['#ffd56d', '#ca0705'],


        };

        const highchartPies = document.querySelectorAll('.highchart-pie');
        for (let i = 0; i < highchartPies.length; i++) {
            const pieElm = highchartPies[i];
            const pieData = JSON.parse(pieElm.dataset['chart']);
            var cloneOpts = structuredClone(opts);
            if (pieData[0].name == "Sudah Terinput") {
                const dptData = JSON.parse(pieElm.dataset['dpt']);
                cloneOpts.legend = {
                        useHTML: true,
                        labelFormatter: function() {
                            if (this.name == "Sudah Terinput") {
                                return '<p>' + this.name + '</p><p> DPT : ' + formatter.format(dptData
                                    .jumlah_dpt - dptData.jumlah_dpt_belum_nyoblos) + '</p>';
                            }
                            if (this.name == "Belum Terinput") {
                                return '<p>' + this.name + '</p><p> DPT : ' + formatter.format(dptData
                                    .jumlah_dpt_belum_nyoblos) + '</p>';
                            }


                            return this.name;

                        },
                    };

            } else if (pieData[0].name == "Isran-Hadi") {
                cloneOpts.colors = [ '#ca0705','#ffd56d'];
            }

            var pieChart = Highcharts.chart(pieElm, cloneOpts);
            pieChart.addSeries({
                name: pieElm.dataset['title'],
                colorByPoint: true,
                data: pieData
            });


        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/hitungpemilih/resources/views/dashboard.blade.php ENDPATH**/ ?>