<?php

use App\Helpers\Helper;
use App\Http\Controllers\AjaxController;
use App\Http\Controllers\CalonController;
use App\Http\Controllers\PartaiController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\DpsController;
use App\Http\Controllers\DptController;
use App\Http\Controllers\GeneratorOtpController;
use App\Http\Controllers\KabupatenKotaController;
use App\Http\Controllers\KecamatanController;
use App\Http\Controllers\KelurahanDesaController;
use App\Http\Controllers\LaporanPelatihanController;
use App\Http\Controllers\LoginController;
use App\Http\Controllers\LogoutController;
use App\Http\Controllers\PelatihController;
use App\Http\Controllers\PengumumanController;
use App\Http\Controllers\ProfileSettingController;
use App\Http\Controllers\ProvinsiController;
use App\Http\Controllers\Saksi\ChangePasswordController;
use App\Http\Controllers\Saksi\HomeController;
use App\Http\Controllers\Saksi\InputLampiranController;
use App\Http\Controllers\Saksi\InputSuaraController;
use App\Http\Controllers\Saksi\LihatCalonController;
use App\Http\Controllers\Saksi\ProfileController;
use App\Http\Controllers\SaksiController;
use App\Http\Controllers\SuaraController;
use App\Http\Controllers\TpsController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\UserKoordinatorController;
use App\Http\Controllers\UserLogController;
use App\Models\FileLampiran;
use App\Models\Suara;
use App\Models\SuaraDetail;
use App\Models\Tps;
use App\Models\UserLog;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Route;
use Yajra\DataTables\Facades\DataTables;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('fix-suara-tps-dobel', function () {
    $tps_id = DB::select('SELECT max(id) as id, tps_id,deleted_at,updated_at FROM suaras where deleted_at is null group by tps_id having count(*) >= 2');
    $suaras = Suara::with('suara_details')->whereIn('id',array_column($tps_id, 'id'))->with('multi_user')->get();
    foreach ($suaras as $suara) {
        $multi_user_id = $suara->multi_user->pluck('id')->toArray();
        $oldSuaras = Suara::where('tps_id',$suara->tps_id)->where('id','!=',$suara->id)->with('multi_user','suara_details')->orderBy('id','DESC')->get();
        foreach ($oldSuaras as $old) {
            foreach ($old->multi_user as $multi_user) {
                if(!in_array($multi_user->id,$multi_user_id)){
                    $multi_user_id[] = $multi_user->id;
                }
            }
        }

        if($suara->suara_details->count() == 0 && $oldSuaras->count() > 0){
            foreach($oldSuaras[0]->suara_details as $detail){
                $suara->suara_details()->updateOrCreate([
                    'calon_id'=>$detail->calon_id
                ],[
                    'jumlah_suara'=>(int)$detail->jumlah_suara,
                ]);
            }
            $suara->update([
                'total_suara'=>@$oldSuaras[0]->suara_details->sum('jumlah_suara') ?? 0
            ]);
        }
        
        $suara->multi_user()->sync($multi_user_id);
        Suara::where('tps_id',$suara->tps_id)->where('id','!=',$suara->id)->delete();
        
    }
    $dataTps = Tps::whereIn('id', array_column($tps_id, 'tps_id'))->orderBy('kelurahan_desa_id','asc')->orderBy('nomor','asc')->get();
    Helper::addUserLog("Menghapus suara dobel untuk TPS : ".implode(", ",$dataTps->pluck('nomor')->toArray()),json_encode($dataTps));
    return count($tps_id);
});

Route::get('suara-tps-dobel', function () {
    $tps_id = DB::select('SELECT max(id) as id, tps_id,deleted_at,updated_at FROM suaras where deleted_at is null group by tps_id having count(*) >= 2');
    $dataTps = Tps::with('kelurahan_desa.kecamatan')->whereIn('id', array_column($tps_id, 'tps_id'))->orderBy('kelurahan_desa_id','asc')->orderBy('nomor','asc')->get();
    foreach ($dataTps as $tps) {
        echo "TPS : ".$tps->nomor." - ".$tps->kelurahan_desa->nama." - ".$tps->kelurahan_desa->kecamatan->nama." - ID : ".$tps->id;
        echo "<br>";
    }
    dd($tps_id);
});

Route::get('fix-saksi-bertugas', function () {
    $suaras = Suara::with('multi_user')->get();
    foreach($suaras as $suara){
        $suara->multi_user()->sync($suara->multi_user->where('tps_id','=',$suara->tps_id)->pluck('id')->toArray());
    }
    return "okoc";
});

// Route::get('clear-suara', function () {
//     if (strtotime(date("Y-m-d")) < strtotime("2024-11-27")) {
//         FileLampiran::whereDate('created_at', '<', "2024-11-27")->delete();
//         SuaraDetail::whereDate('created_at', '<', "2024-11-27")->delete();
//         Suara::whereDate('created_at', '<', "2024-11-27")->delete();
//     }
//     return Suara::count();
// });


Route::get('test-fcm', function () {
    return Helper::sendFcm("Test", "test body", null, request()->topic);
});

Route::get('send-fcm', function () {
    return Helper::sendFcm(request()->title, request()->body, null, request()->topic);
});

Route::get('test-woo-wa', function () {
    dd(vars: Helper::sendWa("081545419859", "testing : ".date("Y-m-d H:i:s")));

});

Route::get('test-fonnte', function () {
    dd(vars: Helper::sendWaFonnte("081545419859", "testing : ".date("Y-m-d H:i:s")));
});

Route::group(['middleware' => 'auth'], function () {
    Route::post('logout', [LogoutController::class, 'logout'])->name('logout');
});

// Route::get('sync-status-user', [AjaxController::class, 'syncStatusUser'])->name('sync-status-user');
// Route::get('sync-no-wa-user', [AjaxController::class, 'syncNoWaUser'])->name('sync-no-wa-user');
// Route::get('sync-nik-user', [AjaxController::class, 'syncNikUser'])->name('sync-nik-user');
// Route::get('fix-no-wa-user', [AjaxController::class, 'fixNoWaUser'])->name('fix-no-wa-user');
// Route::get('fix-nik-user', [AjaxController::class, 'fixNikUser'])->name('fix-nik-user');

Route::get('ajax/kelurahan-desa', [AjaxController::class, 'ajaxKelurahanDesa'])->name('ajax-kelurahan-desa');
Route::get('ajax/kecamatan', [AjaxController::class, 'ajaxkecamatan'])->name('ajax-kecamatan');
Route::get('ajax/kabupaten-kota', [AjaxController::class, 'ajaxKabupatenKota'])->name('ajax-kabupaten-kota');
Route::group(['middleware' => 'authUser'], function () {
    Route::get('ajax/dpt', [AjaxController::class, 'ajaxDpt'])->name('ajax-dpt');
    Route::get('ajax/dps', [AjaxController::class, 'ajaxDps'])->name('ajax-dps');
    Route::get('ajax/tps', [AjaxController::class, 'ajaxTps'])->name('ajax-tps');
    Route::get('ajax/user-saksi', [AjaxController::class, 'ajaxUserSaksi'])->name('ajax-user-saksi');
    Route::get('ajax/aktif-pengumuman/{id}', [AjaxController::class, 'updateAktifPengumuman'])->name('ajax-aktif-pengumuman');



    Route::get('/', [DashboardController::class, 'index'])->name('dashboard');
    Route::group(['prefix' => 'master-data', 'as' => 'master-data.'], function () {
        Route::resource('tps', TpsController::class);
    });
    Route::group(['prefix' => 'master-data', 'as' => 'master-data.', 'middleware' => ['userRole:admin']], function () {
        Route::resource('provinsi', ProvinsiController::class);
        Route::resource('kabupaten-kota', KabupatenKotaController::class);
        Route::resource('kecamatan', KecamatanController::class);
        Route::resource('kelurahan-desa', KelurahanDesaController::class);
        // Route::resource('tps', TpsController::class);
        Route::resource('calon', CalonController::class);
        Route::resource('partai', PartaiController::class);
    });

    Route::group([
        'middleware' => 'userRole:admin',
    ], function () {
        Route::get('user/import', [UserController::class, 'importView'])->name('user.import-view');
        Route::post('user/import', [UserController::class, 'import'])->name('user.import');
        Route::resource('user', UserController::class);
    });

    Route::get('pelatih/import', [PelatihController::class, 'importView'])->name('pelatih.import-view');
    Route::post('pelatih/import', [PelatihController::class, 'import'])->name('pelatih.import');

    Route::get('pelatih/data-pelatih', [PelatihController::class, 'getPelatih'])->name('pelatih.data-pelatih');
    Route::get('pelatih/data-laporan-pelatihan', [PelatihController::class, 'getLaporanPelatihan'])->name('pelatih.data-laporan-pelatihan');
    Route::resource('pelatih', PelatihController::class);
    Route::get('laporan-pelatihan/get-file-absensi/{idLaporan}/{index}', [LaporanPelatihanController::class, 'getFileAbsen'])->name('laporan-pelatihan.get-file-absensi');
    Route::get('laporan-pelatihan/get-file-dokumetnasi/{idLaporan}/{index}', [LaporanPelatihanController::class, 'getFileDokumentasi'])->name('laporan-pelatihan.get-file-dokumentasi');
    Route::get('laporan-pelatihan/get-file-anggaran/{idLaporan}/{index}', [LaporanPelatihanController::class, 'getFileAnggaran'])->name('laporan-pelatihan.get-file-anggaran');
    Route::resource('laporan-pelatihan', LaporanPelatihanController::class);


    Route::resource('pengumuman', PengumumanController::class);
    Route::post('pengumuman/{id}/send-again', [PengumumanController::class, 'sendAgain'])->name('pengumuman.send-again');



    Route::get('saksi/import', [SaksiController::class, 'importView'])->name('saksi.import-view');
    Route::get('saksi/import/result', [SaksiController::class, 'importResult'])->name('saksi.import-result');
    Route::post('saksi/import', [SaksiController::class, 'import'])->name('saksi.import');
    Route::get('saksi/surat-mandat-bulk', [SaksiController::class, 'suratMandatBulk'])->name('saksi.surat-mandat-bulk');
    Route::resource('saksi', SaksiController::class);
    Route::get('saksi/{id}/surat-mandat', [SaksiController::class, 'suratMandat'])->name('saksi.surat-mandat');

    Route::get('user-koordinator/import', [UserKoordinatorController::class, 'importView'])->name('user-koordinator.import-view');
    Route::get('user-koordinator/import/result', [UserKoordinatorController::class, 'importResult'])->name('user-koordinator.import-result');
    Route::post('user-koordinator/import', [UserKoordinatorController::class, 'import'])->name('user-koordinator.import');
    Route::get('user-koordinator/surat-mandat-bulk', [UserKoordinatorController::class, 'suratMandatBulk'])->name('user-koordinator.surat-mandat-bulk');
    Route::resource('user-koordinator', UserKoordinatorController::class);
    Route::get('user-koordinator/{id}/surat-mandat', [UserKoordinatorController::class, 'suratMandat'])->name('user-koordinator.surat-mandat');

    Route::get('saksi/ajax/dps', [SaksiController::class, 'ajaxDps'])->name('saksi.ajax-dps');
    Route::get('dps/import', [DpsController::class, 'importView'])->name('dps.import-view');
    Route::post('dps/import', [DpsController::class, 'import'])->name('dps.import');
    Route::resource('dps', DpsController::class);

    Route::get('suara/download', [SuaraController::class, 'download'])->name('suara.download');
    Route::get('suara/import', [SuaraController::class, 'importView'])->name('suara.import-view');
    // Route::get('saksi/import/result', [SaksiController::class, 'importResult'])->name('saksi.import-result');
    Route::post('suara/import', [SuaraController::class, 'import'])->name('suara.import');
    Route::resource('suara', SuaraController::class);
    Route::get('suara/file-lampiran/{id}', [SuaraController::class, 'getFileLampiran'])->name('suara.file-lampiran.get');
    Route::post('suara/status/{id}', [SuaraController::class, 'status'])->name('suara.status');
    Route::get('suara/download/{id}', [SuaraController::class, 'downloadSingleData'])->name('suara.download-single');
    Route::get('suara/ajax/sudah-diinput', [SuaraController::class, 'checkSudahDiinput'])->name('suara.ajax.sudah-diinput');
    Route::get('suara/ajax/check-kpu', [SuaraController::class, 'checkKpu'])->name('suara.ajax.check-kpu');


    Route::get('dpt/import', [DptController::class, 'importView'])->name('dpt.import-view');
    Route::post('dpt/import', [DptController::class, 'import'])->name('dpt.import');
    Route::resource('dpt', DptController::class);

    Route::get('user-log', [UserLogController::class, 'index'])->name('user-log.index');

    Route::get('setting/profile', [ProfileSettingController::class, 'index'])->name('setting.profile');
    Route::post('setting/profile', [ProfileSettingController::class, 'updateProfile'])->name('setting.profile.update');
    Route::get('setting/new-password', [ProfileSettingController::class, 'newPassword'])->name('setting.new-password');
    Route::post('setting/new-password', [ProfileSettingController::class, 'updatePassword'])->name('setting.new-password.update');

    Route::get('generator-otp', [GeneratorOtpController::class, 'index'])->name('generator-otp.index');
    Route::post('generator-otp', [GeneratorOtpController::class, 'generate'])->name('generator-otp.generate');
});

Route::group(['middleware' => 'userSaksi', 'prefix' => 'user-saksi', 'as' => 'user-saksi.'], function () {
    Route::post('ajax/save-suara', [AjaxController::class, 'saveSuara'])->name('ajax.save-suara');
    Route::get('/', [HomeController::class, 'index'])->name('home');
    Route::get('/input-suara', action: [InputSuaraController::class, 'index'])->name('input-suara.index');
    Route::post('/input-suara', action: [InputSuaraController::class, 'save'])->name('input-suara.save');
    Route::get('/profile', action: [ProfileController::class, 'index'])->name('profile.index');

    Route::get('/input-lampiran', action: [InputLampiranController::class, 'index'])->name('input-lampiran.index');
    Route::post('/input-lampiran', action: [InputLampiranController::class, 'save'])->name('input-lampiran.save');
    Route::get('/file-lampiran/{id}', action: [InputLampiranController::class, 'getFileLampiran'])->name('file-lampiran.get');

    Route::get('/lihat-calon', [LihatCalonController::class, 'index'])->name('lihat-calon.index');
    // Route::get('/change-password', [ChangePasswordController::class, 'index'])->name('change-password.index');
    // Route::post('/change-password', [ChangePasswordController::class, 'change'])->name('change-password.change');
});

Route::get('/login', [LoginController::class, 'index'])->name('login')->middleware('guest');
Route::group(['middleware' => ['guest', 'verifikasiOtpLimit']], function () {

    Route::get('cek-otp/{no_wa}', [LoginController::class, 'otpPage'])->name('cek-otp.page')->middleware('guest');
    Route::post('cek-otp/{no_wa}', [LoginController::class, 'otpAuth'])->name('cek-otp.auth')->middleware('guest');
    Route::post('resend-otp/{no_wa}', [LoginController::class, 'resendOtp'])->name('cek-otp.resend')->middleware('guest');
});


Route::get('cek-password/{no_wa}', [LoginController::class, 'passwordPage'])->name('cek-password.page')->middleware('guest');
Route::post('cek-password/{no_wa}', [LoginController::class, 'passwordAuth'])->name('cek-password.auth')->middleware('guest');

Route::post('/auth', [LoginController::class, 'auth'])->name('auth');
