<?php

use App\Http\Controllers\Api\ApiAuthController;
use App\Http\Controllers\Api\ApiJumlahDptController;
use App\Http\Controllers\Api\ApiJumlahSuaraController;
use App\Http\Controllers\Api\ApiJumlahTpsController;
use App\Http\Controllers\Api\ApiSaveSuaraController;
use App\Http\Controllers\Api\ApiStatusServerController;
use App\Http\Controllers\Api\ApiUpdateController;
use App\Http\Controllers\Api\ApiUploadController;
use App\Http\Controllers\Api\ApiZonaInfoController;
use App\Http\Controllers\Api\Mobile\ApiChangePasswordController;
use App\Http\Controllers\Api\Mobile\ApiDashboardController;
use App\Http\Controllers\Api\Mobile\ApiInputSuaraController;
use App\Http\Controllers\Api\Mobile\ApiLihatSuaraController;
use App\Http\Controllers\Api\Mobile\ApiOtpController;
use App\Http\Controllers\Api\Mobile\ApiProfileController;
use App\Http\Controllers\Api\Mobile\ApiUploadLampiranController;
use App\Models\User;
use App\Models\UserLog;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use Yajra\DataTables\Facades\DataTables;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::get('/', function () {
    return response()->json([
        'time'=>date("Y-m-d H:i:s")
    ]);
});

Route::get('datatable-user-log', function () {
    $model = UserLog::with('user');
 
    return DataTables::of($model)->addColumn('user', function (UserLog $data) {
        return $data->user->nama;
    })->toJson();
});

Route::post('/upload',[ApiUploadController::class,'upload'])->name('upload');
Route::post('/update',[ApiUpdateController::class,'update'])->name('update');
Route::post('/update-nik',[ApiUpdateController::class,'updateNik'])->name('updateNik');
Route::post('/update-tps',[ApiUpdateController::class,'updateTps'])->name('updateTps');

Route::post('/login',[ApiAuthController::class,'login'])->name('login');
Route::post('login-otp', [ApiOtpController::class, 'loginOtp'])->name('login.otp');
Route::post('otp-auth', [ApiOtpController::class, 'otpAuth'])->name('login.otp-auth');
Route::post('resend-otp', [ApiOtpController::class, 'resendOtp'])->name('login.otp-auth');
Route::get('/file-lampiran/{id}',action: [ApiUploadLampiranController::class,'getFileLampiran'])->name('file-lampiran.get');
Route::group(['middleware'=>'auth:sanctum'],function(){
    Route::get('/profile',[ApiProfileController::class,'index'])->name('profile');
    Route::post('/save-suara',[ApiSaveSuaraController::class,'save'])->name('save-suara');

    Route::group(['prefix'=>'mobile','as'=>'mobile.'],function(){
        Route::get('/dashboard',[ApiDashboardController::class,'dataDashboard'])->name('data-dashboard');
        Route::post('/jawab-pengumuman/{id}',[ApiDashboardController::class,'jawabPengumuman'])->name('jawab-pengumuman');
        Route::get('/input-suara',[ApiInputSuaraController::class,'getData'])->name('input-suara.get-data');
        Route::post('/save-suara',[ApiInputSuaraController::class,'save'])->name('save-suara');
        Route::get('/lihat-suara',[ApiLihatSuaraController::class,'getData'])->name('lihat-suara');

        Route::get('/upload-lampiran',[ApiUploadLampiranController::class,'index'])->name('upload-lampiran.index');
        Route::post('/upload-lampiran',[ApiUploadLampiranController::class,'save'])->name('upload-lampiran.save');

        Route::post('/change-password',[ApiChangePasswordController::class,'change'])->name('change-password');

        Route::post('/chunk-upload',[ApiUploadLampiranController::class,'chunkUpload'])->name('upload-lampiran.chunk-upload');
        
       
    });
});

Route::group(['prefix'=>'jumlah-suara','as'=>'jumlah-suara.'],function(){
    Route::get('/calon',[ApiJumlahSuaraController::class,'jumlahSuaraCalon'])->name('calon');
    Route::get('/provinsi',[ApiJumlahSuaraController::class,'jumlahSuaraProvinsi'])->name('provinsi');
    Route::get('/kabupaten-kota/{provinsi_id}',[ApiJumlahSuaraController::class,'jumlahSuaraKabupatenKota'])->name('kabupaten-kota');
    Route::get('/total-suara',[ApiJumlahSuaraController::class,'totalSuara'])->name('total-suara');
});

Route::group(['prefix'=>'jumlah-tps','as'=>'jumlah-tps.'],function(){
    Route::get('/kabupaten-kota/{provinsi_id}',[ApiJumlahTpsController::class,'jumlahTpsKabupatenKota'])->name('kabupaten-kota');
});

Route::group(['prefix'=>'jumlah-dpt','as'=>'jumlah-dpt.'],function(){
    Route::get('/kabupaten-kota/{provinsi_id}',[ApiJumlahDptController::class,'jumlahDptKabupatenKota'])->name('kabupaten-kota');
});

Route::get('/status-server',[ApiStatusServerController::class,'index'])->name('status-server.index');
Route::get('/info',[ApiZonaInfoController::class,'info'])->name('zona.info');
