@extends('layouts.app')

@section('content')
    <div class="mx-auto max-w-screen-2xl p-4 md:p-6 2xl:p-10">
        <div
            class="rounded-sm border border-stroke bg-white px-5 pb-2.5 pt-6 shadow-default dark:border-strokedark dark:bg-boxdark sm:px-7.5 xl:pb-1">
            <h4 class="mb-6 text-xl font-bold text-black dark:text-white">
                Suara TPS : {{$suara->tps->nomor}} / {{$suara->tps->kelurahan_desa->nama}}
            </h4>

            <div class="flex flex-col">



                <div class="space-y-4 mb-4">
                    @foreach ($calons as $calon)
                        <div>
                            <p>No : {{ $calon->nomor }}</p>
                            <p>{{ $calon->nama_calon }}/{{ $calon->nama_wakil_calon }}</p>
                            <p>Suara : {{ $calon->suara_details_sum_jumlah_suara }}</p>
                        </div>
                    @endforeach
                    <hr>
                    {{-- <p>
                        Sah : {{ @$suara->suara_sah ?? 0 }}
                    </p>
                    <hr>
                    <p>
                        Tidak Sah : {{ @$suara->suara_tidak_sah ?? 0 }}
                    </p>
                    <hr>
                    <p>
                        Total : {{ @$suara->total_suara ?? 0 }}
                    </p>
                    <hr>
                    <p>
                        Jumlah DPT : {{ @$suara->jumlah_dpt ?? 0 }}
                    </p>
                    <hr>
                    <p>
                        Jumlah Pengguna Hak Pilih : {{ @$suara->jumlah_hak_pilih ?? 0 }}
                    </p> --}}
                   
                </div>

                <div class="space-y-4 mb-4">
                    <span >Lembar C.HASIL-KWK</span>
                    <ul>
                        @foreach ($suara->file_lampirans as $index => $file_lampiran)
                            <li>
                                <a href="{{route('suara.file-lampiran.get',$file_lampiran->id)}}?t={{date('YmdHis')}}" target="_blank" class="text-blue-500 underline">{{$file_lampiran->nama}}</a>
                            </li>
                        @endforeach
                    </ul>
                </div>
                

            </div>
        </div>


    </div>
@endsection
