@extends('layouts.app')

@section('content')
    <div class="mx-auto max-w-screen-2xl p-4 md:p-6 2xl:p-10">
        <div
            class="rounded-sm border border-stroke bg-white px-5 pb-2.5 pt-6 shadow-default dark:border-strokedark dark:bg-boxdark sm:px-7.5 xl:pb-1">
            <h4 class="mb-6 text-xl font-bold text-black dark:text-white">
                Suara
            </h4>

            <div class="flex flex-col">
                <div class="mb-4  flex flex-col md:flex-row gap-4 w-full justify-between items-center">
                    <div class="flex gap-2 flex-1">
                        <form class="w-full">
                            <input type="hidden" name="koordinator" value="{{ request()->koordinator }}">
                            <div class="grid grid-cols-2 md:grid-cols-4 gap-4 items-end">

                                <div>
                                    <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                                        Provinsi
                                    </label>
                                    <select name="provinsi_id" id="provinsi_id"
                                        class="relative z-20 w-full appearance-none rounded border border-stroke bg-transparent py-3 pl-5 pr-12 outline-none transition focus:border-primary active:border-primary dark:border-form-strokedark dark:bg-form-input">
                                        <option value="">Pilih Provinsi</option>
                                        @foreach ($provinsis as $provinsi)
                                            <option value="{{ $provinsi->id }}"
                                                @if (old('provinsi_id', request()->provinsi_id) == $provinsi->id) selected @endif>
                                                {{ $provinsi->nama }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('provinsi_id')
                                        <span class="text-red-500 text-sm">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div>
                                    <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                                        Kabupaten/Kota <small id="loading-kabupaten-kota"></small>
                                    </label>
                                    <select data-pilih-semua="true" name="kabupaten_kota_id" id="kabupaten_kota_id"
                                        class="relative z-20 w-full js-choice appearance-none rounded border border-stroke bg-transparent py-3 pl-5 pr-12 outline-none transition focus:border-primary active:border-primary dark:border-form-strokedark dark:bg-form-input">

                                    </select>
                                    @error('kabupaten_kota_id')
                                        <span class="text-red-500 text-sm">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div>
                                    <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                                        Kecamatan <small id="loading-kecamatan"></small>
                                    </label>
                                    <select data-pilih-semua="true" name="kecamatan_id" id="kecamatan_id"
                                        class="relative z-20 w-full appearance-none rounded border border-stroke bg-transparent py-3 pl-5 pr-12 outline-none transition focus:border-primary active:border-primary dark:border-form-strokedark dark:bg-form-input">

                                    </select>
                                    @error('kecamatan_id')
                                        <span class="text-red-500 text-sm">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div>
                                    <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                                        Kelurahan/Desa <small id="loading-kelurahan-desa"></small>
                                    </label>
                                    <select data-pilih-semua="true" name="kelurahan_desa_id" id="kelurahan_desa_id"
                                        class="relative z-20 w-full appearance-none rounded border border-stroke bg-transparent py-3 pl-5 pr-12 outline-none transition focus:border-primary active:border-primary dark:border-form-strokedark dark:bg-form-input">

                                    </select>
                                    @error('kelurahan_desa_id')
                                        <span class="text-red-500 text-sm">{{ $message }}</span>
                                    @enderror
                                </div>
                                <div>
                                    <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                                        Partai
                                    </label>
                                    <select name="partai_id" id="partai_id"
                                        class="relative z-20 w-full appearance-none rounded border border-stroke bg-transparent py-3 pl-5 pr-12 outline-none transition focus:border-primary active:border-primary dark:border-form-strokedark dark:bg-form-input">
                                        <option value="">Pilih Partai</option>
                                        @foreach ($partais as $partai)
                                            <option value="{{ $partai->id }}"
                                                @if (old('partai_id', request()->partai_id) == $partai->id) selected @endif>
                                                {{ $partai->nama }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('partai_id')
                                        <span class="text-red-500 text-sm">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div>
                                    <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                                        Tanggal Awal
                                    </label>
                                    <input type="date" name="tanggal_awal" placeholder="Tanggal Awal..."
                                        value="{{ old('tanggal_awal', request()->tanggal_awal) }}"
                                        class="relative z-20 w-full appearance-none rounded border border-stroke bg-transparent py-3 pl-5 pr-5 outline-none transition focus:border-primary active:border-primary dark:border-form-strokedark dark:bg-form-input" />

                                </div>
                                <div>
                                    <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                                        Tanggal Akhir
                                    </label>
                                    <input type="date" name="tanggal_akhir" placeholder="Tanggal Akhir..."
                                        value="{{ old('tanggal_akhir', request()->tanggal_akhir) }}"
                                        class="relative z-20 w-full appearance-none rounded border border-stroke bg-transparent py-3 pl-5 pr-5 outline-none transition focus:border-primary active:border-primary dark:border-form-strokedark dark:bg-form-input" />

                                </div>


                                <button type="submit"
                                    class=" flex items-center justify-center  py-2 px-4 rounded-lg bg-primary text-white font-medium text-sm hover:bg-primaryhover transition duration-200">
                                    Filter
                                </button>
                                {{-- <button type="submit"
                                    class=" flex items-center justify-center  py-2 px-4 rounded-lg bg-success text-white font-medium text-sm hover:bg-primaryhover transition duration-200">
                                    Download
                                </button> --}}
                            </div>
                        </form>
                    </div>
                    <div class="flex gap-2 flex-col items-stretch justify-start md:items-start w-full md:w-auto">
                        <a href="{{ route('suara.index', array_merge(request()->all(), ['export' => 'true'])) }}"
                            class="flex items-center justify-center gap-2 py-2 px-4 rounded-lg bg-success text-white font-medium text-sm hover:bg-primaryhover transition duration-200">
                            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24">
                                <path fill="currentColor"
                                    d="M4 3h14a2 2 0 0 1 2 2v7.08a6 6 0 0 0-4.32.92H12v4h1.08c-.11.68-.11 1.35 0 2H4a2 2 0 0 1-2-2V5c0-1.1.9-2 2-2m0 4v4h6V7zm8 0v4h6V7zm-8 6v4h6v-4zm15.44 8v-2h-4v-2h4v-2l3 3z" />
                            </svg> Export Suara
                        </a>
                        <a href="{{ route('suara.import-view') }}"
                            class="flex items-center justify-center gap-2 py-2 px-4 rounded-lg bg-success text-white font-medium text-sm hover:bg-primaryhover transition duration-200">
                            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24">
                                <path fill="currentColor"
                                    d="M4 3h14a2 2 0 0 1 2 2v7.08a6 6 0 0 0-4.32.92H12v4h1.08c-.11.68-.11 1.35 0 2H4a2 2 0 0 1-2-2V5c0-1.1.9-2 2-2m0 4v4h6V7zm8 0v4h6V7zm-8 6v4h6v-4zm14.44 2v2h4v2h-4v2l-3-3z" />
                            </svg> Import Suara
                        </a>
                        <a href="{{ route('suara.download') }}?{{ http_build_query(request()->all()) }}"
                            class="flex items-center justify-center gap-2 py-2 px-4 rounded-lg bg-success text-white font-medium text-sm hover:bg-primaryhover transition duration-200">
                            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24">
                                <path fill="currentColor"
                                    d="m12 16l-5-5l1.4-1.45l2.6 2.6V4h2v8.15l2.6-2.6L17 11zm-6 4q-.825 0-1.412-.587T4 18v-3h2v3h12v-3h2v3q0 .825-.587 1.413T18 20z" />
                            </svg> <span>Download C Hasil</span>
                        </a>
                        <a href="{{ route('suara.create') }}"
                            class="flex items-center justify-center gap-2 py-2 px-4 rounded-lg bg-primary text-white font-medium text-sm hover:bg-primaryhover transition duration-200">
                            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24">
                                <path fill="currentColor"
                                    d="M12 20c-4.41 0-8-3.59-8-8s3.59-8 8-8s8 3.59 8 8s-3.59 8-8 8m0-18A10 10 0 0 0 2 12a10 10 0 0 0 10 10a10 10 0 0 0 10-10A10 10 0 0 0 12 2m1 5h-2v4H7v2h4v4h2v-4h4v-2h-4z" />
                            </svg> Tambah Suara
                        </a>
                    </div>

                </div>

                <!-- Table -->
                <div>
                    {{ $dataTable->table() }}
                </div>

            </div>
        </div>


    </div>
@endsection
@push('styles')
    <link rel="stylesheet" href="https://cdn.datatables.net/2.1.8/css/dataTables.dataTables.css" />
    <link rel="stylesheet" href="https://cdn.datatables.net/2.1.8/css/dataTables.tailwindcss.css">
@endpush

@push('scripts')
    <script src="https://cdn.datatables.net/2.1.8/js/dataTables.js"></script>
    {{ $dataTable->scripts() }}
@endpush
