<div class="flex flex-col gap-5.5 p-6.5">
    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
        <div class="flex flex-col gap-5.5">
            @if (!isset($suara))
                <div>
                    <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                        Provinsi <small class="text-red-500">*</small>
                    </label>
                    <select name="provinsi_id" id="provinsi_id" required="true"
                        class="relative z-20 w-full appearance-none rounded border border-stroke bg-transparent py-3 pl-5 pr-12 outline-none transition focus:border-primary active:border-primary dark:border-form-strokedark dark:bg-form-input">
                        <option value="">Pilih Provinsi</option>
                        @foreach ($provinsis as $provinsi)
                            <option value="{{ $provinsi->id }}" @if (old('provinsi_id', @$data->provinsi_id) == $provinsi->id) selected @endif>
                                {{ $provinsi->nama }}
                            </option>
                        @endforeach
                    </select>
                    @error('provinsi_id')
                        <span class="text-red-500 text-sm">{{ $message }}</span>
                    @enderror
                </div>

                <div>
                    <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                        Kabupaten/Kota <small id="loading-kabupaten-kota"></small><small class="text-red-500">*</small>
                    </label>
                    <select name="kabupaten_kota_id" id="kabupaten_kota_id" required="true"
                        class="relative z-20 w-full js-choice appearance-none rounded border border-stroke bg-transparent py-3 pl-5 pr-12 outline-none transition focus:border-primary active:border-primary dark:border-form-strokedark dark:bg-form-input">

                    </select>
                    @error('kabupaten_kota_id')
                        <span class="text-red-500 text-sm">{{ $message }}</span>
                    @enderror
                </div>

                <div>
                    <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                        Kecamatan <small id="loading-kecamatan"></small><small class="text-red-500">*</small>
                    </label>
                    <select name="kecamatan_id" id="kecamatan_id" required="true"
                        class="relative z-20 w-full appearance-none rounded border border-stroke bg-transparent py-3 pl-5 pr-12 outline-none transition focus:border-primary active:border-primary dark:border-form-strokedark dark:bg-form-input">

                    </select>
                    @error('kecamatan_id')
                        <span class="text-red-500 text-sm">{{ $message }}</span>
                    @enderror
                </div>

                <div>
                    <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                        Kelurahan/Desa <small id="loading-kelurahan-desa"></small><small class="text-red-500">*</small>
                    </label>
                    <select name="kelurahan_desa_id" id="kelurahan_desa_id" required="true"
                        class="relative z-20 w-full appearance-none rounded border border-stroke bg-transparent py-3 pl-5 pr-12 outline-none transition focus:border-primary active:border-primary dark:border-form-strokedark dark:bg-form-input">

                    </select>
                    @error('kelurahan_desa_id')
                        <span class="text-red-500 text-sm">{{ $message }}</span>
                    @enderror
                </div>

                <div>
                    <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                        TPS <small id="loading-tps"></small><small class="text-red-500">*</small>
                    </label>
                    <select name="tps_id" id="tps_id" required="true" onchange="checkSuara()"
                        class="relative z-20 w-full appearance-none rounded border border-stroke bg-transparent py-3 pl-5 pr-12 outline-none transition focus:border-primary active:border-primary dark:border-form-strokedark dark:bg-form-input">

                    </select>
                    @error('tps_id')
                        <span class="text-red-500 text-sm">{{ $message }}</span>
                    @enderror
                </div>
            @else
                <div>
                    <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                        Provinsi <small class="text-red-500">*</small>
                    </label>
                    <p>{{ @$suara->tps->kelurahan_desa->kecamatan->kabupaten_kota->provinsi->nama }}</p>
                    @error('provinsi_id')
                        <span class="text-red-500 text-sm">{{ $message }}</span>
                    @enderror
                </div>

                <div>
                    <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                        Kabupaten/Kota <small id="loading-kabupaten-kota"></small><small class="text-red-500">*</small>
                    </label>
                    <p>{{ @$suara->tps->kelurahan_desa->kecamatan->kabupaten_kota->nama }}</p>
                    @error('kabupaten_kota_id')
                        <span class="text-red-500 text-sm">{{ $message }}</span>
                    @enderror
                </div>

                <div>
                    <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                        Kecamatan <small id="loading-kecamatan"></small><small class="text-red-500">*</small>
                    </label>
                    <p>{{ @$suara->tps->kelurahan_desa->kecamatan->nama }}</p>
                    @error('kecamatan_id')
                        <span class="text-red-500 text-sm">{{ $message }}</span>
                    @enderror
                </div>

                <div>
                    <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                        Kelurahan/Desa <small id="loading-kelurahan-desa"></small><small class="text-red-500">*</small>
                    </label>
                    <p>{{ @$suara->tps->kelurahan_desa->nama }}</p>
                    @error('kelurahan_desa_id')
                        <span class="text-red-500 text-sm">{{ $message }}</span>
                    @enderror
                </div>

                <div>
                    <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                        TPS <small id="loading-tps"></small><small class="text-red-500">*</small>
                    </label>
                    <p>{{ @$suara->tps->nomor }}</p>
                    @error('tps_id')
                        <span class="text-red-500 text-sm">{{ $message }}</span>
                    @enderror
                </div>
            @endif
            @foreach ($calons as $item)
                <div>
                    <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                        Suara {{ $item['name'] }}
                    </label>
                    <input type="number" name="jumlah_suara[{{ $item['id'] }}]"
                        id="jumlah_suara_{{ $item['id'] }}"
                        value="{{ old('jumlah_suara.' . $item['id'], $item['votes'] ?? 0) }}"
                        class="w-full rounded-lg border-[1.5px] border-stroke bg-transparent px-4 py-2 font-normal text-black outline-none transition focus:border-primary active:border-primary disabled:cursor-default disabled:bg-whiter dark:border-form-strokedark dark:bg-form-input dark:text-white dark:focus:border-primary" />
                    @error('jumlah_suara.' . $item['id'])
                        <span class="text-red-500 text-sm">{{ $message }}</span>
                    @enderror
                </div>
            @endforeach
            <button type="submit"
                class="inline-flex items-center justify-center rounded-md bg-primary px-10 py-4 text-center font-medium text-white hover:bg-opacity-90 lg:px-8 xl:px-10">Simpan</button>
            <button type="button" onclick="checkKpu(this)"
                class="inline-flex items-center justify-center rounded-md bg-danger gap-2 px-10 py-4 text-center font-medium text-white hover:bg-opacity-90 lg:px-8 xl:px-10">
                <span id="label-btn">Cek Pilkada 2024 KPU</span> <span id="loading-btn" class="hidden">Loading...</span>
                <img src="{{ asset('images/logo-kpu.png') }}" alt="" style="width: 24px;"></button>

        </div>
        <div>
            <div>

                <label for="file_1">Lembar 1</label>
                <input type="file" id="file_1" name="file_1" accept="image,.jpg,.png,.jpeg,.tiff,.webp"
                    class="w-full cursor-pointer rounded-lg border-[1.5px] border-stroke bg-transparent font-normal outline-none transition file:mr-5 file:border-collapse file:cursor-pointer file:border-0 file:border-r file:border-solid file:border-stroke file:bg-whiter file:px-5 file:py-3 file:hover:bg-primary file:hover:bg-opacity-10 focus:border-primary active:border-primary disabled:cursor-default disabled:bg-whiter dark:border-form-strokedark dark:bg-form-input dark:file:border-form-strokedark dark:file:bg-white/30 dark:file:text-white dark:focus:border-primary" />
                @error('file_1')
                    <span class="text-red-500 text-sm">{{ $message }}</span>
                @enderror
            </div>

            @if (isset($file1))
                <div>
                    <a href="{{ route('suara.file-lampiran.get', $file1->id) }}" target="_blank">
                        <img id="preview-image-1"
                            src="{{ route('suara.file-lampiran.get', $file1->id) }}?t={{ date('YmdHis') }}"
                            alt="{{ $file1->nama }}" class="w-full h-50 object-contain">
                    </a>
                </div>
            @else
                <div>
                    <a href="" target="_blank">
                        <img src="#" id="preview-image-1" class="w-full h-50 object-contain">
                    </a>
                </div>
            @endif


            <div>

                <label for="file_2">Lembar 2</label>
                <input type="file" id="file_2" name="file_2" accept="image,.jpg,.png,.jpeg,.tiff,.webp"
                    class="w-full cursor-pointer rounded-lg border-[1.5px] border-stroke bg-transparent font-normal outline-none transition file:mr-5 file:border-collapse file:cursor-pointer file:border-0 file:border-r file:border-solid file:border-stroke file:bg-whiter file:px-5 file:py-3 file:hover:bg-primary file:hover:bg-opacity-10 focus:border-primary active:border-primary disabled:cursor-default disabled:bg-whiter dark:border-form-strokedark dark:bg-form-input dark:file:border-form-strokedark dark:file:bg-white/30 dark:file:text-white dark:focus:border-primary" />
                @error('file_2')
                    <span class="text-red-500 text-sm">{{ $message }}</span>
                @enderror
            </div>

            @if (isset($file2))
                <div>
                    <a href="{{ route('suara.file-lampiran.get', $file2->id) }}" target="_blank">
                        <img id="preview-image-2"
                            src="{{ route('suara.file-lampiran.get', $file2->id) }}?t={{ date('YmdHis') }}"
                            alt="{{ $file2->nama }}" class="w-full h-50 object-contain">
                    </a>
                </div>
            @else
                <div>
                    <a href="" target="_blank">
                        <img src="#" id="preview-image-2" class="w-full h-50 object-contain">
                    </a>
                </div>
            @endif

            <div>

                <label for="file_3">Lembar 3</label>
                <input type="file" id="file_3" name="file_3" accept="image,.jpg,.png,.jpeg,.tiff,.webp"
                    class="w-full cursor-pointer rounded-lg border-[1.5px] border-stroke bg-transparent font-normal outline-none transition file:mr-5 file:border-collapse file:cursor-pointer file:border-0 file:border-r file:border-solid file:border-stroke file:bg-whiter file:px-5 file:py-3 file:hover:bg-primary file:hover:bg-opacity-10 focus:border-primary active:border-primary disabled:cursor-default disabled:bg-whiter dark:border-form-strokedark dark:bg-form-input dark:file:border-form-strokedark dark:file:bg-white/30 dark:file:text-white dark:focus:border-primary" />
                @error('file_3')
                    <span class="text-red-500 text-sm">{{ $message }}</span>
                @enderror
            </div>

            @if (isset($file3))
                <div>
                    <a href="{{ route('suara.file-lampiran.get', $file3->id) }}" target="_blank">
                        <img id="preview-image-3"
                            src="{{ route('suara.file-lampiran.get', $file3->id) }}?t={{ date('YmdHis') }}"
                            alt="{{ $file3->nama }}" class="w-full h-50 object-contain">
                    </a>
                </div>
            @else
                <div>
                    <a href="" target="_blank">
                        <img src="#" id="preview-image-3" class="w-full h-50 object-contain">
                    </a>
                </div>
            @endif
        </div>
        <input type="hidden" name="lembar_1_kpu" id="lembar_1_kpu">
        <input type="hidden" name="lembar_2_kpu" id="lembar_2_kpu">
        <input type="hidden" name="lembar_3_kpu" id="lembar_3_kpu">
        {{-- <div class="grid grid-cols-1 overflow-y-auto max-h-100 gap-4">
            @foreach ($suara->file_lampirans as $index => $file_lampiran)
                <p>Lembar {{ $index + 1 }}</p>
                <a href="{{ route('suara.file-lampiran.get', $file_lampiran->id) }}?t={{ date('YmdHis') }}"
                    target="_blank"><img
                        src="{{ route('suara.file-lampiran.get', $file_lampiran->id) }}?t={{ date('YmdHis') }}"
                        alt=""></a>
                <hr class="my-4">
            @endforeach

        </div> --}}
    </div>
</div>
@push('styles')
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/notyf@3/notyf.min.css">
@endpush

@push('scripts')
    <script src="https://cdn.jsdelivr.net/npm/notyf@3/notyf.min.js"></script>
    <script>
        file_1.onchange = evt => {
            const [file] = file_1.files
            if (file) {
                document.getElementById("preview-image-1").parentElement.href =  URL.createObjectURL(file);
                document.getElementById("preview-image-1").src = URL.createObjectURL(file);
                document.getElementById("lembar_1_kpu").value = null;
            }
        }

        file_2.onchange = evt => {
            const [file] = file_2.files
            if (file) {
                document.getElementById("preview-image-2").parentElement.href =  URL.createObjectURL(file);
                document.getElementById("preview-image-2").src = URL.createObjectURL(file);
                document.getElementById("lembar_2_kpu").value = null;
            }
        }

        file_3.onchange = evt => {
            const [file] = file_3.files
            if (file) {
                document.getElementById("preview-image-3").parentElement.href =  URL.createObjectURL(file);
                document.getElementById("preview-image-3").src = URL.createObjectURL(file);
                document.getElementById("lembar_3_kpu").value = null;
            }
        }


        var notyf = new Notyf({
            types: [{
                type: 'warning',
                background: 'orange',
            }, ]
        });

        function checkSuara() {
            document.getElementById("jumlah_suara_1").value = 0;
            document.getElementById("jumlah_suara_2").value = 0;

            document.getElementById("preview-image-1").src = null;
            document.getElementById("preview-image-2").src = null;
            document.getElementById("preview-image-3").src = null;

            document.getElementById("lembar_1_kpu").value = null;
            document.getElementById("lembar_2_kpu").value = null;
            document.getElementById("lembar_3_kpu").value = null;

            const url = "{{ route('suara.ajax.sudah-diinput') }}?kabupaten_kota_id=" + kabupaten_kota_id.value +
                "&kecamatan_id=" + kecamatan_id.value + "&kelurahan_desa_id=" + kelurahan_desa_id.value + "&tps_id=" +
                tps_id.value;
            fetch(url)
                .then(response => response.json())
                .then(jsonData => {
                    const data = jsonData.data;
                    if (data.id != null) {
                        notyf.open({
                            type: 'warning',
                            message: 'sudah ada suara yang di tps ini'
                        });
                        for (let i = 0; i < data.suara_details.length; i++) {
                            const detail = data.suara_details[i];
                            document.getElementById("jumlah_suara_" + detail.calon_id).value = detail.jumlah_suara;

                        }

                        for (let i = 0; i < data.file_lampirans.length; i++) {
                            const lampiran = data.file_lampirans[i];
                            document.getElementById("preview-image-" + lampiran.nama.replace("lembar-", "")).src =
                                "/suara/file-lampiran/" + lampiran.id;

                        }
                    }
                })
                .catch(error => {
                    console.log(error);
                });
        }

        function checkKpu(e) {
            if(tps_id == undefined || tps_id.options == undefined || tps_id.options.length <= 0){
                alert("Tunggu data TPS selesai dimuat");
                return;
            }
            document.getElementById("label-btn").classList.add("hidden");
            document.getElementById("loading-btn").classList.remove("hidden");
            let url = "{{ route('suara.ajax.check-kpu') }}";
            if (document.getElementById("kabupaten_kota_id") != undefined && document.getElementById("kabupaten_kota_id") !=
                null) {
                url += "?kabupaten_kota_id=" + kabupaten_kota_id.value +
                    "&kecamatan_id=" + kecamatan_id.value + "&kelurahan_desa_id=" + kelurahan_desa_id.value + "&tps_id=" +
                    tps_id.value + "&kecamatan_nama=" + kecamatan_id.options[kecamatan_id.selectedIndex].text +
                    "&kelurahan_desa_nama=" + kelurahan_desa_id.options[kelurahan_desa_id.selectedIndex].text +
                    "&tps_nomor=" +
                    tps_id.options[tps_id.selectedIndex].text;
            } else {
                url +=
                    "?kabupaten_kota_id={{ @$suara->tps->kelurahan_desa->kecamatan->kabupaten_kota_id }}&kecamatan_id={{ @$suara->tps->kelurahan_desa->kecamatan_id }}&kecamatan_nama={{ @$suara->tps->kelurahan_desa->kecamatan->nama }}&kelurahan_desa_nama={{ @$suara->tps->kelurahan_desa->nama }}&tps_nomor={{ @$suara->tps->nomor }}";
            }

            fetch(url)
                .then(response => response.json())
                .then(data => {
                    if (data.mode == "hhcw") {
                        if (data.tungsura != undefined && data.tungsura.tungsura.chart != undefined && data.tungsura.chart[1000054] != undefined) {
                            document.getElementById("jumlah_suara_1").value = data.tungsura.chart[1000054];
                            document.getElementById("jumlah_suara_2").value = data.tungsura.chart[1000055];
                            notyf.success("memuat jumlah suara dari KPU");
                        } else {
                            notyf.open({
                                type: 'warning',
                                message: 'data suara belum diinput KPU'
                            });
                        }

                        if (data.images != undefined && data.images[0] != undefined && data.images[0] != null) {
                            document.getElementById("preview-image-1").src = data.images[0];
                            document.getElementById("preview-image-2").src = data.images[1];
                            document.getElementById("preview-image-3").src = data.images[2];
                            document.getElementById("preview-image-1").parentElement.href = data.images[0];
                            document.getElementById("preview-image-2").parentElement.href = data.images[1];
                            document.getElementById("preview-image-3").parentElement.href = data.images[2];

                            document.getElementById("lembar_1_kpu").value = data.images[0];
                            document.getElementById("lembar_2_kpu").value = data.images[1];
                            document.getElementById("lembar_3_kpu").value = data.images[2];
                            notyf.success("memuat gambar lembar C dari KPU");
                        } else {
                            notyf.open({
                                type: 'warning',
                                message: 'gambar lembar C belum diupload KPU'
                            });
                        }
                        document.getElementById("label-btn").classList.remove("hidden");
                        document.getElementById("loading-btn").classList.add("hidden");
                    } else {
                        notyf.open({
                            type: 'warning',
                            message: 'tidak menemukan data suara'
                        });
                    }
                })
                .catch(error => {
                    notyf.error("gagal memuat data dari kpu");
                    document.getElementById("label-btn").classList.remove("hidden");
                    document.getElementById("loading-btn").classList.add("hidden");
                    console.log(error);
                });
        }
    </script>
@endpush
