<!DOCTYPE html>
<html>

<head>
    <title>
        surat-mandat-saksi_{{ $saksi->tps->nomor }}_{{ $saksi->tps->kelurahan_desa->nama_slug }}_{{ $saksi->tps->kelurahan_desa->kecamatan->nama_slug }}_{{ $saksi->tps->kelurahan_desa->kecamatan->kabupaten_kota->nama_slug }}
    </title>
    {{-- <style>
        {!! Vite::content('resources/css/print.css') !!}
    </style> --}}
    @vite('resources/css/print.css')
</head>

<body class="w-full  mx-auto screen:max-w-4xl print:max-w-full bg-white text-xs" onload="window.print()">

    <div class="page-header relative w-full screen:max-w-4xl print:max-w-full block" style="text-align: center">
        <div class="flex items-center w-full relative overflow-hidden">
            <img src="{{ url('images/kop-mandat-new.png') }}" alt="" class="w-full h-56 object-fill">
        </div>

    </div>

    <table>

        <thead>
            <tr>
                <td>
                    <!--place holder for the fixed-position header-->
                    <div class="page-header-space"></div>
                </td>
            </tr>
        </thead>

        <tbody>
            <tr>
                <td>

                    <div class="w-full screen:px-8 print:px-16">
                        <div class="text-center mb-4">
                            <h1 class="text-lg font-bold">SURAT MANDAT</h1>
                            <p class="text-sm">Nomor: 078 / SURMAN/ PROV / ISRAN -HADI / 2024</p>
                        </div>
                        <p class="mb-4 text-justify indent-8">
                            Melalui surat ini, kami dari <span class="font-bold">Pasangan Calon Gubernur dan Wakil
                                Gubernur
                                Provinsi
                                Kalimantan Timur
                                Nomor Urut 01, Dr. Ir. H. Isran Noor, M.Si dan H.Hadi Mulyadi, S.Si., M.Si.</span>,
                            memberikan
                            mandat kepada:
                        </p>
                        <div class="space-y-2 mb-4">
                            @foreach ($users as $index => $user)
                                <div class="flex">
                                    <h2 class="">{{ $index + 1 }}.</h2>
                                    <div class="pl-4 w-full">
                                        <div class="flex w-full gap-2">
                                            <div class="w-32">Nama</div>
                                            <div>:</div>
                                            <div class="flex-1 border-b-2 border-dotted border-gray-300 w-full">
                                                {{ $user->nama }}
                                            </div>
                                        </div>
                                        <div class="flex w-full gap-2">
                                            <div class="w-32">Nomor KTP</div>
                                            <div>:</div>
                                            <div class="flex-1 border-b-2 border-dotted border-gray-300 w-full">
                                                {{ $user->nik ?? '-' }}
                                            </div>
                                        </div>
                                        <div class="flex w-full gap-2">
                                            <div class="w-32">Nomor KTA</div>
                                            <div>:</div>
                                            <div class="flex-1 border-b-2 border-dotted border-gray-300 w-full"></div>
                                        </div>
                                        <div class="flex w-full gap-2">
                                            <div class="w-32">Nomor HP</div>
                                            <div>:</div>
                                            <div class="flex-1 border-b-2 border-dotted border-gray-300 w-full">
                                                {{ $user->no_wa }}
                                            </div>
                                        </div>
                                        <div class="flex w-full gap-2">
                                            <div class="w-32">Partai</div>
                                            <div>:</div>
                                            <div class="flex-1 border-b-2 border-dotted border-gray-300 w-full">
                                                {{ $user->partai->nama ?? '-' }}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach


                        </div>
                        <div class="mb-4">
                            <p class="text-justify indent-8">
                                Untuk melaksanakan tugas sebagai <span class="font-bold">Saksi TPS dalam Pemungutan dan
                                    Penghitungan Suara Pemilihan
                                    Gubernur dan Wakil Gubernur tahun 2024</span> pada tanggal <span
                                    class="font-bold">27 November 2024</span> dengan hak
                                dan tugasnya
                                sebagaimana
                                tercantum dalam Peraturan KPU Nomor 17 tahun 2024 pada:
                            </p>
                        </div>
                        <div class="space-y-1 mb-4 pl-4">
                            <div class="flex w-full gap-2">
                                <div class="w-32">NO. TPS</div>
                                <div>:</div>
                                <div class="flex-1 border-b-2 border-dotted border-gray-300 w-full">
                                    {{ $saksi->tps->nomor }}
                                </div>
                            </div>
                            <div class="flex w-full gap-2">
                                <div class="w-32">Kelurahan/Desa</div>
                                <div>:</div>
                                <div class="flex-1 border-b-2 border-dotted border-gray-300 w-full">
                                    {{ $saksi->tps->kelurahan_desa->nama }}
                                </div>
                            </div>
                            <div class="flex w-full gap-2">
                                <div class="w-32">Kecamatan</div>
                                <div>:</div>
                                <div class="flex-1 border-b-2 border-dotted border-gray-300 w-full">
                                    {{ $saksi->tps->kelurahan_desa->kecamatan->nama }}
                                </div>
                            </div>
                            <div class="flex w-full gap-2">
                                <div class="w-32">Kabupaten/Kota</div>
                                <div>:</div>
                                <div class="flex-1 border-b-2 border-dotted border-gray-300 w-full">
                                    {{ $saksi->tps->kelurahan_desa->kecamatan->kabupaten_kota->nama }}
                                </div>
                            </div>
                            <div class="flex w-full gap-2">
                                <div class="w-32">Provinsi</div>
                                <div>:</div>
                                <div class="flex-1 border-b-2 border-dotted border-gray-300 w-full">
                                    {{ $saksi->tps->kelurahan_desa->kecamatan->kabupaten_kota->provinsi->nama }}
                                </div>
                            </div>
                        </div>
                        <div class="mb-4">
                            <p class="text-justify indent-8">
                                Saksi TPS dari TIM Pemenangan ISRAN-HADI wajib melaporkan dokumen hasil pemungutan dan
                                perhitungan suara dengan cara :
                            </p>
                        </div>
                        <div class="space-y-2 mb-4 px-6">
                            <div class="flex">
                                <h2 class="mb-2">1.</h2>
                                <div class="pl-4 w-full">
                                    Pukul 14.00 – 15.00 memfoto <span class="font-bold">formulir model C1. Hasil Pleno,
                                        hal 1,2,3</span>, kemudian di upload foto
                                    melalui aplikasi yang sudah disiapkan atau dikirim ke nomor handphone (HP) Bidang
                                    Saksi & Tabulasi
                                    TIM PEMENANGAN ISRAN - HADI
                                </div>
                            </div>
                            <div class="flex">
                                <h2 class="mb-2">2.</h2>
                                <div class="pl-4 w-full">
                                    Pukul 15.00 – selesai menyampaikan C. Hasil Salinan Pemilihan Gubernur & Wakil
                                    Gubernur (fisik C1)
                                    kepada TIM PEMENANGAN ISRAN -HADI Tingkat Kabupaten/Kota melalui Koor. Saksi.

                                </div>
                            </div>


                        </div>
                        <div class="mb-4">
                            <p class="text-justify indent-8">
                                Surat Mandat ini berlaku sejak tanggal ditetapkan dan akan berakhir dengan sendirinya
                                setelah
                                seluruh
                                kegiatan proses Pemungutan dan Perhitungan Suara Pilkada tahun 2024 selesai, dan apabila
                                di
                                kemudian
                                hari
                                terdapat kekeliruan dalam surat mandat ini, akan dilakukan perbaikan sebagaimana
                                mestinya.
                            </p>
                        </div>
                        <div class="mb-4">
                            <div class="flex flex-col items-end mb-8">
                                <div>
                                    <div class="flex gap-4  text-left">
                                        <div class="w-32">
                                            Ditetapkan di
                                        </div>
                                        <div>
                                            :
                                        </div>
                                        <div>
                                            Samarinda
                                        </div>
                                    </div>
                                    <div class="flex gap-4 text-left">
                                        <div class="w-32">
                                            Pada tanggal
                                        </div>
                                        <div>
                                            :
                                        </div>
                                        <div>
                                            24 November 2024
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="flex flex-col justify-center items-center mb-4 w-full font-bold">
                                <p>
                                    Pasangan Calon Gubernur dan Wakil Gubernur

                                </p>
                                <p> Provinsi Kalimantan Timur 2024 -2029</p>
                            </div>

                            <div class="flex justify-between mt-4">
                                <div class="w-1/2 text-center relative">
                                    <img src="{{ url('images/Ttd IN.png') }}" alt=""
                                        class="absolute bottom-0 right-0 left-0 mx-auto block">
                                    <p class="font-bold mb-20">Calon Gubernur</p>
                                    <p class="font-bold underline underline-offset-4">Dr. Ir.H. ISRAN NOOR, M.Si</p>
                                </div>
                                <div class="w-1/2 text-center relative">
                                    <img src="{{ url('images/ttd HM.png') }}" alt=""
                                        class="absolute -bottom-8 right-0 left-0 mx-auto block">
                                    <p class="font-bold mb-20">Calon Wakil Gubernur</p>
                                    <p class="font-bold underline underline-offset-4">H.HADI MULYADI, S.Si., M.Si</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </td>
            </tr>
        </tbody>

    </table>

</body>

</html>
