@extends('layouts.app')

@section('content')
    <div class="mx-auto max-w-screen-2xl p-4 md:p-6 2xl:p-10">
        <!-- Breadcrumb Start -->
        <div class="mb-6 flex flex-col gap-3 sm:flex-row sm:items-center sm:justify-between">
            <a href="/saksi"
                class="inline-flex items-center justify-center rounded-md bg-warning px-5 py-2 text-center font-medium text-white hover:bg-opacity-90 lg:px-8 xl:px-10">
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                    <g fill="none">
                        <path
                            d="M24 0v24H0V0zM12.593 23.258l-.011.002l-.071.035l-.02.004l-.014-.004l-.071-.035q-.016-.005-.024.005l-.004.01l-.017.428l.005.02l.01.013l.104.074l.015.004l.012-.004l.104-.074l.012-.016l.004-.017l-.017-.427q-.004-.016-.017-.018m.265-.113l-.013.002l-.185.093l-.01.01l-.003.011l.018.43l.005.012l.008.007l.201.093q.019.005.029-.008l.004-.014l-.034-.614q-.005-.019-.02-.022m-.715.002a.02.02 0 0 0-.027.006l-.006.014l-.034.614q.001.018.017.024l.015-.002l.201-.093l.01-.008l.004-.011l.017-.43l-.003-.012l-.01-.01z" />
                        <path fill="currentColor"
                            d="M3.283 10.94a1.5 1.5 0 0 0 0 2.12l5.656 5.658a1.5 1.5 0 1 0 2.122-2.122L7.965 13.5H19.5a1.5 1.5 0 0 0 0-3H7.965l3.096-3.096a1.5 1.5 0 1 0-2.122-2.121z" />
                    </g>
                </svg>
            </a>


            <nav>
                <ol class="flex items-center gap-2">
                    <li>
                        <a class="font-medium" href="/">Dashboard /</a>
                    </li>
                    <li class="font-medium text-primary">Import Saksi</li>
                </ol>
            </nav>
        </div>
        <!-- Breadcrumb End -->

        <div class="rounded-sm border border-stroke bg-white shadow-default dark:border-strokedark dark:bg-boxdark p-6">
            <div
              class="border-b border-stroke px-7.5 py-4 dark:border-strokedark"
            >
              <h3 class="font-medium text-black dark:text-white">
                Hasil Import
              </h3>
              <p class="text-red-500">Pastikan mencatat data-data yang gagal/error import untuk segera diperbaiki</p>
            </div>
            <div x-data="{
                openTab: 1,
                activeClasses: 'text-primary border-primary',
                inactiveClasses: 'border-transparent',
            }" class="mb-14 w-full p-7.5">
                <div class="mb-6 flex flex-wrap gap-5 border-b border-stroke dark:border-strokedark sm:gap-10">
                    <a href="#" @click.prevent="openTab = 1"
                        :class="openTab === 1 ? activeClasses : inactiveClasses"
                        class="border-b-2 py-4 text-sm font-medium hover:text-primary md:text-base">
                        Gagal @if (count($import_errors) > 0) <small class="bg-red-500 p-1 rounded-lg text-white">{{count($import_errors)}}</small> @endif
                    </a>
                    <a href="#" @click.prevent="openTab = 2"
                        :class="openTab === 2 ? activeClasses : inactiveClasses"
                        class="border-b-2 py-4 text-sm font-medium hover:text-primary md:text-base">
                        Berhasil @if (count($users) > 0) <small class="bg-green-500 p-1 rounded-lg text-white">{{count($users)}}</small> @endif 
                    </a>
                   
                </div>
                <div>
                    <div x-show="openTab === 1" class="font-medium leading-relaxed">
                        <table class="w-full table-auto">
                            <thead>
                                <tr class="bg-gray-2 text-left dark:bg-meta-4">
                                    <th class="min-w-[150px] px-4 py-4 font-medium text-black dark:text-white">
                                        Error
                                    </th>
                                  
                                   
                                </tr>
                            </thead>
                            <tbody>
                                @forelse ($import_errors as $error)
                                    <tr >
                                      
                                        <td class="border-b border-[#eee] px-4 py-5  dark:border-strokedark ">
                                            <p class="font-medium text-black dark:text-white">
                                                {{ $error }}
                                            </p>
                                        </td>
                                       
                                       
                                       
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="2" class="text-center py-4 dark:text-white">
                                            Tidak ada error
                                        </td>
                                    </tr>
                                @endforelse
    
                            </tbody>
    
                        </table>
                    </div>
                    <div x-show="openTab === 2" class="font-medium leading-relaxed" style="display: none">
                        <table class="w-full table-auto">
                            <thead>
                                <tr class="bg-gray-2 text-left dark:bg-meta-4">

                                    <th class="min-w-[150px] px-4 py-4 font-medium text-black dark:text-white">
                                        NIK
                                    </th>
                                    <th class="min-w-[150px] px-4 py-4 font-medium text-black dark:text-white">
                                        NAMA
                                    </th>
                                    <th class="min-w-[150px] px-4 py-4 font-medium text-black dark:text-white">
                                        NO WA
                                    </th>
                                    
                                   
                                </tr>
                            </thead>
                            <tbody>
                                @forelse ($users as $user)
                                    <tr >

                                        <td class="border-b border-[#eee] px-4 py-5  dark:border-strokedark ">
                                            <p class="font-medium text-black dark:text-white">
                                                {{ $user['nik'] }}
                                            </p>
                                        </td>
                                        <td class="border-b border-[#eee] px-4 py-5  dark:border-strokedark ">
                                            <p class="font-medium text-black dark:text-white">
                                                {{ $user['nama'] }}
                                            </p>
                                        </td>
                                        <td class="border-b border-[#eee] px-4 py-5  dark:border-strokedark ">
                                            <p class="font-medium text-black dark:text-white">
                                                {{ $user['no_wa'] }}
                                            </p>
                                        </td>
                                       
                                       
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="3" class="text-center py-4 dark:text-white">
                                            Tidak ada data yang berhasil diimport
                                        </td>
                                    </tr>
                                @endforelse
    
                            </tbody>
    
                        </table>
                        
                    </div>
                    
                </div>
            </div>
            
        </div>


    </div>
@endsection
