@extends('layouts.app')

@section('content')
<div class="mx-auto max-w-screen-2xl p-4 md:p-6 2xl:p-10">
    <div class="mx-auto max-w-270">
      <!-- Breadcrumb Start -->
      <div
        class="mb-6 flex flex-col gap-3 sm:flex-row sm:items-center sm:justify-between"
      >
        <h2 class="text-title-md2 font-bold text-black dark:text-white">
          Account Setting
        </h2>

        <nav>
          <ol class="flex items-center gap-2">
            <li>
              <a class="font-medium" href="/">Dashboard /</a>
            </li>
            <li class="font-medium text-primary">Settings</li>
          </ol>
        </nav>
      </div>
      <!-- Breadcrumb End -->

      <!-- ====== Settings Section Start -->
      <div class="grid grid-cols-5 gap-8">
        <div class="col-span-5 xl:col-span-3">
          <div
            class="rounded-sm border border-stroke bg-white shadow-default dark:border-strokedark dark:bg-boxdark"
          >
            <div
              class="border-b border-stroke px-7 py-4 dark:border-strokedark"
            >
              <h3 class="font-medium text-black dark:text-white">
                Personal Information
              </h3>
            </div>
            <div class="p-7">
              <form action="{{route('setting.profile.update')}}" method="POST">
                @csrf
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6" >
                    <div>
                        <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                            Nama User <small class="text-red-500">*</small>
                        </label>
                        <input required type="text" name="nama" placeholder="Nama..." value="{{ old('nama', @$data->nama) }}"
                            class="w-full rounded-lg border-[1.5px] border-stroke bg-transparent px-4 py-2 font-normal text-black outline-none transition focus:border-primary active:border-primary disabled:cursor-default disabled:bg-whiter dark:border-form-strokedark dark:bg-form-input dark:text-white dark:focus:border-primary" />
                        @error('nama')
                            <span class="text-red-500 text-sm">{{ $message }}</span>
                        @enderror
                    </div>
                    {{-- <div>
                        <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                            No Telp <small class="text-red-500">*</small>
                        </label>
                        <input type="number" maxlength="20" required name="no_telp" placeholder="08..."
                            value="{{ old('no_telp', @$data->no_telp) }}"
                            class="w-full rounded-lg border-[1.5px] border-stroke bg-transparent px-4 py-2 font-normal text-black outline-none transition focus:border-primary active:border-primary disabled:cursor-default disabled:bg-whiter dark:border-form-strokedark dark:bg-form-input dark:text-white dark:focus:border-primary" />
                        @error('no_telp')
                            <span class="text-red-500 text-sm">{{ $message }}</span>
                        @enderror
                    </div> --}}
            
                    <div>
                        <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                            No Wa
                        </label>
                        <input type="number" maxlength="20" minlength="10" name="no_wa" placeholder="08..."
                            value="{{ old('no_wa', @$data->no_wa) }}"
                            class="w-full rounded-lg border-[1.5px] border-stroke bg-transparent px-4 py-2 font-normal text-black outline-none transition focus:border-primary active:border-primary disabled:cursor-default disabled:bg-whiter dark:border-form-strokedark dark:bg-form-input dark:text-white dark:focus:border-primary" />
                        @error('no_wa')
                            <span class="text-red-500 text-sm">{{ $message }}</span>
                        @enderror
                    </div>
                    <div>
                        <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                            Email
                        </label>
                        <input type="email" name="email" placeholder="Email..." value="{{ old('email', @$data->email) }}"
                            class="w-full rounded-lg border-[1.5px] border-stroke bg-transparent px-4 py-2 font-normal text-black outline-none transition focus:border-primary active:border-primary disabled:cursor-default disabled:bg-whiter dark:border-form-strokedark dark:bg-form-input dark:text-white dark:focus:border-primary" />
                        @error('email')
                            <span class="text-red-500 text-sm">{{ $message }}</span>
                        @enderror
                    </div>
                    
            
                    <button type="submit"
                        class="inline-flex items-center justify-center rounded-md bg-primary px-10 py-4 text-center font-medium text-white hover:bg-opacity-90 lg:px-8 xl:px-10 mt-6">Simpan</button>
                </div>
              </form>
            </div>
          </div>
        </div>
        {{-- <div class="col-span-5 xl:col-span-2">
          <div
            class="rounded-sm border border-stroke bg-white shadow-default dark:border-strokedark dark:bg-boxdark"
          >
            <div
              class="border-b border-stroke px-7 py-4 dark:border-strokedark"
            >
              <h3 class="font-medium text-black dark:text-white">
                Password
              </h3>
            </div>
            <div class="p-7">
              <form action="#">
                <div class="mb-4 flex items-center gap-3">
                    <a
                    href="{{route('setting.new-password')}}"
                    class="flex justify-center w-full rounded bg-danger px-6 py-2 font-medium text-gray hover:bg-opacity-90"
                    type="submit"
                  >
                    Change Password
                </a>
                </div>
              </form>
            </div>
          </div>
        </div> --}}
      </div>
      <!-- ====== Settings Section End -->
    </div>
  </div>
@endsection