@extends('layouts.app')

@section('content')
<div class="mx-auto max-w-screen-2xl p-4 md:p-6 2xl:p-10">
    <div class="mx-auto max-w-270">
      <!-- Breadcrumb Start -->
      <div
        class="mb-6 flex flex-col gap-3 sm:flex-row sm:items-center sm:justify-between"
      >
        <h2 class="text-title-md2 font-bold text-black dark:text-white">
          Account Settings
        </h2>

        <nav>
          <ol class="flex items-center gap-2">
            <li>
              <a class="font-medium" href="/">Dashboard /</a>
            </li>
            <li class="font-medium text-primary">Settings</li>
          </ol>
        </nav>
      </div>
      <!-- Breadcrumb End -->

      <!-- ====== Settings Section Start -->
      <div class="w-ull">
        <div
          class="rounded-sm border border-stroke bg-white shadow-default dark:border-strokedark dark:bg-boxdark"
        >
          <div
            class="border-b border-stroke px-7 py-4 dark:border-strokedark"
          >
            <h3 class="font-medium text-black dark:text-white">
              Change Password
            </h3>
          </div>
          <div class="p-7">
            <form action="{{route('setting.new-password.update')}}" method="POST">
              @csrf
              <div class="mb-6">
                  <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                      Password Lama <small class="text-red-500">*</small>
                  </label>
                  <input required type="password" name="password_lama" placeholder="Password..." value=""
                      class="w-full rounded-lg border-[1.5px] border-stroke bg-transparent px-4 py-2 font-normal text-black outline-none transition focus:border-primary active:border-primary disabled:cursor-default disabled:bg-whiter dark:border-form-strokedark dark:bg-form-input dark:text-white dark:focus:border-primary" />
                  @error('password_lama')
                      <span class="text-red-500 text-sm">{{ $message }}</span>
                  @enderror
              </div>

              <div class="mb-6">
                  <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                      Password Baru  <small class="text-red-500">*</small>
                  </label>
                  <input type="password" required name="password_baru" placeholder="Password..." value=""
                      class="w-full rounded-lg border-[1.5px] border-stroke bg-transparent px-4 py-2 font-normal text-black outline-none transition focus:border-primary active:border-primary disabled:cursor-default disabled:bg-whiter dark:border-form-strokedark dark:bg-form-input dark:text-white dark:focus:border-primary" />
                  @error('password_baru')
                      <span class="text-red-500 text-sm">{{ $message }}</span>
                  @enderror
              </div>

              <div class="flex justify-end gap-4.5">
                <button
                  class="flex justify-center rounded border border-stroke px-6 py-2 font-medium text-black hover:shadow-1 dark:border-strokedark dark:text-white"
                  type="submit"
                >
                  Cancel
                </button>
                <button
                  class="flex justify-center rounded bg-primary px-6 py-2 font-medium text-gray hover:bg-opacity-90"
                  type="submit"
                >
                  Save
                </button>
              </div>
            </form>
          </div>
        </div>
      </div>
      <!-- ====== Settings Section End -->
    </div>
  </div>
@endsection