@extends('layouts.app')

@section('content')
    <div class="mx-auto max-w-screen-2xl p-4 md:p-6 2xl:p-10">
        <div
            class="rounded-sm border border-stroke bg-white px-5 pb-2.5 pt-6 shadow-default dark:border-strokedark dark:bg-boxdark sm:px-7.5 xl:pb-1">
            <h4 class="mb-6 text-xl font-bold text-black dark:text-white">
                Pengumuman : {{$pengumuman->user_saksi->nama ?? $pengumuman->kelurahan_desa->nama?? $pengumuman->kecamatan->nama?? $pengumuman->kabupaten_kota->nama??$_SERVER['SERVER_NAME']}}
            </h4>

            <div class="flex flex-col">



                <div class="space-y-4 mb-4">
                    <hr>
                    <p>
                        Judul : {{ $pengumuman->judul }}
                    </p>
                    <hr>
                    <p>
                        Isi : {{ $pengumuman->isi }}
                    </p>
                    
                   
                </div>

                <div class="space-y-4 mb-4">
                    <span >Respon Jawaban : </span>
                    <ul class="list-disc">
                        @foreach ($pengumuman->pengumuman_jawabs as $index => $jawab)
                            <li>
                                {{@$jawab->user->nama}} : {{$jawab->iya ? "Iya" : "Tidak"}}
                            </li>
                        @endforeach
                    </ul>
                </div>
                

            </div>
        </div>


    </div>
@endsection
