@push('scripts')
    <script>
        var userSaksiChoice;
        var valueUserSaksiId = '{{ old('user_saksi_id', @$data->user_saksi_id) }}';
        function ajaxUserSaksi() {
            if(!document.getElementById('user_saksi_id')){
                return;
            }
            document.getElementById('user_saksi_id').value = '';
            document.getElementById('loading-user-saksi').innerHTML = 'Loading...';
            const kelurahanDesaId = document.getElementById('kelurahan_desa_id').value != "" ? document.getElementById(
                'kelurahan_desa_id').value : valueKelurahanDesaId;
            userSaksiChoice.clearStore();
            fetch(`/ajax/user-saksi?kelurahan_desa_id=${kelurahanDesaId}`)
                .then(response => response.json())
                .then(data => {
                    document.getElementById('loading-user-saksi').innerHTML = '.';
                    if (document.getElementById('user_saksi_id').getAttribute('data-pilih-semua')) {
                        data.unshift({
                            id: "",
                            nama: "Semua Saksi"

                        });
                    } else if (!document.getElementById('user_saksi_id').getAttribute('required')) {
                        data.unshift({
                            id: "",
                            nama: "Tidak Ada"

                        });
                    }
                    userSaksiChoice.setChoices(data, 'id', 'nama', false);
                    if(valueUserSaksiId == "" && document.getElementById('tps_id').getAttribute('required')){
                        valueUserSaksiId = data[0].id ?? "";
                    }
                    if (valueUserSaksiId && valueUserSaksiId != '') {
                        userSaksiChoice.setChoiceByValue(parseInt(valueUserSaksiId));
                        ajaxDpt();
                    }
                })
                .catch(error => {
                    console.log(error);
                    document.getElementById('loading-tps').innerHTML = 'Error';
                });
        }

        if (document.getElementById('user_saksi_id')) {
            document.getElementById('kelurahan_desa_id').addEventListener('change', function() {
                valueKelurahanDesaId = this.value;
                ajaxUserSaksi();
            });
            userSaksiChoice = new Choices('#user_saksi_id', {
                placeholderValue: 'Pilih...',
                removeItems: !document.getElementById('user_saksi_id').getAttribute('required'),
                removeItemButton: !document.getElementById('user_saksi_id').getAttribute('required'),
                shouldSort: false,
                shouldSortItems: false,
                itemSelectText:"",
            });

            // document.getElementById('user_saksi_id').addEventListener('change', function() {
            //     valueUserSaksiId = this.value;
            //     ajaxUserSaksi();
            // });

        }
    </script>
@endpush
<div class="grid grid-cols-1 md:grid-cols-2">
    <div class="flex flex-col gap-5.5 p-6.5">
        <div>
            <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                Provinsi <small class="text-red-500">*</small>
            </label>
            <select name="provinsi_id" id="provinsi_id"
                required
                class="relative z-20 w-full appearance-none rounded border border-stroke bg-transparent py-3 pl-5 pr-12 outline-none transition focus:border-primary active:border-primary dark:border-form-strokedark dark:bg-form-input">
                <option value="">Pilih Provinsi</option>
                @foreach ($provinsis as $provinsi)
                    <option value="{{ $provinsi->id }}" @if (old('provinsi_id', @$data->provinsi_id) == $provinsi->id) selected @endif>
                        {{ $provinsi->nama }}
                    </option>
                @endforeach
            </select>
            @error('provinsi_id')
                <span class="text-red-500 text-sm">{{ $message }}</span>
            @enderror
        </div>
    
        <div>
            <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                Kabupaten/Kota <small id="loading-kabupaten-kota"></small>
            </label>
            <select name="kabupaten_kota_id" id="kabupaten_kota_id"
                class="relative z-20 w-full js-choice appearance-none rounded border border-stroke bg-transparent py-3 pl-5 pr-12 outline-none transition focus:border-primary active:border-primary dark:border-form-strokedark dark:bg-form-input">
        
            </select>
            @error('kabupaten_kota_id')
                <span class="text-red-500 text-sm">{{ $message }}</span>
            @enderror
        </div>
        
        <div>
            <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                Kecamatan <small id="loading-kecamatan"></small>
            </label>
            <select name="kecamatan_id" id="kecamatan_id"
                class="relative z-20 w-full appearance-none rounded border border-stroke bg-transparent py-3 pl-5 pr-12 outline-none transition focus:border-primary active:border-primary dark:border-form-strokedark dark:bg-form-input">
        
            </select>
            @error('kecamatan_id')
                <span class="text-red-500 text-sm">{{ $message }}</span>
            @enderror
        </div>
        
        <div>
            <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                Kelurahan/Desa <small id="loading-kelurahan-desa"></small>
            </label>
            <select name="kelurahan_desa_id" id="kelurahan_desa_id"
                class="relative z-20 w-full appearance-none rounded border border-stroke bg-transparent py-3 pl-5 pr-12 outline-none transition focus:border-primary active:border-primary dark:border-form-strokedark dark:bg-form-input">
        
            </select>
            @error('kelurahan_desa_id')
                <span class="text-red-500 text-sm">{{ $message }}</span>
            @enderror
        </div>

        <div>
            <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                Saksi <small id="loading-user-saksi"></small>
            </label>
            <select name="user_saksi_id" id="user_saksi_id"
                class="relative z-20 w-full appearance-none rounded border border-stroke bg-transparent py-3 pl-5 pr-12 outline-none transition focus:border-primary active:border-primary dark:border-form-strokedark dark:bg-form-input">
        
            </select>
            @error('user_saksi_id')
                <span class="text-red-500 text-sm">{{ $message }}</span>
            @enderror
        </div>
        <div>
            <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                Partai
            </label>
            <select name="partai_id" id="partai_id"
                class="relative z-20 w-full appearance-none rounded border border-stroke bg-transparent py-3 pl-5 pr-12 outline-none transition focus:border-primary active:border-primary dark:border-form-strokedark dark:bg-form-input">
                <option value="">Tidak Ada Partai</option>
                @foreach ($partais as $partai)
                    <option value="{{ $partai->id }}" @if (old('partai_id', @$data->partai_id) == $partai->id) selected @endif>
                        {{ $partai->nama }}
                    </option>
                @endforeach
            </select>
            @error('partai_id')
                <span class="text-red-500 text-sm">{{ $message }}</span>
            @enderror
        </div>
    </div>
    
    <div class="flex flex-col gap-5.5 p-6.5">
        <div>
            <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                Judul <small class="text-red-500">*</small>
            </label>
            <input type="text" name="judul" placeholder="Judul..." value="{{ old('judul', @$data->judul) }}" required
                class="w-full rounded-lg border-[1.5px] border-stroke bg-transparent px-4 py-2 font-normal text-black outline-none transition focus:border-primary active:border-primary disabled:cursor-default disabled:bg-whiter dark:border-form-strokedark dark:bg-form-input dark:text-white dark:focus:border-primary" />
            @error('judul')
                <span class="text-red-500 text-sm">{{ $message }}</span>
            @enderror
        </div>
    
        <div>
            <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                Isi <small class="text-red-500">*</small>
            </label>
            <textarea rows="6" name="isi" placeholder="Isi pengumuman..." required
                class="w-full rounded-lg border-[1.5px] border-stroke bg-transparent px-5 py-3 font-normal text-black outline-none transition focus:border-primary active:border-primary disabled:cursor-default disabled:bg-whiter dark:border-form-strokedark dark:bg-form-input dark:text-white dark:focus:border-primary">{{@$data->isi}}</textarea>
            @error('isi')
                <span class="text-red-500 text-sm">{{ $message }}</span>
            @enderror
        </div>
    
        <div>
            <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                Pertanyaan?
            </label>
            <div x-data="{ switcherToggle: {{@$data->pertanyaan ? 'true' : 'false'}} }">
                <label for="toggle1" class="flex cursor-pointer select-none items-center">
                    <div class="relative">
                        <input type="checkbox" @checked(@$data->pertanyaan ?? false) name="pertanyaan" id="toggle1" class="sr-only" @change="switcherToggle = !switcherToggle" />
                        <div class="block h-8 w-14 rounded-full bg-meta-9 dark:bg-[#5A616B]"></div>
                        <div :class="switcherToggle && '!right-1 !translate-x-full !bg-primary dark:!bg-white'"
                            class="absolute left-1 top-1 h-6 w-6 rounded-full bg-white transition"></div>
                    </div>
                </label>
            </div>
        </div>
        <div>
            <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                Aktif? (jika tidak aktif tidak akan muncul di aplikasi mobile)
            </label>
            <div x-data="{ switcherToggle: {{@$data->aktif ? 'true' : 'false'}} }">
                <label for="toggle2" class="flex cursor-pointer select-none items-center">
                    <div class="relative">
                        <input type="checkbox" @checked(@$data->aktif ?? false) name="aktif" id="toggle2" class="sr-only" @change="switcherToggle = !switcherToggle" />
                        <div class="block h-8 w-14 rounded-full bg-meta-9 dark:bg-[#5A616B]"></div>
                        <div :class="switcherToggle && '!right-1 !translate-x-full !bg-primary dark:!bg-white'"
                            class="absolute left-1 top-1 h-6 w-6 rounded-full bg-white transition"></div>
                    </div>
                </label>
            </div>
        </div>
    
        <button type="submit"
            class="inline-flex items-center justify-center rounded-md bg-primary px-10 py-4 text-center font-medium text-white hover:bg-opacity-90 lg:px-8 xl:px-10">Simpan</button>
    </div>
    
</div>