@extends('layouts.app')

@section('content')
    <div class="mx-auto max-w-screen-2xl p-4 md:p-6 2xl:p-10">

        <div class="rounded-sm border border-stroke bg-white shadow-default dark:border-strokedark dark:bg-boxdark p-6">
            <div class="border-b border-stroke px-7.5 py-4 dark:border-strokedark">
                <h3 class="font-medium text-black dark:text-white">
                    Pelatihan
                </h3>

            </div>
            <div x-data="{
                openTab: 1,
                activeClasses: 'text-primary border-primary',
                inactiveClasses: 'border-transparent',
            }" class="mb-14 w-full p-7.5">
                <div class="mb-6 flex flex-wrap gap-5 border-b border-stroke dark:border-strokedark sm:gap-10">
                    <a href="#" @click.prevent="openTab = 1" :class="openTab === 1 ? activeClasses : inactiveClasses" id="tab-1"
                        class="border-b-2 py-4 text-sm font-medium hover:text-primary md:text-base">
                        Pelatih Saksi
                    </a>
                    <a href="#" @click.prevent="openTab = 2" id="tab-2"
                        :class="openTab === 2 ? activeClasses : inactiveClasses"
                        class="border-b-2 py-4 text-sm font-medium hover:text-primary md:text-base">
                        Laporan Pelatihan
                    </a>

                </div>
                <div>
                    <div x-show="openTab === 1" class="font-medium leading-relaxed">
                        <div class="flex flex-col">
                            <div class="mb-4  flex gap-2 flex-col md:flex-row md:flex-row w-full justify-between">
                                <div class="flex gap-2">

                                </div>
                                <div class="flex gap-2 flex-col md:flex-row">
                                    <a href="{{ route('pelatih.import-view') }}"
                                        class="flex items-center justify-center gap-2 py-2 px-4 rounded-lg bg-success text-white font-medium text-sm hover:bg-primaryhover transition duration-200">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18"
                                            viewBox="0 0 24 24">
                                            <path fill="currentColor"
                                                d="M4 3h14a2 2 0 0 1 2 2v7.08a6 6 0 0 0-4.32.92H12v4h1.08c-.11.68-.11 1.35 0 2H4a2 2 0 0 1-2-2V5c0-1.1.9-2 2-2m0 4v4h6V7zm8 0v4h6V7zm-8 6v4h6v-4zm14.44 2v2h4v2h-4v2l-3-3z" />
                                        </svg> Import Pelatih
                                    </a>
                                    <a href="{{ route('pelatih.create') }}"
                                        class="flex items-center justify-center gap-2 py-2 px-4 rounded-lg bg-primary text-white font-medium text-sm hover:bg-primaryhover transition duration-200">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18"
                                            viewBox="0 0 24 24">
                                            <path fill="currentColor"
                                                d="M12 20c-4.41 0-8-3.59-8-8s3.59-8 8-8s8 3.59 8 8s-3.59 8-8 8m0-18A10 10 0 0 0 2 12a10 10 0 0 0 10 10a10 10 0 0 0 10-10A10 10 0 0 0 12 2m1 5h-2v4H7v2h4v4h2v-4h4v-2h-4z" />
                                        </svg> Tambah Pelatih
                                    </a>
                                </div>

                            </div>

                            <!-- Table -->
                            <div>
                                {{ $pelatihsDataTable->table() }}
                            </div>

                        </div>
                    </div>
                    <div x-show="openTab === 2" class="font-medium leading-relaxed" style="display: none">
                        <div class="flex flex-col">
                            <div class="mb-4  flex gap-2 flex-col md:flex-row md:flex-row w-full justify-between">
                                <div class="flex gap-2">

                                </div>
                                <div class="flex gap-2 flex-col md:flex-row">
                                    <a href="{{ route('laporan-pelatihan.create') }}"
                                        class="flex items-center justify-center gap-2 py-2 px-4 rounded-lg bg-primary text-white font-medium text-sm hover:bg-primaryhover transition duration-200">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18"
                                            viewBox="0 0 24 24">
                                            <path fill="currentColor"
                                                d="M12 20c-4.41 0-8-3.59-8-8s3.59-8 8-8s8 3.59 8 8s-3.59 8-8 8m0-18A10 10 0 0 0 2 12a10 10 0 0 0 10 10a10 10 0 0 0 10-10A10 10 0 0 0 12 2m1 5h-2v4H7v2h4v4h2v-4h4v-2h-4z" />
                                        </svg> Tambah Laporan
                                    </a>
                                </div>

                            </div>

                            <!-- Table -->
                            <div>
                                {{ $laporanPelatihansDataTable->table() }}
                            </div>

                        </div>
                    </div>

                </div>
            </div>

        </div>



    </div>
@endsection


@push('styles')
    <link rel="stylesheet" href="https://cdn.datatables.net/2.1.8/css/dataTables.dataTables.css" />
    <link rel="stylesheet" href="https://cdn.datatables.net/2.1.8/css/dataTables.tailwindcss.css">
@endpush

@push('scripts')
    <script src="https://cdn.datatables.net/2.1.8/js/dataTables.js"></script>
    {{ $pelatihsDataTable->scripts() }}
    {{ $laporanPelatihansDataTable->scripts() }}

    <script>
        document.getElementById('tab-1').addEventListener('click', function() {
            setInterval(() => {
                window.LaravelDataTables['pelatihs-table'].columns.adjust().responsive;
            }, 100);
        });
        document.getElementById('tab-2').addEventListener('click', function() {
            setInterval(() => {
                window.LaravelDataTables['laporanpelatihans-table'].columns.adjust().responsive;
            }, 100);
        });
    </script>
@endpush
