

<div class="grid grid-cols-1 md:grid-cols-2" x-data="{ role: '{{ old('role', @$data->role ?? 'admin') }}' }">
    <div class="flex flex-col gap-5.5 p-6.5">

        <div>
            <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                Provinsi <small class="text-red-500">*</small>
            </label>
            <select name="provinsi_id" id="provinsi_id"
                required
                class="relative z-20 w-full appearance-none rounded border border-stroke bg-transparent py-3 pl-5 pr-12 outline-none transition focus:border-primary active:border-primary dark:border-form-strokedark dark:bg-form-input">
                <option value="">Pilih Provinsi</option>
                @foreach ($provinsis as $provinsi)
                    <option value="{{ $provinsi->id }}" @if (old('provinsi_id', @$data->provinsi_id) == $provinsi->id) selected @endif>
                        {{ $provinsi->nama }}
                    </option>
                @endforeach
            </select>
            @error('provinsi_id')
                <span class="text-red-500 text-sm">{{ $message }}</span>
            @enderror
        </div>

        <div>
            <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                Kabupaten/Kota <small class="text-red-500">*</small> <small id="loading-kabupaten-kota"></small>
            </label>
            <select name="kabupaten_kota_id" id="kabupaten_kota_id" required
                class="relative z-20 w-full js-choice appearance-none rounded border border-stroke bg-transparent py-3 pl-5 pr-12 outline-none transition focus:border-primary active:border-primary dark:border-form-strokedark dark:bg-form-input">

            </select>
            @error('kabupaten_kota_id')
                <span class="text-red-500 text-sm">{{ $message }}</span>
            @enderror
        </div>

        <div>
            <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                Kecamatan <small id="loading-kecamatan"></small>
            </label>
            <select name="kecamatan_id" id="kecamatan_id"
                class="relative z-20 w-full appearance-none rounded border border-stroke bg-transparent py-3 pl-5 pr-12 outline-none transition focus:border-primary active:border-primary dark:border-form-strokedark dark:bg-form-input">

            </select>
            @error('kecamatan_id')
                <span class="text-red-500 text-sm">{{ $message }}</span>
            @enderror
        </div>

        <div>
            <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                Kelurahan/Desa <small id="loading-kelurahan-desa"></small>
            </label>
            <select name="kelurahan_desa_id" id="kelurahan_desa_id"
                class="relative z-20 w-full appearance-none rounded border border-stroke bg-transparent py-3 pl-5 pr-12 outline-none transition focus:border-primary active:border-primary dark:border-form-strokedark dark:bg-form-input">

            </select>
            @error('kelurahan_desa_id')
                <span class="text-red-500 text-sm">{{ $message }}</span>
            @enderror
        </div>


    </div>

    <div class="flex flex-col gap-5.5 p-6.5">
        <div>
            <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                Nama Pelatih <small class="text-red-500">*</small>
            </label>
            <input required type="text" name="nama" placeholder="Nama..." value="{{ old('nama', @$data->nama) }}"
                class="w-full rounded-lg border-[1.5px] border-stroke bg-transparent px-4 py-2 font-normal text-black outline-none transition focus:border-primary active:border-primary disabled:cursor-default disabled:bg-whiter dark:border-form-strokedark dark:bg-form-input dark:text-white dark:focus:border-primary" />
            @error('nama')
                <span class="text-red-500 text-sm">{{ $message }}</span>
            @enderror
        </div>

        <div>
            <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                No Wa
            </label>
            <input type="number" minlength="10" maxlength="20" name="no_wa" placeholder="08..."
                value="{{ old('no_wa', @$data->no_wa) }}"
                class="w-full rounded-lg border-[1.5px] border-stroke bg-transparent px-4 py-2 font-normal text-black outline-none transition focus:border-primary active:border-primary disabled:cursor-default disabled:bg-whiter dark:border-form-strokedark dark:bg-form-input dark:text-white dark:focus:border-primary" />
            @error('no_wa')
                <span class="text-red-500 text-sm">{{ $message }}</span>
            @enderror
        </div>
        <div>
            <label class="mb-3 block text-sm font-medium text-black dark:text-white">
                Email
            </label>
            <input type="email" name="email" placeholder="Email..." value="{{ old('email', @$data->email) }}"
                class="w-full rounded-lg border-[1.5px] border-stroke bg-transparent px-4 py-2 font-normal text-black outline-none transition focus:border-primary active:border-primary disabled:cursor-default disabled:bg-whiter dark:border-form-strokedark dark:bg-form-input dark:text-white dark:focus:border-primary" />
            @error('email')
                <span class="text-red-500 text-sm">{{ $message }}</span>
            @enderror
        </div>
       

        <button type="submit"
            class="inline-flex items-center justify-center rounded-md bg-primary px-10 py-4 text-center font-medium text-white hover:bg-opacity-90 lg:px-8 xl:px-10 mt-6">Simpan</button>
    </div>
</div>
