<aside :class="sidebarToggle ? 'translate-x-0' : '-translate-x-full'"
    class="absolute left-0 top-0 z-9999 flex font-bold h-screen w-72.5 flex-col overflow-y-hidden bg-redTheme duration-300 ease-linear dark:bg-boxdark lg:static lg:translate-x-0"
    @click.outside="sidebarToggle = false">
    <!-- SIDEBAR HEADER -->
    <div class="flex items-center justify-between gap-2 px-6 py-5.5 lg:py-6.5">
        <a href="/" class="text-2xl text-white font-bold">
            {{-- <img src="./images/logo/logo.svg" alt="Logo" /> --}}
            {{ env('APP_NAME') }}
        </a>

        <button class="block lg:hidden" @click.stop="sidebarToggle = !sidebarToggle">
            <svg class="fill-current" width="20" height="18" viewBox="0 0 20 18" fill="none"
                xmlns="http://www.w3.org/2000/svg">
                <path
                    d="M19 8.175H2.98748L9.36248 1.6875C9.69998 1.35 9.69998 0.825 9.36248 0.4875C9.02498 0.15 8.49998 0.15 8.16248 0.4875L0.399976 8.3625C0.0624756 8.7 0.0624756 9.225 0.399976 9.5625L8.16248 17.4375C8.31248 17.5875 8.53748 17.7 8.76248 17.7C8.98748 17.7 9.17498 17.625 9.36248 17.475C9.69998 17.1375 9.69998 16.6125 9.36248 16.275L3.02498 9.8625H19C19.45 9.8625 19.825 9.4875 19.825 9.0375C19.825 8.55 19.45 8.175 19 8.175Z"
                    fill="" />
            </svg>
        </button>
    </div>
    <!-- SIDEBAR HEADER -->

    <div class="no-scrollbar flex flex-col overflow-y-auto duration-300 ease-linear">
        <!-- Sidebar Menu -->
        <nav class="mt-5 px-4 py-4 lg:mt-9 lg:px-6" x-data="{ selected: '{{ request()->path() }}' }">
            <!-- Menu Group -->
            <div>
                <h3 class="mb-4 ml-4 text-sm font-bold text-white">MENU</h3>

                <ul class="mb-6 flex flex-col gap-1.5">
                    <!-- Menu Item Dashboard -->
                    <li>
                        <a class="group relative flex items-center gap-2.5 rounded-sm px-4 py-2 font-bold text-white duration-300 ease-in-out hover:bg-red-900 dark:hover:bg-meta-4"
                            href="{{ route('dashboard') }}" :class="{ 'active': (page == '/') }">
                            <svg class="fill-current" width="24" height="24" viewBox="0 0 18 18" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <path
                                    d="M6.10322 0.956299H2.53135C1.5751 0.956299 0.787598 1.7438 0.787598 2.70005V6.27192C0.787598 7.22817 1.5751 8.01567 2.53135 8.01567H6.10322C7.05947 8.01567 7.84697 7.22817 7.84697 6.27192V2.72817C7.8751 1.7438 7.0876 0.956299 6.10322 0.956299ZM6.60947 6.30005C6.60947 6.5813 6.38447 6.8063 6.10322 6.8063H2.53135C2.2501 6.8063 2.0251 6.5813 2.0251 6.30005V2.72817C2.0251 2.44692 2.2501 2.22192 2.53135 2.22192H6.10322C6.38447 2.22192 6.60947 2.44692 6.60947 2.72817V6.30005Z"
                                    fill="" />
                                <path
                                    d="M15.4689 0.956299H11.8971C10.9408 0.956299 10.1533 1.7438 10.1533 2.70005V6.27192C10.1533 7.22817 10.9408 8.01567 11.8971 8.01567H15.4689C16.4252 8.01567 17.2127 7.22817 17.2127 6.27192V2.72817C17.2127 1.7438 16.4252 0.956299 15.4689 0.956299ZM15.9752 6.30005C15.9752 6.5813 15.7502 6.8063 15.4689 6.8063H11.8971C11.6158 6.8063 11.3908 6.5813 11.3908 6.30005V2.72817C11.3908 2.44692 11.6158 2.22192 11.8971 2.22192H15.4689C15.7502 2.22192 15.9752 2.44692 15.9752 2.72817V6.30005Z"
                                    fill="" />
                                <path
                                    d="M6.10322 9.92822H2.53135C1.5751 9.92822 0.787598 10.7157 0.787598 11.672V15.2438C0.787598 16.2001 1.5751 16.9876 2.53135 16.9876H6.10322C7.05947 16.9876 7.84697 16.2001 7.84697 15.2438V11.7001C7.8751 10.7157 7.0876 9.92822 6.10322 9.92822ZM6.60947 15.272C6.60947 15.5532 6.38447 15.7782 6.10322 15.7782H2.53135C2.2501 15.7782 2.0251 15.5532 2.0251 15.272V11.7001C2.0251 11.4188 2.2501 11.1938 2.53135 11.1938H6.10322C6.38447 11.1938 6.60947 11.4188 6.60947 11.7001V15.272Z"
                                    fill="" />
                                <path
                                    d="M15.4689 9.92822H11.8971C10.9408 9.92822 10.1533 10.7157 10.1533 11.672V15.2438C10.1533 16.2001 10.9408 16.9876 11.8971 16.9876H15.4689C16.4252 16.9876 17.2127 16.2001 17.2127 15.2438V11.7001C17.2127 10.7157 16.4252 9.92822 15.4689 9.92822ZM15.9752 15.272C15.9752 15.5532 15.7502 15.7782 15.4689 15.7782H11.8971C11.6158 15.7782 11.3908 15.5532 11.3908 15.272V11.7001C11.3908 11.4188 11.6158 11.1938 11.8971 11.1938H15.4689C15.7502 11.1938 15.9752 11.4188 15.9752 11.7001V15.272Z"
                                    fill="" />
                            </svg>

                            Dashboard

                        </a>
                    </li>
                    <!-- Menu Item Dashboard -->


                    <!-- Menu Item master-data -->
                    <li>
                        <a class="@if (request()->is('master-data/*')) active @endif group relative flex items-center gap-2.5 rounded-sm px-4 py-2 font-bold text-white duration-300 ease-in-out hover:bg-red-900 dark:hover:bg-meta-4"
                            href="#"
                            @click.prevent="selected = (selected.includes('master-data') ? '':'master-data')">

                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                                <path fill="currentColor"
                                    d="M4 5c0-.002-.003-.019.035-.081c.043-.07.13-.174.291-.301c.33-.26.87-.539 1.626-.79C7.454 3.326 9.592 3 12 3s4.546.327 6.048.827c.756.252 1.296.53 1.626.79c.162.128.248.232.29.302c.04.063.036.08.036.081c0 .003.003.02-.035.081c-.043.07-.13.174-.291.301c-.33.26-.87.539-1.626.79C16.546 6.674 14.408 7 12 7s-4.546-.327-6.048-.827c-.756-.252-1.296-.53-1.626-.79a1.2 1.2 0 0 1-.29-.302C3.997 5.021 4 5.003 4 5m16 2.527V12l-.003.015a.3.3 0 0 1-.032.066c-.043.07-.13.174-.291.301c-.33.26-.87.539-1.626.79c-1.502.501-3.64.828-6.048.828s-4.546-.327-6.048-.827c-.756-.252-1.296-.53-1.626-.79a1.2 1.2 0 0 1-.29-.302a.3.3 0 0 1-.033-.066L4 12V7.527a9.6 9.6 0 0 0 1.32.543C7.075 8.655 9.437 9 12 9s4.925-.345 6.68-.93A9.5 9.5 0 0 0 20 7.527m0 7V19l-.003.015a.3.3 0 0 1-.032.066c-.043.07-.13.174-.291.301c-.33.26-.87.539-1.626.79c-1.502.501-3.64.828-6.048.828s-4.546-.327-6.048-.827c-.756-.252-1.296-.53-1.626-.79a1.2 1.2 0 0 1-.29-.302a.3.3 0 0 1-.033-.066L4 19v-4.473a9.5 9.5 0 0 0 1.32.543c1.755.585 4.117.93 6.68.93s4.925-.345 6.68-.93a9.5 9.5 0 0 0 1.32-.543M2 19c0 .852.519 1.504 1.088 1.953c.581.458 1.36.826 2.232 1.117c1.755.585 4.117.93 6.68.93s4.925-.345 6.68-.93c.873-.29 1.651-.66 2.232-1.117C21.482 20.504 22 19.852 22 19V5c0-.852-.519-1.504-1.088-1.953c-.581-.458-1.36-.826-2.232-1.117C16.925 1.345 14.563 1 12 1s-4.925.345-6.68.93c-.873.29-1.651.66-2.232 1.117C2.518 3.496 2 4.148 2 5z" />
                            </svg>
                            Master Data

                            <svg class="absolute right-4 top-1/2 -translate-y-1/2 fill-current"
                                :class="{ 'rotate-180': (selected.includes('master-data')) }" width="20"
                                height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd"
                                    d="M4.41107 6.9107C4.73651 6.58527 5.26414 6.58527 5.58958 6.9107L10.0003 11.3214L14.4111 6.91071C14.7365 6.58527 15.2641 6.58527 15.5896 6.91071C15.915 7.23614 15.915 7.76378 15.5896 8.08922L10.5896 13.0892C10.2641 13.4147 9.73651 13.4147 9.41107 13.0892L4.41107 8.08922C4.08563 7.76378 4.08563 7.23614 4.41107 6.9107Z"
                                    fill="" />
                            </svg>
                        </a>

                        <!-- Dropdown Menu Start -->
                        <div class="translate transform overflow-hidden"
                            :class="(selected.includes('master-data')) ? 'block' : 'hidden'">
                            <ul class="mb-5.5 mt-4 flex flex-col gap-2.5 pl-6">
                                <li>
                                    <a class="group relative flex items-center gap-2.5 rounded-md px-4 font-bold text-gray-300 duration-300 ease-in-out hover:text-white"
                                        href="{{ route('master-data.provinsi.index') }}">
                                        Provinsi
                                    </a>
                                </li>
                                <li>
                                    <a class="group relative flex items-center gap-2.5 rounded-md px-4 font-bold text-gray-300 duration-300 ease-in-out hover:text-white"
                                        href="{{ route('master-data.kabupaten-kota.index') }}">
                                        Kabupaten/Kota
                                    </a>
                                </li>
                                <li>
                                    <a class="group relative flex items-center gap-2.5 rounded-md px-4 font-bold text-gray-300 duration-300 ease-in-out hover:text-white"
                                        href="{{ route('master-data.kecamatan.index') }}">
                                        Kecamatan
                                    </a>
                                </li>
                                <li>
                                    <a class="group relative flex items-center gap-2.5 rounded-md px-4 font-bold text-gray-300 duration-300 ease-in-out hover:text-white"
                                        href="{{ route('master-data.kelurahan-desa.index') }}">
                                        Kelurahan/Desa
                                    </a>
                                </li>
                                <!-- <li>
                                    <a class="group relative flex items-center gap-2.5 rounded-md px-4 font-bold text-gray-300 duration-300 ease-in-out hover:text-white"
                                        href="{{ route('master-data.tps.index') }}">
                                        TPS
                                    </a>
                                </li>
                                <li>
                                    <a class="group relative flex items-center gap-2.5 rounded-md px-4 font-bold text-gray-300 duration-300 ease-in-out hover:text-white"
                                        href="{{ route('master-data.calon.index') }}">
                                        Calon
                                    </a>
                                </li>
                                <li>
                                    <a class="group relative flex items-center gap-2.5 rounded-md px-4 font-bold text-gray-300 duration-300 ease-in-out hover:text-white"
                                        href="{{ route('master-data.partai.index') }}">
                                        Partai
                                    </a>
                                </li> -->
                            </ul>
                        </div>
                        <!-- Dropdown Menu End -->
                    </li>

                    <li>
                        <a class="@if (request()->is('user/*') || request()->is('user')) active @endif group relative flex items-center gap-2.5 rounded-sm py-2 px-4 font-bold text-white duration-300 ease-in-out hover:bg-red-900 dark:hover:bg-meta-4"
                            href="{{ route('user.index') }}">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 256 256">
                                <g fill="currentColor">
                                    <path d="M120 104a40 40 0 1 1-40-40a40 40 0 0 1 40 40" opacity="0.2" />
                                    <path
                                        d="M152 80a8 8 0 0 1 8-8h88a8 8 0 0 1 0 16h-88a8 8 0 0 1-8-8m96 40h-88a8 8 0 0 0 0 16h88a8 8 0 0 0 0-16m0 48h-64a8 8 0 0 0 0 16h64a8 8 0 0 0 0-16m-96.25 22a8 8 0 0 1-5.76 9.74a7.6 7.6 0 0 1-2 .26a8 8 0 0 1-7.75-6c-6.16-23.94-30.34-42-56.25-42s-50.09 18.05-56.25 42a8 8 0 0 1-15.5-4c5.59-21.71 21.84-39.29 42.46-48a48 48 0 1 1 58.58 0c20.63 8.71 36.88 26.29 42.47 48M80 136a32 32 0 1 0-32-32a32 32 0 0 0 32 32" />
                                </g>
                            </svg>

                            Pengguna
                        </a>
                    </li>

                    <!-- <li>
                        <a class="@if (request()->is('user-koordinator*')) active @endif  group relative flex items-center gap-2.5 rounded-sm px-4 py-2 font-bold text-white duration-300 ease-in-out hover:bg-red-900 dark:hover:bg-meta-4"
                            href="#"
                            @click.prevent="selected = (selected.includes('user-koordinator') ? '':'user-koordinator')">

                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 256 256">
                                <g fill="currentColor">
                                    <path d="M120 104a40 40 0 1 1-40-40a40 40 0 0 1 40 40" opacity="0.2" />
                                    <path
                                        d="M152 80a8 8 0 0 1 8-8h88a8 8 0 0 1 0 16h-88a8 8 0 0 1-8-8m96 40h-88a8 8 0 0 0 0 16h88a8 8 0 0 0 0-16m0 48h-64a8 8 0 0 0 0 16h64a8 8 0 0 0 0-16m-96.25 22a8 8 0 0 1-5.76 9.74a7.6 7.6 0 0 1-2 .26a8 8 0 0 1-7.75-6c-6.16-23.94-30.34-42-56.25-42s-50.09 18.05-56.25 42a8 8 0 0 1-15.5-4c5.59-21.71 21.84-39.29 42.46-48a48 48 0 1 1 58.58 0c20.63 8.71 36.88 26.29 42.47 48M80 136a32 32 0 1 0-32-32a32 32 0 0 0 32 32" />
                                </g>
                            </svg>
                            Koordinator

                            <svg class="absolute right-4 top-1/2 -translate-y-1/2 fill-current"
                                :class="{ 'rotate-180': (selected.includes('user-koordinator')) }" width="20"
                                height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd"
                                    d="M4.41107 6.9107C4.73651 6.58527 5.26414 6.58527 5.58958 6.9107L10.0003 11.3214L14.4111 6.91071C14.7365 6.58527 15.2641 6.58527 15.5896 6.91071C15.915 7.23614 15.915 7.76378 15.5896 8.08922L10.5896 13.0892C10.2641 13.4147 9.73651 13.4147 9.41107 13.0892L4.41107 8.08922C4.08563 7.76378 4.08563 7.23614 4.41107 6.9107Z"
                                    fill="" />
                            </svg>
                        </a>

                        <div class="translate transform overflow-hidden"
                            :class="(selected.includes('user-koordinator')) ? 'block' : 'hidden'">
                            <ul class="mb-5.5 mt-4 flex flex-col gap-2.5 pl-6">
                                <li>
                                    <a class="group relative flex items-center gap-2.5 rounded-md px-4 font-bold text-gray-300 duration-300 ease-in-out hover:text-white"
                                        href="{{ route('user-koordinator.index') }}?koordinator=kabupaten-kota">
                                        Koordinator Kab/Kota
                                    </a>
                                </li>
                                <li>
                                    <a class="group relative flex items-center gap-2.5 rounded-md px-4 font-bold text-gray-300 duration-300 ease-in-out hover:text-white"
                                        href="{{ route('user-koordinator.index') }}?koordinator=kecamatan">
                                        Koordinator Kecamatan
                                    </a>
                                </li>
                                <li>
                                    <a class="group relative flex items-center gap-2.5 rounded-md px-4 font-bold text-gray-300 duration-300 ease-in-out hover:text-white"
                                        href="{{ route('user-koordinator.index') }}?koordinator=kelurahan-desa">
                                        Koordinator Kelurahan/Desa
                                    </a>
                                </li>

                            </ul>
                        </div>
                    </li> -->


                    <!-- <li>
                        <a class="@if (request()->is('saksi*')) active @endif group relative flex items-center gap-2.5 rounded-sm py-2 px-4 font-bold text-white duration-300 ease-in-out hover:bg-red-900 dark:hover:bg-meta-4"
                            href="{{ route('saksi.index') }}">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                viewBox="0 0 256 256">
                                <g fill="currentColor">
                                    <path d="M120 104a40 40 0 1 1-40-40a40 40 0 0 1 40 40" opacity="0.2" />
                                    <path
                                        d="M152 80a8 8 0 0 1 8-8h88a8 8 0 0 1 0 16h-88a8 8 0 0 1-8-8m96 40h-88a8 8 0 0 0 0 16h88a8 8 0 0 0 0-16m0 48h-64a8 8 0 0 0 0 16h64a8 8 0 0 0 0-16m-96.25 22a8 8 0 0 1-5.76 9.74a7.6 7.6 0 0 1-2 .26a8 8 0 0 1-7.75-6c-6.16-23.94-30.34-42-56.25-42s-50.09 18.05-56.25 42a8 8 0 0 1-15.5-4c5.59-21.71 21.84-39.29 42.46-48a48 48 0 1 1 58.58 0c20.63 8.71 36.88 26.29 42.47 48M80 136a32 32 0 1 0-32-32a32 32 0 0 0 32 32" />
                                </g>
                            </svg>

                            Saksi
                        </a>
                    </li> -->
                    <!-- <li>
                        <a class="@if (request()->is('pelatih*')) active @endif group relative flex items-center gap-2.5 rounded-sm py-2 px-4 font-bold text-white duration-300 ease-in-out hover:bg-red-900 dark:hover:bg-meta-4"
                            href="{{ route('pelatih.index') }}"
                            :class="{ 'bg-graydark dark:bg-meta-4': (selected === 'Tables') && (page === 'tables') }">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                viewBox="0 0 2048 2048">
                                <path fill="currentColor"
                                    d="M1168 946q38 15 74 33t70 41q-22 24-40 50t-33 56q-77-50-164-76t-179-26q-88 0-170 23t-153 64t-129 100t-100 130t-65 153t-23 170H128q0-120 35-231t101-205t156-167t204-115q-113-74-176-186t-64-248q0-106 40-199t109-163T696 40T896 0t199 40t163 109t110 163t40 200q0 66-16 129t-48 119t-75 103t-101 83M512 512q0 80 30 149t82 122t122 83t150 30q79 0 149-30t122-82t83-122t30-150q0-79-30-149t-82-122t-123-83t-149-30q-80 0-149 30t-122 82t-83 123t-30 149m1472 832q0 52-16 101t-48 91v512l-256-128l-256 128v-512q-31-42-47-91t-17-101q0-66 25-124t68-101t102-69t125-26t124 25t101 69t69 102t26 124m-320-192q-40 0-75 15t-61 41t-41 61t-15 75t15 75t41 61t61 41t75 15t75-15t61-41t41-61t15-75t-15-75t-41-61t-61-41t-75-15m128 689v-204q-60 27-128 27t-128-27v204q32-16 64-31t64-33q32 17 64 32t64 32" />
                            </svg>

                            Pelatih Saksi
                        </a>
                    </li> -->
                    {{-- <li>
                        <a class="group relative flex items-center gap-2.5 rounded-sm py-2 px-4 font-bold text-white duration-300 ease-in-out hover:bg-red-900 dark:hover:bg-meta-4"
                            href="{{route('dps.index')}}">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 256 256"><g fill="currentColor"><path d="M120 104a40 40 0 1 1-40-40a40 40 0 0 1 40 40" opacity="0.2"/><path d="M152 80a8 8 0 0 1 8-8h88a8 8 0 0 1 0 16h-88a8 8 0 0 1-8-8m96 40h-88a8 8 0 0 0 0 16h88a8 8 0 0 0 0-16m0 48h-64a8 8 0 0 0 0 16h64a8 8 0 0 0 0-16m-96.25 22a8 8 0 0 1-5.76 9.74a7.6 7.6 0 0 1-2 .26a8 8 0 0 1-7.75-6c-6.16-23.94-30.34-42-56.25-42s-50.09 18.05-56.25 42a8 8 0 0 1-15.5-4c5.59-21.71 21.84-39.29 42.46-48a48 48 0 1 1 58.58 0c20.63 8.71 36.88 26.29 42.47 48M80 136a32 32 0 1 0-32-32a32 32 0 0 0 32 32"/></g></svg>

                            DPS
                        </a>
                    </li> --}}
                    <li>
                        <a class="@if (request()->is('dpt*')) active @endif group relative flex items-center gap-2.5 rounded-sm py-2 px-4 font-bold text-white duration-300 ease-in-out hover:bg-red-900 dark:hover:bg-meta-4"
                            href="{{ route('dpt.index') }}">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                viewBox="0 0 256 256">
                                <g fill="currentColor">
                                    <path d="M120 104a40 40 0 1 1-40-40a40 40 0 0 1 40 40" opacity="0.2" />
                                    <path
                                        d="M152 80a8 8 0 0 1 8-8h88a8 8 0 0 1 0 16h-88a8 8 0 0 1-8-8m96 40h-88a8 8 0 0 0 0 16h88a8 8 0 0 0 0-16m0 48h-64a8 8 0 0 0 0 16h64a8 8 0 0 0 0-16m-96.25 22a8 8 0 0 1-5.76 9.74a7.6 7.6 0 0 1-2 .26a8 8 0 0 1-7.75-6c-6.16-23.94-30.34-42-56.25-42s-50.09 18.05-56.25 42a8 8 0 0 1-15.5-4c5.59-21.71 21.84-39.29 42.46-48a48 48 0 1 1 58.58 0c20.63 8.71 36.88 26.29 42.47 48M80 136a32 32 0 1 0-32-32a32 32 0 0 0 32 32" />
                                </g>
                            </svg>

                            DPT
                        </a>
                    </li>
                    <!-- <li>
                        <a class="@if (request()->is('suara*')) active @endif group relative flex items-center gap-2.5 rounded-sm py-2 px-4 font-bold text-white duration-300 ease-in-out hover:bg-red-900 dark:hover:bg-meta-4"
                            href="{{ route('suara.index') }}">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                viewBox="0 0 24 24">
                                <path fill="currentColor"
                                    d="m21.945 14.472l.021.062l.023.1l.01.1v6.516a.75.75 0 0 1-.65.743l-.1.007H2.75a.75.75 0 0 1-.743-.648L2 21.25v-6.5l.002-.052l.01-.086a1 1 0 0 1 .047-.153l2.76-6.019a.75.75 0 0 1 .573-.43l.108-.007l2.54-.001l-.79 1.37l-.067.13H5.98L3.918 14H20.07l-2.027-4.346l.862-1.497q.101.076.172.184l.053.095zm-8.58-12.416l.092.045l5.188 3.003c.328.19.458.591.319.933l-.045.092L16.112 11h1.138a.75.75 0 0 1 .102 1.494l-.102.007l-2.002-.001v.003h-4.079l-.003-.003H6.75a.75.75 0 0 1-.102-1.492l.102-.007L8.573 11l-.182-.105a.75.75 0 0 1-.318-.933l.044-.092l4.317-7.496c.19-.329.59-.46.931-.32m-.01 1.72L9.789 9.97L11.567 11h2.817l2.865-4.973z" />
                            </svg>

                            Suara
                        </a>
                    </li> -->
                    <li>
                        <a class="@if (request()->is('user-log*')) active @endif group relative flex items-center gap-2.5 rounded-sm py-2 px-4 font-bold text-white duration-300 ease-in-out hover:bg-red-900 dark:hover:bg-meta-4"
                            href="{{ route('user-log.index') }}">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                viewBox="0 0 48 48">
                                <g fill="none" stroke="currentColor" stroke-linejoin="round" stroke-width="4">
                                    <path d="M13 10h28v34H13z" />
                                    <path stroke-linecap="round" d="M35 10V4H8a1 1 0 0 0-1 1v33h6m8-16h12m-12 8h12" />
                                </g>
                            </svg>

                            User Log
                        </a>
                    </li>
                    <!-- <li>
                        <a class="@if (request()->is('pengumuman*')) active @endif group relative flex items-center gap-2.5 rounded-sm py-2 px-4 font-bold text-white duration-300 ease-in-out hover:bg-red-900 dark:hover:bg-meta-4"
                            href="{{ route('pengumuman.index') }}"
                            :class="{ 'bg-graydark dark:bg-meta-4': (selected === 'Tables') && (page === 'tables') }">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                viewBox="0 0 24 24">
                                <path fill="currentColor"
                                    d="M12 8H4a2 2 0 0 0-2 2v4a2 2 0 0 0 2 2h1v4a1 1 0 0 0 1 1h2a1 1 0 0 0 1-1v-4h3l5 4V4zm9.5 4c0 1.71-.96 3.26-2.5 4V8c1.53.75 2.5 2.3 2.5 4" />
                            </svg>
                            Pengumuman
                        </a>
                    </li> -->
                    <li>
                        <a class="@if (request()->is('generator-otp*')) active @endif group relative flex items-center gap-2.5 rounded-sm py-2 px-4 font-bold text-white duration-300 ease-in-out hover:bg-red-900 dark:hover:bg-meta-4"
                            href="{{ route('generator-otp.index') }}"
                            :class="{ 'bg-graydark dark:bg-meta-4': (selected === 'Tables') && (page === 'tables') }">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 15 15"><path fill="currentColor" d="M3.5 6a.5.5 0 0 0-.5.5v2a.5.5 0 0 0 1 0v-2a.5.5 0 0 0-.5-.5M11 7h.5a.5.5 0 0 0 0-1H11z"/><path fill="currentColor" fill-rule="evenodd" d="M0 1.5A1.5 1.5 0 0 1 1.5 0h12A1.5 1.5 0 0 1 15 1.5v12a1.5 1.5 0 0 1-1.5 1.5h-12A1.5 1.5 0 0 1 0 13.5zm2 5a1.5 1.5 0 1 1 3 0v2a1.5 1.5 0 1 1-3 0zM7 6H6V5h3v1H8v4H7zm3-1h1.5a1.5 1.5 0 0 1 0 3H11v2h-1z" clip-rule="evenodd"/></svg>
                            Generator OTP
                        </a>
                    </li>
                    
                </ul>
            </div>


        </nav>
        <!-- Sidebar Menu -->
    </div>
</aside>
