<div class="flex flex-col gap-5.5 p-6.5">
    <div>
        <label class="mb-3 block text-sm font-medium text-black dark:text-white">
            Kecamatan
        </label>
        <select name="kecamatan_id" class="relative z-20 w-full appearance-none rounded border border-stroke bg-transparent py-3 pl-5 pr-12 outline-none transition focus:border-primary active:border-primary dark:border-form-strokedark dark:bg-form-input">
            @foreach ($kecamatans as $kecamatan)
                <option value="{{ $kecamatan->id }}" @if (old('kecamatan_id', @$data->kecamatan_id) == $kecamatan->id) selected @endif>
                    {{ $kecamatan->nama }}
                </option>
            @endforeach
        </select>
        @error('nama')
            <span class="text-red-500 text-sm">{{ $message }}</span>
        @enderror
    </div>
    <div>
        <label class="mb-3 block text-sm font-medium text-black dark:text-white">
            Nama Kelurahan Desa
        </label>
        <input type="text" name="nama" placeholder="Nama..." value="{{ old('nama', @$data->nama) }}"
            class="w-full rounded-lg border-[1.5px] border-stroke bg-transparent px-4 py-2 font-normal text-black outline-none transition focus:border-primary active:border-primary disabled:cursor-default disabled:bg-whiter dark:border-form-strokedark dark:bg-form-input dark:text-white dark:focus:border-primary" />
        @error('nama')
            <span class="text-red-500 text-sm">{{ $message }}</span>
        @enderror
    </div>

    <button type="submit"
        class="inline-flex items-center justify-center rounded-md bg-primary px-10 py-4 text-center font-medium text-white hover:bg-opacity-90 lg:px-8 xl:px-10">Simpan</button>
</div>
