<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    @vite('resources/css/app.css')
    <title>
        {{ env('APP_NAME') }}
    </title>

    <style>
        .fadeOut {
            animation: fadeOut 5s forwards;
        }

        @keyframes fadeOut {
            90% {
                opacity: 1;
            }

            100% {
                opacity: 0;
            }
        }
    </style>

    @stack('styles')
</head>

<body class="bg-gray-200 m flex items-stretch justify-center min-h-screen sm:p-4">
    <div class="absolute w-full flex justify-stretch z-20">
        @session('warning')
            <div class="bg-yellow-100 border-l-4 border-yellow-500 text-yellow-700 p-4 mb-4 fadeOut" role="alert">
                <p class="font-bold">Warning</p>
                {{ session('warning') }}
            </div>
        @endsession
        @session('success')
            <div class="bg-green-100 border-l-4 border-green-500 text-green-700 p-4 mb-4 fadeOut" role="alert">
                <p class="font-bold">Success</p>
                <p>
                    {{ session('success') }}
                </p>
            </div>
        @endsession
        @session('error')
            <div class="bg-red-100 border-l-4 border-red-500 text-red-700 p-4 fadeOut" role="alert">
                <p class="font-bold">Error</p>
                {{ session('error') }}
            </div>
        @endsession
    </div>
    <div class="w-full h-auto sm:w-full sm:max-w-md flex flex-col bg-white sm:shadow-xl sm:rounded-lg overflow-hidden">

        <main class="flex-1 overflow-y-auto p-4 mb-20">
            @yield('content')
        </main>
        <nav class="bg-gray-2 shadow-lg fixed md:relative bottom-0 left-0 right-0">
            <ul class="flex justify-around">
                <li class="flex-1 ">
                    <a href="{{ route('user-saksi.home') }}" class="flex flex-col items-center py-2">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                            <g fill="none" stroke="#3C50E0" stroke-linecap="round" stroke-linejoin="round"
                                stroke-width="2">
                                <path d="M15 21v-8a1 1 0 0 0-1-1h-4a1 1 0 0 0-1 1v8" />
                                <path
                                    d="M3 10a2 2 0 0 1 .709-1.528l7-5.999a2 2 0 0 1 2.582 0l7 5.999A2 2 0 0 1 21 10v9a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2z" />
                            </g>
                        </svg>
                        <span class="text-xs mt-1 text-gray-600">Home</span>
                    </a>
                </li>
                <li class="flex-1">
                    <a href="{{ route('user-saksi.lihat-calon.index') }}" class="flex flex-col items-center py-2">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                            <path fill="none" stroke="#3C50E0" stroke-linecap="round" stroke-linejoin="round"
                                stroke-width="2" d="M18 20V10m-6 10V4M6 20v-6" />
                        </svg>
                        <span class="text-xs mt-1 text-blue-600">Results</span>
                    </a>
                </li>
                <li class="flex-1">
                    <a href="{{ route('user-saksi.profile.index') }}" class="flex flex-col items-center py-2">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                            <g fill="none" stroke="#3C50E0" stroke-width="2.5">
                                <path stroke-linejoin="round"
                                    d="M4 18a4 4 0 0 1 4-4h8a4 4 0 0 1 4 4a2 2 0 0 1-2 2H6a2 2 0 0 1-2-2Z" />
                                <circle cx="12" cy="7" r="3" />
                            </g>
                        </svg>
                        <span class="text-xs mt-1 text-gray-600">Profile</span>
                    </a>
                </li>
            </ul>
        </nav>
    </div>
    @vite(['resources/js/app.js'])
    <script>
        const forms = document.querySelectorAll('form');

        forms.forEach((form) => {
            form.addEventListener('submit', (e) => {
                var button = form.querySelector('button[type="submit"]');
                if (button) {
                    button.disabled = true;
                    button.innerHTML = "Loading...";
                }
            });
        });
    </script>
    @stack('scripts')
</body>

</html>
