@extends('dashboard-saksi.layouts.app')

@section('content')
    <div class="flex items-center py-4 bg-white border-b">
        {{-- <button class="mr-4">
            <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M15 19l-7-7 7-7" />
            </svg>
        </button> --}}
        <span class="font-semibold">Input Suara</span>
    </div>

    <div>
        <form id="electionForm" action="{{ route('user-saksi.input-suara.save') }}" method="POST">
            <div class="bg-white mb-4 overflow-hidden border">
                <div class="flex items-stretch p-3 border-b justify-stretch">
                    <img src="{{ url('images/logo-kpu.png') }}" alt="KPU Logo" class="w-12 h-12 mr-3" />
                    <div class="flex-grow text-end px-2 bg-gray-100">
                        <div class="text-sm text-gray-600">MODEL C1-PLANO-KWK</div>
                        <div class="font-semibold">GUBERNUR</div>
                    </div>
                    <div class="bg-gray-200 w-8 flex items-center justify-center">
                        <span class="font-bold">3</span>
                    </div>
                </div>

                @csrf
                <table class="w-full border-collapse">
                    <thead>
                        <tr>
                            <th class="py-2 px-4 text-left w-12 border border-gray-500 bg-gray-300">No</th>
                            <th class="py-2 px-4 text-left border border-gray-500 bg-gray-300">Pasangan Gubernur / Wakil</th>
                            <th class="py-2 px-4 text-left border border-gray-500 bg-gray-300">Suara</th>
                        </tr>
                    </thead>
                    <tbody id="candidatesContainer">
                        
                    </tbody>
                </table>
            </div>
            <button class="w-full bg-blue-800 text-white py-3 rounded-lg font-medium">
                Submit
            </button>

        </form>
    </div>
@endsection

@push('scripts')
    <script>
        function removeLeadingZero(event) {
            let value = event.target.value;
            event.target.value = parseInt(value, 10) || 0; // Set to 0 if empty or invalid
        }

        // Function to add event listeners to all number inputs
        function attachListenersToNumberInputs() {
            const numberInputs = document.querySelectorAll('input[type="number"]');
            numberInputs.forEach(input => {
                input.addEventListener('input', removeLeadingZero);
                input.addEventListener('blur', function() {
                    if (this.value === '' || isNaN(this.value)) {
                        this.value = 0;
                    }
                });
            });
        }

        // Attach event listeners when the DOM is fully loaded
        document.addEventListener('DOMContentLoaded', attachListenersToNumberInputs);

        const candidates = @json($calons);
        let invalidVotes = {{ old('suara_tidak_sah', @$suara->suara_tidak_sah ?? 0) }};
        let validVotes = {{ old('suara_tidak_sah', @$suara->suara_sah ?? 0) }};
        const saveData = debounce(saveSuara, 1000);

        function renderCandidates() {
            const container = document.getElementById('candidatesContainer');
            container.innerHTML = '';
            candidates.forEach((candidate, index) => {
                const div = document.createElement('tr');
                // div.class = 'space-y-2 mb-4';
                div.innerHTML = `
                <td class="py-3 px-4 border border-gray-500">${candidate.nomor}</td>
              <td class="py-3 px-4 border border-gray-500">
                <div class="font-medium">${candidate.nama_calon}</div>
                <div class="text-sm text-gray-600">${candidate.nama_wakil_calon}</div>
              </td>
              <td class="py-3 px-4 border border-gray-500">
                <input id="candidate-${index}" name="jumlah_suara[${candidate.id}]" type="number" value="${candidate.votes}" min="0" class="w-full text-center border rounded-md p-2" onchange="handleVoteChange(${index}, this.value)">
              </td>
                
            `;
                container.appendChild(div);
            });
        }

        function handleVoteChange(index, votes) {
            candidates[index].votes = Math.max(0, parseInt(votes) || 0);
            updateSummary();
        }

        function handleIncrement(index) {
            candidates[index].votes++;
            document.getElementById(`candidate-${index}`).value = candidates[index].votes;
            updateSummary();
        }

        function handleDecrement(index) {
            candidates[index].votes = Math.max(0, candidates[index].votes - 1);
            document.getElementById(`candidate-${index}`).value = candidates[index].votes;
            updateSummary();
        }

        function handleInvalidVotesChange(votes) {
            invalidVotes = Math.max(0, parseInt(votes) || 0);
            updateSummary();
        }

        function handleValidVotesChange(votes) {
            validVotes = Math.max(0, parseInt(votes) || 0);
            updateSummary();
        }

        function handleInvalidIncrement() {
            invalidVotes++;
            document.getElementById('invalid-votes').value = invalidVotes;
            updateSummary();
        }

        function handleInvalidDecrement() {
            invalidVotes = Math.max(0, invalidVotes - 1);
            document.getElementById('invalid-votes').value = invalidVotes;
            updateSummary();
        }

        function handleValidIncrement() {
            validVotes++;
            document.getElementById('valid-votes').value = validVotes;
            updateSummary();
        }

        function handleValidDecrement() {
            validVotes = Math.max(0, validVotes - 1);
            document.getElementById('valid-votes').value = validVotes;
            updateSummary();
        }

        function updateSummary() {


            saveData();
        }





        function debounce(func, wait, immediate) {
            // 'private' variable for instance
            // The returned function will be able to reference this due to closure.
            // Each call to the returned function will share this common timer.
            var timeout;
            // Calling debounce returns a new anonymous function
            return function() {

                // reference the context and args for the setTimeout function
                var context = this,
                    args = arguments;

                // Should the function be called now? If immediate is true
                //   and not already in a timeout then the answer is: Yes
                var callNow = immediate && !timeout;

                // This is the basic debounce behaviour where you can call this
                //   function several times, but it will only execute once
                //   (before or after imposing a delay).
                //   Each time the returned function is called, the timer starts over.
                clearTimeout(timeout);

                // Set the new timeout
                timeout = setTimeout(function() {

                    // Inside the timeout function, clear the timeout variable
                    // which will let the next execution run when in 'immediate' mode
                    timeout = null;

                    // Check if the function already ran with the immediate flag
                    if (!immediate) {
                        // Call the original function with apply
                        // apply lets you define the 'this' object as well as the arguments
                        //    (both captured before setTimeout)
                        func.apply(context, args);
                    }
                }, wait);

                // Immediate mode and no wait timer? Execute the function...
                if (callNow) func.apply(context, args);
            }
        }

        async function saveSuara() {
            console.log("SAVE");
            try {
                const response = await fetch("{{ url('user-saksi/ajax/save-suara') }}", {
                    method: "POST",
                    headers: {
                        'X-CSRF-TOKEN': "{{ csrf_token() }}",
                        'Content-Type': 'application/json',
                        'Accept': 'application/json',
                    },
                    body: JSON.stringify({
                        candidates: candidates,
                        invalidVotes: invalidVotes,
                        validVotes: validVotes,
                        // jumlah_dpt: document.getElementById("jumlah_dpt").value,
                        // jumlah_hak_pilih: document.getElementById("jumlah_hak_pilih").value,
                    })
                });
                if (!response.ok && response.status != 402) {
                    throw new Error(`Response status: ${response.status}`);

                }

                if (response.status == 200) {
                    const json = await response.json();
                }
            } catch (error) {
                alert(error.message);
                console.error(error.message);
            }
        }

        renderCandidates();
        updateSummary();
    </script>
@endpush
