@extends('dashboard-saksi.layouts.app')

@push('scripts')
    <script>
        file_1.onchange = evt => {
            const [file] = file_1.files
            if (file) {
                document.getElementById("preview-image-1").src = URL.createObjectURL(file)
            }
        }

        file_2.onchange = evt => {
            const [file] = file_2.files
            if (file) {
                document.getElementById("preview-image-2").src = URL.createObjectURL(file)
            }
        }

        file_3.onchange = evt => {
            const [file] = file_3.files
            if (file) {
                document.getElementById("preview-image-3").src = URL.createObjectURL(file)
            }
        }
    </script>
@endpush

@section('content')
    <div class="flex items-center py-4 bg-white border-b">

        <span class="font-semibold"> Upload Foto C.HASIL-KWK</span>
    </div>
    <form id="electionForm" class="p-4 space-y-4" action="{{ route('user-saksi.input-lampiran.save') }}" method="POST"
        enctype="multipart/form-data">
        @csrf
        <div>

            <label for="file_1">Lembar 1</label>
            <input type="file" id="file_1" name="file_1" accept="image,.jpg,.png,.jpeg,.tiff,.webp"
                class="w-full cursor-pointer rounded-lg border-[1.5px] border-stroke bg-transparent font-normal outline-none transition file:mr-5 file:border-collapse file:cursor-pointer file:border-0 file:border-r file:border-solid file:border-stroke file:bg-whiter file:px-5 file:py-3 file:hover:bg-primary file:hover:bg-opacity-10 focus:border-primary active:border-primary disabled:cursor-default disabled:bg-whiter dark:border-form-strokedark dark:bg-form-input dark:file:border-form-strokedark dark:file:bg-white/30 dark:file:text-white dark:focus:border-primary" />
            @error('file_1')
                <span class="text-red-500 text-sm">{{ $message }}</span>
            @enderror
        </div>

        @if (isset($file1))
            <div>
                <a href="{{ route('user-saksi.file-lampiran.get', $file1->id) }}" target="_blank">
                    <img id="preview-image" src="{{ route('user-saksi.file-lampiran.get', $file1->id) }}"
                        alt="{{ $file1->nama }}" class="w-full h-50 object-contain">
                </a>
            </div>
        @else
            <div>
                <img src="#" id="preview-image-1" class="w-full h-50 object-contain">
            </div>
        @endif


        <div>

            <label for="file_2">Lembar 2</label>
            <input type="file" id="file_2" name="file_2" accept="image,.jpg,.png,.jpeg,.tiff,.webp"
                class="w-full cursor-pointer rounded-lg border-[1.5px] border-stroke bg-transparent font-normal outline-none transition file:mr-5 file:border-collapse file:cursor-pointer file:border-0 file:border-r file:border-solid file:border-stroke file:bg-whiter file:px-5 file:py-3 file:hover:bg-primary file:hover:bg-opacity-10 focus:border-primary active:border-primary disabled:cursor-default disabled:bg-whiter dark:border-form-strokedark dark:bg-form-input dark:file:border-form-strokedark dark:file:bg-white/30 dark:file:text-white dark:focus:border-primary" />
            @error('file_2')
                <span class="text-red-500 text-sm">{{ $message }}</span>
            @enderror
        </div>

        @if (isset($file2))
            <div>
                <a href="{{ route('user-saksi.file-lampiran.get', $file2->id) }}" target="_blank">
                    <img id="preview-image-2" src="{{ route('user-saksi.file-lampiran.get', $file2->id) }}"
                        alt="{{ $file2->nama }}" class="w-full h-50 object-contain">
                </a>
            </div>
        @else
            <div>
                <img src="#" id="preview-image-2" class="w-full h-50 object-contain">
            </div>
        @endif

        <div>

            <label for="file_3">Lembar 3</label>
            <input type="file" id="file_3" name="file_3" accept="image,.jpg,.png,.jpeg,.tiff,.webp"
                class="w-full cursor-pointer rounded-lg border-[1.5px] border-stroke bg-transparent font-normal outline-none transition file:mr-5 file:border-collapse file:cursor-pointer file:border-0 file:border-r file:border-solid file:border-stroke file:bg-whiter file:px-5 file:py-3 file:hover:bg-primary file:hover:bg-opacity-10 focus:border-primary active:border-primary disabled:cursor-default disabled:bg-whiter dark:border-form-strokedark dark:bg-form-input dark:file:border-form-strokedark dark:file:bg-white/30 dark:file:text-white dark:focus:border-primary" />
            @error('file_3')
                <span class="text-red-500 text-sm">{{ $message }}</span>
            @enderror
        </div>

        @if (isset($file3))
            <div>
                <a href="{{ route('user-saksi.file-lampiran.get', $file3->id) }}" target="_blank">
                    <img id="preview-image-3" src="{{ route('user-saksi.file-lampiran.get', $file3->id) }}"
                        alt="{{ $file3->nama }}" class="w-full h-50 object-contain">
                </a>
            </div>
        @else
            <div>
                <img src="#" id="preview-image-3" class="w-full h-50 object-contain">
            </div>
        @endif

        <button type="submit" class="w-full bg-blue-800 text-white py-3 rounded-lg font-medium">
            Submit
        </button>
        @if (isset($suara) && $suara->status == 'reject')
            <p class="text-yellow-500">
                *Input suara anda ditolak, silahkan periksa kembali dan submit ulang
            </p>
        @endif
        <div class="h-15"></div>
    </form>
@endsection
