<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Sign In | {{ env('APP_NAME') }}</title>
    @vite('resources/css/app.css')
</head>

<body x-data="{ 'darkMode': true }" x-init="darkMode = JSON.parse(localStorage.getItem('darkMode'));
$watch('darkMode', value => localStorage.setItem('darkMode', JSON.stringify(value)))" :class="{ 'dark text-bodydark bg-boxdark-2': darkMode === true }"
    class="h-screen">
    <div class="flex h-full">
        <div class="w-full flex flex-col justify-center items-center p-8 bg-white">
            <div class="w-full max-w-md">
                <div class="text-center mb-8">
                    <h1 class="text-4xl font-bold text-redTheme mb-2">Data Surat</h1>
                    <p class="text-red-600">{{env("APP_NAME")}}</p>
                </div>

                <div class="mb-6 text-center">
                    <h2 class="text-xl font-semibold text-gray-700 mb-2">Login</h2>
                    <p class="text-sm text-gray-500">Masuk menggunakan akun terdaftar</p>
                </div>
                <form action="{{ route('auth') }}" method="POST" class="space-y-4 mb-6" id="loginForm">
                    @csrf
                    @session('error')
                        <div class="mb-4">
                            <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative"
                                role="alert">
                                <strong class="font-bold">Error!</strong>
                                <span class="block sm:inline">{{ session('error') }}</span>
                            </div>
                        </div>
                    @endsession
                    @session('warning')
                        <div class="mb-4">
                            <div class="bg-yellow-100 border border-yellow-400 text-yellow-700 px-4 py-3 rounded relative"
                                role="alert">
                                <strong class="font-bold">Warning!</strong>
                                <span class="block sm:inline">{{ session('warning') }}</span>
                            </div>
                        </div>
                    @endsession
                    <div class="space-y-2">
                        <div class="relative">
                            <input type="number" maxlength="20" minlength="10" required name="no_wa"
                                class="w-full px-4 py-2 border rounded-md focus:outline-none focus:ring-1 focus:ring-blue-600 pl-10"
                                placeholder="No Whatsapp (08xxxxxx)">
                            <svg xmlns="http://www.w3.org/2000/svg"
                                class="h-5 w-5 absolute left-3 top-2.5 text-gray-400" viewBox="0 0 20 20"
                                fill="currentColor">
                                <path fill-rule="evenodd" d="M10 9a3 3 0 100-6 3 3 0 000 6zm-7 9a7 7 0 1114 0H3z"
                                    clip-rule="evenodd" />
                            </svg>
                        </div>
                        @error('no_wa')
                            <span class="text-red-500 text-xs mt-1">{{ $message }}</span>
                        @enderror
                    </div>

                    <button type="submit" id="submitForm"
                        class="w-full bg-blueTheme text-white py-2 px-4 rounded-md hover:bg-blue-900 transition duration-300">
                        Login
                    </button>
                </form>
                
            </div>
        </div>

    </div>

    @vite('resources/js/app.js')

    <script>
        const form = document.getElementById('loginForm');
        const inputs = form.querySelectorAll('input[type="text"]');
        form.addEventListener('submit', (e) => {
            // e.preventDefault();
            inputs.forEach((input) => {
                input.readOnly = true;
                
            });
            document.getElementById("submitForm").disabled = true;
            document.getElementById("submitForm").innerHTML = "Loading...";
        });
    </script>
</body>

</html>
