<?php

namespace Database\Seeders;

use App\Models\Calon;
use App\Models\Suara;
use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class SuaraSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $saksis = User::where('role','=','saksi')->get();
        $calons = Calon::all();

        foreach ($saksis as $key => $saksi) {
            $details = [];
            $total_suara = 0;
            foreach ($calons as $calon) {
                $jumlah_suara = random_int(1000,10000);
                $total_suara += $jumlah_suara;
                $details[] = [
                    'calon_id'=>$calon->id,
                    'jumlah_suara'=>$jumlah_suara
                ];
            }
            $suara = Suara::where('tps_id',$saksi->tps_id)->first();
            $suara_tidak_sah = random_int(0,100);
            if(!$suara){
                $suara = Suara::create([
                    'user_id'=>$saksi->id,
                    'tps_id'=>$saksi->tps_id,
                    'tanggal'=>date("Y-m-d"),
                    'total_suara'=>$total_suara+$suara_tidak_sah,
                    'suara_tidak_sah'=>$suara_tidak_sah,
                    'status'=>'approve'
                ]);
            } else {
                $suara->update([
                    'total_suara'=>$total_suara+$suara_tidak_sah,
                    'suara_tidak_sah'=>$suara_tidak_sah
                ]);
            }

            foreach ($details as $detail) {
                $suara->suara_details()->updateOrCreate([
                    'calon_id'=>$detail['calon_id']
                ],[
                    'jumlah_suara'=>$detail['jumlah_suara']
                ]);
            }
        }
    }
}
