<?php

namespace Database\Seeders;

use App\Models\Dpt;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class SaksiSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $dpts = Dpt::with('tps.kelurahan_desa.kecamatan.kabupaten_kota.provinsi')->limit(10)->get();
        foreach ($dpts as $index => $dpt) {
            $dpt->users()->create([
                'nama' => 'Saksi '.$index,
                'no_telp'=> '08100000000'.$index,
                'email' => 'saksi'.$index.'@email.com',
                'password' => bcrypt('password'),
                'role' => 'saksi',
                'tps_id'=>$dpt->tps_id,
                'kelurahan_desa_id'=>$dpt->tps->kelurahan_desa_id,
                'kecamatan_id'=>$dpt->tps->kelurahan_desa->kecamatan_id,
                'kabupaten_kota_id'=>$dpt->tps->kelurahan_desa->kecamatan->kabupaten_kota_id,
                'provinsi_id'=>$dpt->tps->kelurahan_desa->kecamatan->kabupaten_kota->provinsi_id
            ]);
        }
    }
}
