<?php

namespace Database\Seeders;

use App\Imports\DptImport;
use FilesystemIterator;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Maatwebsite\Excel\Facades\Excel;

class DptSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {   
        echo storage_path('sample') , PHP_EOL;
        $it = new FilesystemIterator(storage_path('sample'));
        foreach ($it as $fileinfo) {
            echo $fileinfo->getPathname() , PHP_EOL;
            $import = Excel::import(new DptImport,$fileinfo->getPathname());
        }
    }
}
