<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('pengumumen', function (Blueprint $table) {
            $table->unsignedBigInteger('provinsi_id')->nullable()->index();
            $table->unsignedBigInteger('kabupaten_kota_id')->nullable()->index();
            $table->unsignedBigInteger('kecamatan_id')->nullable()->index();
            $table->unsignedBigInteger('kelurahan_desa_id')->nullable()->index();
            $table->unsignedBigInteger('user_saksi_id')->nullable()->index();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('pengumumen', function (Blueprint $table) {
            $table->dropColumn('provinsi_id');
            $table->dropColumn('kabupaten_kota_id');
            $table->dropColumn('kecamatan_id');
            $table->dropColumn('kelurahan_desa_id');
            $table->dropColumn('user_saksi_id');
        });
    }
};
