<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('pelatihs', function (Blueprint $table) {
            $table->id();
            $table->string('nama');
            $table->string('no_wa',20)->nullable();
            $table->string('nik')->nullable();
            $table->string('email')->nullable();
            $table->unsignedBigInteger('provinsi_id')->index()->nullable();
            $table->unsignedBigInteger('kabupaten_kota_id')->index()->nullable();
            $table->unsignedBigInteger('kecamatan_id')->index()->nullable();
            $table->unsignedBigInteger('kelurahan_desa_id')->index()->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('pelatihs');
    }
};
