<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tpsables', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('tps_id')->index();
            $table->unsignedBigInteger('tpsable_id')->index();
            $table->string('tpsable_type')->index();
            $table->foreign('tps_id')->references('id')->on('tps')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tpsables');
    }
};
