<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('suaras',function (Blueprint $table){
            $table->integer('suara_sah',false)->after('suara_tidak_sah');
            $table->boolean('bermasalah_paslon')->default(false)->after('suara_sah');
            $table->boolean('bermasalah_hak_pilih')->default(false)->after('bermasalah_paslon');
            $table->boolean('menang')->default(false)->after('bermasalah_hak_pilih');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('suaras',function (Blueprint $table){
            $table->dropColumn('suara_sah');
            $table->dropColumn('bermasalah_paslon');
            $table->dropColumn('bermasalah_hak_pilih');
            $table->dropColumn('menang');
        });
    }
};
