<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('dpt', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('tps_id')->index();

            $table->string('nik',16)->nullable();
            $table->string('no_kk',20)->nullable();
            $table->string('nama',150);
            $table->enum('jenis_kelamin',['L','P']);
            $table->integer('usia',false);
            $table->string('rt',3)->nullable();
            $table->string('rw',3)->nullable();
            $table->text('alamat')->nullable();
            $table->text('ket')->nullable();
            $table->timestamps();
            $table->softDeletes();

            $table->foreign('tps_id')->references('id')->on('tps')->onDelete('cascade');
            $table->index(['created_at','deleted_at']);
        });

        Schema::table('users',function(Blueprint $table){
            $table->unsignedBigInteger('dpt_id')->nullable()->index()->after('dps_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('dpts');

        Schema::table('users',function(Blueprint $table){
            $table->dropColumn('dpt_id');
        });
    }
};
